/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.compiler.commons.codegenfactories;

import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.body.VariableDeclarator;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.expr.ObjectCreationExpr;
import com.github.javaparser.ast.stmt.BlockStmt;
import org.dmg.pmml.Interval;
import org.kie.pmml.api.enums.CLOSURE;
import org.kie.pmml.api.exceptions.KiePMMLException;
import org.kie.pmml.compiler.commons.utils.CommonCodegenUtils;
import org.kie.pmml.compiler.commons.utils.JavaParserUtils;

public class KiePMMLIntervalFactory {
    static final String KIE_PMML_INTERVAL_TEMPLATE_JAVA = "KiePMMLIntervalTemplate.tmpl";
    static final String KIE_PMML_INTERVAL_TEMPLATE = "KiePMMLIntervalTemplate";
    static final String GETKIEPMMLINTERVAL = "getKiePMMLInterval";
    static final String INTERVAL = "interval";
    static final ClassOrInterfaceDeclaration INTERVAL_TEMPLATE;

    private KiePMMLIntervalFactory() {
    }

    static BlockStmt getIntervalVariableDeclaration(String variableName, Interval interval) {
        MethodDeclaration methodDeclaration = ((MethodDeclaration)INTERVAL_TEMPLATE.getMethodsByName(GETKIEPMMLINTERVAL).get(0)).clone();
        BlockStmt toReturn = (BlockStmt)methodDeclaration.getBody().orElseThrow(() -> new KiePMMLException(String.format("Missing body in %s", methodDeclaration)));
        VariableDeclarator variableDeclarator = CommonCodegenUtils.getVariableDeclarator(toReturn, INTERVAL).orElseThrow(() -> new KiePMMLException(String.format("Missing expected variable '%s' in body %s", INTERVAL, toReturn)));
        variableDeclarator.setName(variableName);
        ObjectCreationExpr objectCreationExpr = ((Expression)variableDeclarator.getInitializer().orElseThrow(() -> new KiePMMLException(String.format("Missing '%s' initializer in %s", INTERVAL, toReturn)))).asObjectCreationExpr();
        Expression leftMarginExpr = CommonCodegenUtils.getExpressionForObject(interval.getLeftMargin());
        Expression rightMarginExpr = CommonCodegenUtils.getExpressionForObject(interval.getRightMargin());
        CLOSURE closure = CLOSURE.byName((String)interval.getClosure().value());
        NameExpr closureExpr = new NameExpr(CLOSURE.class.getName() + "." + closure.name());
        objectCreationExpr.getArguments().set(0, (Node)leftMarginExpr);
        objectCreationExpr.getArguments().set(1, (Node)rightMarginExpr);
        objectCreationExpr.getArguments().set(2, (Node)closureExpr);
        return toReturn;
    }

    static {
        CompilationUnit cloneCU = JavaParserUtils.getFromFileName(KIE_PMML_INTERVAL_TEMPLATE_JAVA);
        INTERVAL_TEMPLATE = (ClassOrInterfaceDeclaration)cloneCU.getClassByName(KIE_PMML_INTERVAL_TEMPLATE).orElseThrow(() -> new KiePMMLException("Main class not found: KiePMMLIntervalTemplate"));
        ((MethodDeclaration)INTERVAL_TEMPLATE.getMethodsByName(GETKIEPMMLINTERVAL).get(0)).clone();
    }
}

