/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.compiler.commons.codegenfactories;

import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.body.VariableDeclarator;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.expr.ObjectCreationExpr;
import com.github.javaparser.ast.expr.StringLiteralExpr;
import com.github.javaparser.ast.stmt.BlockStmt;
import org.dmg.pmml.DefineFunction;
import org.dmg.pmml.ParameterField;
import org.kie.pmml.api.exceptions.KiePMMLException;
import org.kie.pmml.compiler.commons.codegenfactories.KiePMMLExpressionFactory;
import org.kie.pmml.compiler.commons.codegenfactories.KiePMMLParameterFieldFactory;
import org.kie.pmml.compiler.commons.utils.CommonCodegenUtils;
import org.kie.pmml.compiler.commons.utils.JavaParserUtils;

public class KiePMMLDefineFunctionFactory {
    static final String KIE_PMML_DEFINE_FUNCTION_TEMPLATE_JAVA = "KiePMMLDefineFunctionTemplate.tmpl";
    static final String KIE_PMML_DEFINE_FUNCTION_TEMPLATE = "KiePMMLDefineFunctionTemplate";
    static final String GETKIEPMMLDEFINEFUNCTION = "getKiePMMLDefineFunction";
    static final String DEFINE_FUNCTION = "defineFunction";
    static final ClassOrInterfaceDeclaration DEFINE_FUNCTION_TEMPLATE;

    private KiePMMLDefineFunctionFactory() {
    }

    static BlockStmt getDefineFunctionVariableDeclaration(DefineFunction defineFunction) {
        MethodDeclaration methodDeclaration = ((MethodDeclaration)DEFINE_FUNCTION_TEMPLATE.getMethodsByName(GETKIEPMMLDEFINEFUNCTION).get(0)).clone();
        BlockStmt defineFunctionBody = (BlockStmt)methodDeclaration.getBody().orElseThrow(() -> new KiePMMLException(String.format("Missing body in %s", methodDeclaration)));
        VariableDeclarator variableDeclarator = CommonCodegenUtils.getVariableDeclarator(defineFunctionBody, DEFINE_FUNCTION).orElseThrow(() -> new KiePMMLException(String.format("Missing expected variable '%s' in body %s", DEFINE_FUNCTION, defineFunctionBody)));
        variableDeclarator.setName(defineFunction.getName());
        BlockStmt toReturn = new BlockStmt();
        int counter = 0;
        NodeList parameterFieldArguments = new NodeList();
        for (ParameterField parameterField : defineFunction.getParameterFields()) {
            String nestedVariableName = String.format("%s_%s", defineFunction.getName(), counter);
            parameterFieldArguments.add((Node)new NameExpr(nestedVariableName));
            BlockStmt toAdd = KiePMMLParameterFieldFactory.getParameterFieldVariableDeclaration(nestedVariableName, parameterField);
            toAdd.getStatements().forEach(arg_0 -> ((BlockStmt)toReturn).addStatement(arg_0));
            ++counter;
        }
        String kiePMMLExpression = String.format("%s_Expression", defineFunction.getName());
        BlockStmt toAdd = KiePMMLExpressionFactory.getKiePMMLExpressionBlockStmt(kiePMMLExpression, defineFunction.getExpression());
        toAdd.getStatements().forEach(arg_0 -> ((BlockStmt)toReturn).addStatement(arg_0));
        ObjectCreationExpr objectCreationExpr = ((Expression)variableDeclarator.getInitializer().orElseThrow(() -> new KiePMMLException(String.format("Missing '%s' initializer in %s", DEFINE_FUNCTION, toReturn)))).asObjectCreationExpr();
        StringLiteralExpr nameExpr = new StringLiteralExpr(defineFunction.getName());
        objectCreationExpr.getArguments().set(0, (Node)nameExpr);
        Expression dataTypeExpression = CommonCodegenUtils.getExpressionForDataType(defineFunction.getDataType());
        Expression opTypeExpression = CommonCodegenUtils.getExpressionForOpType(defineFunction.getOpType());
        objectCreationExpr.getArguments().set(2, (Node)dataTypeExpression);
        objectCreationExpr.getArguments().set(3, (Node)opTypeExpression);
        ((Expression)objectCreationExpr.getArguments().get(4)).asMethodCallExpr().setArguments(parameterFieldArguments);
        objectCreationExpr.getArguments().set(5, (Node)new NameExpr(kiePMMLExpression));
        defineFunctionBody.getStatements().forEach(arg_0 -> ((BlockStmt)toReturn).addStatement(arg_0));
        return toReturn;
    }

    static {
        CompilationUnit cloneCU = JavaParserUtils.getFromFileName(KIE_PMML_DEFINE_FUNCTION_TEMPLATE_JAVA);
        DEFINE_FUNCTION_TEMPLATE = (ClassOrInterfaceDeclaration)cloneCU.getClassByName(KIE_PMML_DEFINE_FUNCTION_TEMPLATE).orElseThrow(() -> new KiePMMLException("Main class not found: KiePMMLDefineFunctionTemplate"));
        ((MethodDeclaration)DEFINE_FUNCTION_TEMPLATE.getMethodsByName(GETKIEPMMLDEFINEFUNCTION).get(0)).clone();
    }
}

