/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.compiler.commons.factories;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.dmg.pmml.Model;
import org.dmg.pmml.OutputField;
import org.kie.pmml.api.enums.RESULT_FEATURE;
import org.kie.pmml.commons.model.KiePMMLOutputField;
import org.kie.pmml.compiler.commons.factories.KiePMMLExtensionFactory;

public class KiePMMLOutputFieldFactory {
    private KiePMMLOutputFieldFactory() {
    }

    public static List<KiePMMLOutputField> getOutputFields(Model model) {
        ArrayList<KiePMMLOutputField> outputFields = new ArrayList<KiePMMLOutputField>();
        if (model.getOutput() != null) {
            outputFields.addAll(model.getOutput().getOutputFields().stream().map(KiePMMLOutputFieldFactory::getKiePMMLOutputField).collect(Collectors.toList()));
        }
        return outputFields;
    }

    public static KiePMMLOutputField getKiePMMLOutputField(OutputField outputField) {
        return (KiePMMLOutputField)KiePMMLOutputField.builder((String)outputField.getName().getValue(), KiePMMLExtensionFactory.getKiePMMLExtensions(outputField.getExtensions())).withResultFeature(RESULT_FEATURE.byName((String)outputField.getResultFeature().value())).withTargetField(outputField.getTargetField() != null ? outputField.getTargetField().getValue() : null).withValue(outputField.getValue()).withRank(outputField.getRank()).build();
    }
}

