/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.commons.model.expressions;

import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import org.kie.pmml.commons.model.KiePMMLOutputField;
import org.kie.pmml.commons.model.tuples.KiePMMLNameValue;
import org.kie.pmml.commons.transformations.KiePMMLDefineFunction;
import org.kie.pmml.commons.transformations.KiePMMLDerivedField;

public class ExpressionsUtils {
    private ExpressionsUtils() {
    }

    public static Optional<Object> getFromPossibleSources(String name, List<KiePMMLDefineFunction> defineFunctions, List<KiePMMLDerivedField> derivedFields, List<KiePMMLOutputField> outputFields, List<KiePMMLNameValue> kiePMMLNameValues) {
        return Stream.of(ExpressionsUtils.getFromKiePMMLNameValues(name, kiePMMLNameValues), ExpressionsUtils.getFromDerivedFields(name, defineFunctions, derivedFields, outputFields, kiePMMLNameValues), ExpressionsUtils.getFromOutputFields(name, defineFunctions, derivedFields, outputFields, kiePMMLNameValues)).filter(Optional::isPresent).findFirst().map(Optional::get);
    }

    public static Optional<Object> getFromKiePMMLNameValues(String name, List<KiePMMLNameValue> kiePMMLNameValues) {
        return kiePMMLNameValues.stream().filter(kiePMMLNameValue -> kiePMMLNameValue.getName().equals(name)).findFirst().map(KiePMMLNameValue::getValue);
    }

    public static Optional<Object> getFromDerivedFields(String name, List<KiePMMLDefineFunction> defineFunctions, List<KiePMMLDerivedField> derivedFields, List<KiePMMLOutputField> outputFields, List<KiePMMLNameValue> kiePMMLNameValues) {
        return derivedFields.stream().filter(derivedField -> derivedField.getName().equals(name)).findFirst().map(derivedField -> derivedField.evaluate(defineFunctions, derivedFields, outputFields, kiePMMLNameValues));
    }

    public static Optional<Object> getFromOutputFields(String name, List<KiePMMLDefineFunction> defineFunctions, List<KiePMMLDerivedField> derivedFields, List<KiePMMLOutputField> outputFields, List<KiePMMLNameValue> kiePMMLNameValues) {
        return outputFields.stream().filter(outputField -> outputField.getName().equals(name)).findFirst().map(outputField -> outputField.evaluate(defineFunctions, derivedFields, outputFields, kiePMMLNameValues));
    }
}

