/*
 * Decompiled with CFR 0.152.
 */
package org.kie.memorycompiler.resources;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.drools.util.PortablePath;
import org.kie.memorycompiler.resources.ResourceReader;

public class MemoryResourceReader
implements ResourceReader {
    private final Map<PortablePath, byte[]> resources = new ConcurrentHashMap<PortablePath, byte[]>();
    private Set<String> modifiedResourcesSinceLastMark;

    @Override
    public boolean isAvailable(PortablePath path) {
        return this.resources.containsKey(path);
    }

    public void add(String resourceName, byte[] pContent) {
        PortablePath normalizedName = PortablePath.of((String)resourceName);
        this.resources.put(normalizedName, pContent);
        if (this.modifiedResourcesSinceLastMark != null) {
            this.modifiedResourcesSinceLastMark.add(normalizedName.asString());
        }
    }

    public void remove(PortablePath path) {
        this.resources.remove(path);
    }

    @Override
    public void mark() {
        this.modifiedResourcesSinceLastMark = new HashSet<String>();
    }

    @Override
    public Collection<String> getModifiedResourcesSinceLastMark() {
        return this.modifiedResourcesSinceLastMark;
    }

    @Override
    public byte[] getBytes(PortablePath path) {
        return this.resources.get(path);
    }

    @Override
    public Collection<PortablePath> getFilePaths() {
        return this.resources.keySet();
    }
}

