/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.backend.marshalling.v1x;

import com.thoughtworks.xstream.io.xml.QNameMap;
import com.thoughtworks.xstream.io.xml.StaxDriver;
import java.io.BufferedReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.xml.stream.XMLStreamReader;
import org.kie.dmn.api.marshalling.DMNExtensionRegister;
import org.kie.dmn.api.marshalling.DMNMarshaller;
import org.kie.dmn.backend.marshalling.CustomStaxReader;
import org.kie.dmn.model.api.Definitions;
import org.kie.dmn.model.v1_1.KieDMNModelInstrumentedBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XStreamMarshaller
implements DMNMarshaller {
    private static Logger logger = LoggerFactory.getLogger(XStreamMarshaller.class);
    private List<DMNExtensionRegister> extensionRegisters = new ArrayList<DMNExtensionRegister>();
    private final org.kie.dmn.backend.marshalling.v1_1.xstream.XStreamMarshaller xstream11;
    private final org.kie.dmn.backend.marshalling.v1_2.xstream.XStreamMarshaller xstream12;
    private final org.kie.dmn.backend.marshalling.v1_3.xstream.XStreamMarshaller xstream13;
    private final org.kie.dmn.backend.marshalling.v1_4.xstream.XStreamMarshaller xstream14;
    private static final StaxDriver staxDriver = new StaxDriver();

    public XStreamMarshaller() {
        this.xstream11 = new org.kie.dmn.backend.marshalling.v1_1.xstream.XStreamMarshaller();
        this.xstream12 = new org.kie.dmn.backend.marshalling.v1_2.xstream.XStreamMarshaller();
        this.xstream13 = new org.kie.dmn.backend.marshalling.v1_3.xstream.XStreamMarshaller();
        this.xstream14 = new org.kie.dmn.backend.marshalling.v1_4.xstream.XStreamMarshaller();
    }

    public XStreamMarshaller(List<DMNExtensionRegister> extensionRegisters) {
        this.extensionRegisters.addAll(extensionRegisters);
        this.xstream11 = new org.kie.dmn.backend.marshalling.v1_1.xstream.XStreamMarshaller(extensionRegisters);
        this.xstream12 = new org.kie.dmn.backend.marshalling.v1_2.xstream.XStreamMarshaller(extensionRegisters);
        this.xstream13 = new org.kie.dmn.backend.marshalling.v1_3.xstream.XStreamMarshaller(extensionRegisters);
        this.xstream14 = new org.kie.dmn.backend.marshalling.v1_4.xstream.XStreamMarshaller(extensionRegisters);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public Definitions unmarshal(String xml) {
        try (StringReader firstStringReader = new StringReader(xml);){
            Definitions definitions;
            try (StringReader secondStringReader = new StringReader(xml);){
                Definitions result;
                DMN_VERSION inferDMNVersion = XStreamMarshaller.inferDMNVersion(firstStringReader);
                switch (inferDMNVersion) {
                    case DMN_v1_1: {
                        result = this.xstream11.unmarshal(secondStringReader);
                        break;
                    }
                    case DMN_v1_2: {
                        result = this.xstream12.unmarshal(secondStringReader);
                        break;
                    }
                    case DMN_v1_3: {
                        result = this.xstream13.unmarshal(secondStringReader);
                        break;
                    }
                    case DMN_v1_4: {
                        result = this.xstream14.unmarshal(secondStringReader);
                        break;
                    }
                    default: {
                        result = this.xstream14.unmarshal(secondStringReader);
                    }
                }
                definitions = result;
            }
            return definitions;
        }
        catch (Exception e) {
            logger.error("Error unmarshalling DMN model from reader.", (Throwable)e);
            return null;
        }
    }

    public static DMN_VERSION inferDMNVersion(Reader from) {
        try {
            XMLStreamReader xmlReader = staxDriver.getInputFactory().createXMLStreamReader(from);
            CustomStaxReader customStaxReader = new CustomStaxReader(new QNameMap(), xmlReader);
            DMN_VERSION result = DMN_VERSION.UNKNOWN;
            if (customStaxReader.getNsContext().values().stream().anyMatch(s -> "https://www.omg.org/spec/DMN/20211108/MODEL/".equals(s))) {
                result = DMN_VERSION.DMN_v1_4;
            } else if (customStaxReader.getNsContext().values().stream().anyMatch(s -> "https://www.omg.org/spec/DMN/20191111/MODEL/".equals(s))) {
                result = DMN_VERSION.DMN_v1_3;
            } else if (customStaxReader.getNsContext().values().stream().anyMatch(s -> "http://www.omg.org/spec/DMN/20180521/MODEL/".equals(s))) {
                result = DMN_VERSION.DMN_v1_2;
            } else if (customStaxReader.getNsContext().values().stream().anyMatch(s -> "http://www.omg.org/spec/DMN/20151101/dmn.xsd".equals(s))) {
                result = DMN_VERSION.DMN_v1_1;
            }
            xmlReader.close();
            customStaxReader.close();
            return result;
        }
        catch (Exception e) {
            logger.error("Error unmarshalling DMN model from reader.", (Throwable)e);
            return DMN_VERSION.UNKNOWN;
        }
    }

    public Definitions unmarshal(Reader isr) {
        Definitions definitions;
        BufferedReader buffer = new BufferedReader(isr);
        try {
            String xml = buffer.lines().collect(Collectors.joining("\n"));
            definitions = this.unmarshal(xml);
        }
        catch (Throwable throwable) {
            try {
                try {
                    buffer.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                logger.error("Error unmarshalling DMN model from reader.", (Throwable)e);
                return null;
            }
        }
        buffer.close();
        return definitions;
    }

    public String marshal(Object o) {
        if (o instanceof org.kie.dmn.model.v1_4.KieDMNModelInstrumentedBase) {
            return this.xstream14.marshal(o);
        }
        if (o instanceof org.kie.dmn.model.v1_3.KieDMNModelInstrumentedBase) {
            return this.xstream13.marshal(o);
        }
        if (o instanceof org.kie.dmn.model.v1_2.KieDMNModelInstrumentedBase) {
            return this.xstream12.marshal(o);
        }
        if (o instanceof KieDMNModelInstrumentedBase) {
            return this.xstream11.marshal(o);
        }
        return this.xstream14.marshal(o);
    }

    public void marshal(Object o, Writer out) {
        if (o instanceof org.kie.dmn.model.v1_4.KieDMNModelInstrumentedBase) {
            this.xstream14.marshal(o, out);
        } else if (o instanceof org.kie.dmn.model.v1_3.KieDMNModelInstrumentedBase) {
            this.xstream13.marshal(o, out);
        } else if (o instanceof org.kie.dmn.model.v1_2.KieDMNModelInstrumentedBase) {
            this.xstream12.marshal(o, out);
        } else if (o instanceof KieDMNModelInstrumentedBase) {
            this.xstream11.marshal(o, out);
        } else {
            this.xstream14.marshal(o, out);
        }
    }

    public static enum DMN_VERSION {
        UNKNOWN,
        DMN_v1_1,
        DMN_v1_2,
        DMN_v1_3,
        DMN_v1_4;

    }
}

