/*
 * Decompiled with CFR 0.152.
 */
package org.kie.api.runtime.conf;

import java.util.Objects;
import org.kie.api.runtime.conf.SingleValueKieSessionOption;

public class PersistedSessionOption
implements SingleValueKieSessionOption {
    public static final String PROPERTY_NAME = "drools.persistedsession";
    private final long sessionId;
    private PersistenceStrategy persistenceStrategy = PersistenceStrategy.FULL;
    private SafepointStrategy safepointStrategy = SafepointStrategy.ALWAYS;

    private PersistedSessionOption() {
        this(-1L);
    }

    private PersistedSessionOption(long sessionId) {
        this.sessionId = sessionId;
    }

    public static PersistedSessionOption newSession() {
        return new PersistedSessionOption();
    }

    public static PersistedSessionOption fromSession(long sessionId) {
        return new PersistedSessionOption(sessionId);
    }

    @Override
    public String getPropertyName() {
        return PROPERTY_NAME;
    }

    public long getSessionId() {
        return this.sessionId;
    }

    public PersistenceStrategy getPersistenceStrategy() {
        return this.persistenceStrategy;
    }

    public PersistedSessionOption withPersistenceStrategy(PersistenceStrategy persistenceStrategy) {
        this.persistenceStrategy = persistenceStrategy;
        return this;
    }

    public SafepointStrategy getSafepointStrategy() {
        return this.safepointStrategy;
    }

    public PersistedSessionOption withSafepointStrategy(SafepointStrategy safepointStrategy) {
        this.safepointStrategy = safepointStrategy;
        return this;
    }

    public boolean isNewSession() {
        return this.sessionId < 0L;
    }

    public String toString() {
        return "PersistedSessionOption( " + this.sessionId + " )";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PersistedSessionOption that = (PersistedSessionOption)o;
        return this.sessionId == that.sessionId;
    }

    public int hashCode() {
        return Objects.hash(this.sessionId);
    }

    public static enum SafepointStrategy {
        ALWAYS,
        AFTER_FIRE,
        EXPLICIT;


        public boolean useSafepoints() {
            return this != ALWAYS;
        }
    }

    public static enum PersistenceStrategy {
        FULL,
        STORES_ONLY;

    }
}

