/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.springsecurity.management;

import java.util.List;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.keycloak.adapters.spi.UserSessionManagement;
import org.keycloak.adapters.springsecurity.management.LocalSessionManagementStrategy;
import org.keycloak.adapters.springsecurity.management.SessionManagementStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class HttpSessionManager
implements HttpSessionListener,
UserSessionManagement {
    private static final Logger log = LoggerFactory.getLogger(HttpSessionManager.class);
    private SessionManagementStrategy sessions = new LocalSessionManagementStrategy();

    public void sessionCreated(HttpSessionEvent event) {
        log.debug("Session created: {}", (Object)event.getSession().getId());
        HttpSession session = event.getSession();
        this.sessions.store(session);
    }

    public void sessionDestroyed(HttpSessionEvent event) {
        this.sessions.remove(event.getSession().getId());
    }

    public void logoutAll() {
        log.info("Received request to log out all users.");
        for (HttpSession session : this.sessions.getAll()) {
            session.invalidate();
        }
        this.sessions.clear();
    }

    public void logoutHttpSessions(List<String> ids) {
        log.info("Received request to log out {} session(s): {}", (Object)ids.size(), ids);
        for (String id : ids) {
            HttpSession session = this.sessions.remove(id);
            if (session == null) continue;
            session.invalidate();
        }
    }
}

