/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.springsecurity.filter;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.keycloak.KeycloakPrincipal;
import org.keycloak.KeycloakSecurityContext;
import org.keycloak.adapters.AdapterDeploymentContext;
import org.keycloak.adapters.KeycloakDeployment;
import org.keycloak.adapters.RefreshableKeycloakSecurityContext;
import org.keycloak.adapters.spi.HttpFacade;
import org.keycloak.adapters.springsecurity.facade.SimpleHttpFacade;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.filter.GenericFilterBean;

public class KeycloakSecurityContextRequestFilter
extends GenericFilterBean
implements ApplicationContextAware {
    private static final String FILTER_APPLIED = KeycloakSecurityContext.class.getPackage().getName() + ".token-refreshed";
    private ApplicationContext applicationContext;
    private AdapterDeploymentContext deploymentContext;

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        if (request.getAttribute(FILTER_APPLIED) != null) {
            filterChain.doFilter(request, response);
            return;
        }
        request.setAttribute(FILTER_APPLIED, (Object)Boolean.TRUE);
        KeycloakSecurityContext keycloakSecurityContext = this.getKeycloakPrincipal();
        if (keycloakSecurityContext instanceof RefreshableKeycloakSecurityContext) {
            RefreshableKeycloakSecurityContext refreshableSecurityContext = (RefreshableKeycloakSecurityContext)keycloakSecurityContext;
            KeycloakDeployment deployment = this.resolveDeployment(request, response);
            if (!refreshableSecurityContext.isActive() || deployment.isAlwaysRefreshToken()) {
                if (refreshableSecurityContext.refreshExpiredToken(false)) {
                    request.setAttribute(KeycloakSecurityContext.class.getName(), (Object)refreshableSecurityContext);
                } else {
                    this.clearAuthenticationContext();
                }
            }
            request.setAttribute(KeycloakSecurityContext.class.getName(), (Object)keycloakSecurityContext);
        }
        filterChain.doFilter(request, response);
    }

    protected void initFilterBean() {
        this.deploymentContext = (AdapterDeploymentContext)this.applicationContext.getBean(AdapterDeploymentContext.class);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    private KeycloakSecurityContext getKeycloakPrincipal() {
        Object principal;
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication != null && (principal = authentication.getPrincipal()) instanceof KeycloakPrincipal) {
            return ((KeycloakPrincipal)KeycloakPrincipal.class.cast(principal)).getKeycloakSecurityContext();
        }
        return null;
    }

    private KeycloakDeployment resolveDeployment(ServletRequest servletRequest, ServletResponse servletResponse) {
        return this.deploymentContext.resolveDeployment((HttpFacade)new SimpleHttpFacade((HttpServletRequest)HttpServletRequest.class.cast(servletRequest), (HttpServletResponse)HttpServletResponse.class.cast(servletResponse)));
    }

    private void clearAuthenticationContext() {
        SecurityContextHolder.clearContext();
    }
}

