/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.springsecurity;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import org.keycloak.adapters.AdapterDeploymentContext;
import org.keycloak.adapters.KeycloakConfigResolver;
import org.keycloak.adapters.KeycloakDeployment;
import org.keycloak.adapters.KeycloakDeploymentBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.Resource;

public class AdapterDeploymentContextFactoryBean
implements FactoryBean<AdapterDeploymentContext>,
InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(AdapterDeploymentContextFactoryBean.class);
    private final Resource keycloakConfigFileResource;
    private final KeycloakConfigResolver keycloakConfigResolver;
    private AdapterDeploymentContext adapterDeploymentContext;

    public AdapterDeploymentContextFactoryBean(Resource keycloakConfigFileResource) {
        this.keycloakConfigFileResource = Objects.requireNonNull(keycloakConfigFileResource);
        this.keycloakConfigResolver = null;
    }

    public AdapterDeploymentContextFactoryBean(KeycloakConfigResolver keycloakConfigResolver) {
        this.keycloakConfigResolver = Objects.requireNonNull(keycloakConfigResolver);
        this.keycloakConfigFileResource = null;
    }

    public Class<?> getObjectType() {
        return AdapterDeploymentContext.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.keycloakConfigResolver != null) {
            this.adapterDeploymentContext = new AdapterDeploymentContext(this.keycloakConfigResolver);
        } else {
            log.info("Loading Keycloak deployment from configuration file: {}", (Object)this.keycloakConfigFileResource);
            KeycloakDeployment deployment = this.loadKeycloakDeployment();
            this.adapterDeploymentContext = new AdapterDeploymentContext(deployment);
        }
    }

    private KeycloakDeployment loadKeycloakDeployment() throws IOException {
        if (!this.keycloakConfigFileResource.isReadable()) {
            throw new FileNotFoundException(String.format("Unable to locate Keycloak configuration file: %s", this.keycloakConfigFileResource.getFilename()));
        }
        return KeycloakDeploymentBuilder.build((InputStream)this.keycloakConfigFileResource.getInputStream());
    }

    public AdapterDeploymentContext getObject() throws Exception {
        return this.adapterDeploymentContext;
    }
}

