/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.springsecurity.client;

import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.HttpClients;
import org.keycloak.KeycloakSecurityContext;
import org.keycloak.adapters.springsecurity.token.KeycloakAuthenticationToken;
import org.springframework.context.annotation.Scope;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class KeycloakClientRequestFactory
extends HttpComponentsClientHttpRequestFactory
implements ClientHttpRequestFactory {
    public static final String AUTHORIZATION_HEADER = "Authorization";

    public KeycloakClientRequestFactory() {
        super((HttpClient)HttpClients.custom().disableCookieManagement().build());
    }

    protected void postProcessHttpRequest(HttpUriRequest request) {
        KeycloakSecurityContext context = this.getKeycloakSecurityContext();
        request.setHeader(AUTHORIZATION_HEADER, "Bearer " + context.getTokenString());
    }

    protected KeycloakSecurityContext getKeycloakSecurityContext() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication == null) {
            throw new IllegalStateException("Cannot set authorization header because there is no authenticated principal");
        }
        if (!KeycloakAuthenticationToken.class.isAssignableFrom(authentication.getClass())) {
            throw new IllegalStateException(String.format("Cannot set authorization header because Authentication is of type %s but %s is required", authentication.getClass(), KeycloakAuthenticationToken.class));
        }
        KeycloakAuthenticationToken token = (KeycloakAuthenticationToken)authentication;
        KeycloakSecurityContext context = token.getAccount().getKeycloakSecurityContext();
        return context;
    }
}

