/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.userprofile.validator;

import java.util.List;
import javax.ws.rs.core.Response;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.services.validation.Validation;
import org.keycloak.userprofile.UserProfileAttributeValidationContext;
import org.keycloak.validate.SimpleValidator;
import org.keycloak.validate.ValidationContext;
import org.keycloak.validate.ValidationError;
import org.keycloak.validate.ValidatorConfig;

public class DuplicateUsernameValidator
implements SimpleValidator {
    public static final String ID = "up-duplicate-username";

    public String getId() {
        return ID;
    }

    public ValidationContext validate(Object input, String inputHint, ValidationContext context, ValidatorConfig config) {
        List values = (List)input;
        if (values.isEmpty()) {
            return context;
        }
        String value = (String)values.get(0);
        if (Validation.isBlank(value)) {
            return context;
        }
        KeycloakSession session = context.getSession();
        UserModel existing = session.users().getUserByUsername(session.getContext().getRealm(), value);
        UserModel user = UserProfileAttributeValidationContext.from((ValidationContext)context).getAttributeContext().getUser();
        if (!KeycloakModelUtils.isUsernameCaseSensitive((RealmModel)session.getContext().getRealm())) {
            value = value.toLowerCase();
        }
        if (user != null && !value.equals(user.getFirstAttribute("username")) && existing != null && !existing.getId().equals(user.getId())) {
            context.addError(new ValidationError(ID, inputHint, "usernameExistsMessage").setStatusCode(Response.Status.CONFLICT));
        }
        return context;
    }
}

