/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.social.google;

import java.util.Arrays;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.UriBuilder;
import org.keycloak.broker.oidc.OIDCIdentityProvider;
import org.keycloak.broker.oidc.OIDCIdentityProviderConfig;
import org.keycloak.broker.provider.AuthenticationRequest;
import org.keycloak.broker.provider.BrokeredIdentityContext;
import org.keycloak.broker.provider.IdentityBrokerException;
import org.keycloak.broker.social.SocialIdentityProvider;
import org.keycloak.common.ClientConnection;
import org.keycloak.common.util.KeycloakUriBuilder;
import org.keycloak.events.EventBuilder;
import org.keycloak.models.KeycloakSession;
import org.keycloak.representations.JsonWebToken;
import org.keycloak.social.google.GoogleIdentityProviderConfig;

public class GoogleIdentityProvider
extends OIDCIdentityProvider
implements SocialIdentityProvider<OIDCIdentityProviderConfig> {
    public static final String AUTH_URL = "https://accounts.google.com/o/oauth2/v2/auth";
    public static final String TOKEN_URL = "https://oauth2.googleapis.com/token";
    public static final String PROFILE_URL = "https://openidconnect.googleapis.com/v1/userinfo";
    public static final String DEFAULT_SCOPE = "openid profile email";
    private static final String OIDC_PARAMETER_HOSTED_DOMAINS = "hd";
    private static final String OIDC_PARAMETER_ACCESS_TYPE = "access_type";
    private static final String ACCESS_TYPE_OFFLINE = "offline";

    public GoogleIdentityProvider(KeycloakSession session, GoogleIdentityProviderConfig config) {
        super(session, config);
        config.setAuthorizationUrl(AUTH_URL);
        config.setTokenUrl(TOKEN_URL);
        config.setUserInfoUrl(PROFILE_URL);
    }

    @Override
    protected String getDefaultScopes() {
        return DEFAULT_SCOPE;
    }

    @Override
    protected String getUserInfoUrl() {
        ClientConnection connection;
        String uri = super.getUserInfoUrl();
        if (((GoogleIdentityProviderConfig)this.getConfig()).isUserIp() && (connection = this.session.getContext().getConnection()) != null) {
            uri = KeycloakUriBuilder.fromUri((String)super.getUserInfoUrl()).queryParam("userIp", new Object[]{connection.getRemoteAddr()}).build(new Object[0]).toString();
        }
        logger.debugv("GOOGLE userInfoUrl: {0}", (Object)uri);
        return uri;
    }

    @Override
    protected boolean supportsExternalExchange() {
        return true;
    }

    @Override
    public boolean isIssuer(String issuer, MultivaluedMap<String, String> params) {
        String requestedIssuer = (String)params.getFirst((Object)"subject_issuer");
        if (requestedIssuer == null) {
            requestedIssuer = issuer;
        }
        return requestedIssuer.equals(((OIDCIdentityProviderConfig)this.getConfig()).getAlias());
    }

    @Override
    protected BrokeredIdentityContext exchangeExternalImpl(EventBuilder event, MultivaluedMap<String, String> params) {
        return this.exchangeExternalUserInfoValidationOnly(event, params);
    }

    @Override
    protected UriBuilder createAuthorizationUrl(AuthenticationRequest request) {
        UriBuilder uriBuilder = super.createAuthorizationUrl(request);
        GoogleIdentityProviderConfig googleConfig = (GoogleIdentityProviderConfig)this.getConfig();
        String hostedDomain = googleConfig.getHostedDomain();
        if (hostedDomain != null) {
            uriBuilder.queryParam(OIDC_PARAMETER_HOSTED_DOMAINS, new Object[]{hostedDomain});
        }
        if (googleConfig.isOfflineAccess()) {
            uriBuilder.queryParam(OIDC_PARAMETER_ACCESS_TYPE, new Object[]{ACCESS_TYPE_OFFLINE});
        }
        return uriBuilder;
    }

    @Override
    protected JsonWebToken validateToken(String encodedToken, boolean ignoreAudience) {
        JsonWebToken token = super.validateToken(encodedToken, ignoreAudience);
        String hostedDomain = ((GoogleIdentityProviderConfig)this.getConfig()).getHostedDomain();
        if (hostedDomain == null) {
            return token;
        }
        Object receivedHdParam = token.getOtherClaims().get(OIDC_PARAMETER_HOSTED_DOMAINS);
        if (receivedHdParam == null) {
            throw new IdentityBrokerException("Identity token does not contain hosted domain parameter.");
        }
        if (hostedDomain.equals("*") || Arrays.asList(hostedDomain.split(",")).contains(receivedHdParam)) {
            return token;
        }
        throw new IdentityBrokerException("Hosted domain does not match.");
    }
}

