/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.saml.mappers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.jboss.logging.Logger;
import org.keycloak.common.Profile;
import org.keycloak.dom.saml.v2.assertion.AttributeStatementType;
import org.keycloak.dom.saml.v2.assertion.AttributeType;
import org.keycloak.models.AuthenticatedClientSessionModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ProtocolMapperContainerModel;
import org.keycloak.models.ProtocolMapperModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.ScriptModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.protocol.ProtocolMapperConfigException;
import org.keycloak.protocol.saml.mappers.AbstractSAMLProtocolMapper;
import org.keycloak.protocol.saml.mappers.AttributeStatementHelper;
import org.keycloak.protocol.saml.mappers.SAMLAttributeStatementMapper;
import org.keycloak.provider.EnvironmentDependentProviderFactory;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.scripting.EvaluatableScriptAdapter;
import org.keycloak.scripting.ScriptCompilationException;
import org.keycloak.scripting.ScriptingProvider;

public class ScriptBasedMapper
extends AbstractSAMLProtocolMapper
implements SAMLAttributeStatementMapper,
EnvironmentDependentProviderFactory {
    private static final List<ProviderConfigProperty> configProperties = new ArrayList<ProviderConfigProperty>();
    public static final String PROVIDER_ID = "saml-javascript-mapper";
    private static final String SINGLE_VALUE_ATTRIBUTE = "single";
    private static final Logger LOGGER = Logger.getLogger(ScriptBasedMapper.class);

    public List<ProviderConfigProperty> getConfigProperties() {
        return configProperties;
    }

    public String getId() {
        return PROVIDER_ID;
    }

    public String getDisplayType() {
        return "Javascript Mapper";
    }

    public String getDisplayCategory() {
        return "AttributeStatement Mapper";
    }

    public String getHelpText() {
        return "Evaluates a JavaScript function to produce an attribute value based on context information.";
    }

    public boolean isSupported() {
        return Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.SCRIPTS);
    }

    @Override
    public void transformAttributeStatement(AttributeStatementType attributeStatement, ProtocolMapperModel mappingModel, KeycloakSession session, UserSessionModel userSession, AuthenticatedClientSessionModel clientSession) {
        UserModel user = userSession.getUser();
        String scriptSource = this.getScriptCode(mappingModel);
        RealmModel realm = userSession.getRealm();
        String single = (String)mappingModel.getConfig().get(SINGLE_VALUE_ATTRIBUTE);
        boolean singleAttribute = Boolean.parseBoolean(single);
        ScriptingProvider scripting = (ScriptingProvider)session.getProvider(ScriptingProvider.class);
        ScriptModel scriptModel = scripting.createScript(realm.getId(), "text/javascript", "attribute-mapper-script_" + mappingModel.getName(), scriptSource, null);
        EvaluatableScriptAdapter script = scripting.prepareEvaluatableScript(scriptModel);
        try {
            List<Object> attributeValue = script.eval(bindings -> {
                bindings.put("user", (Object)user);
                bindings.put("realm", (Object)realm);
                bindings.put("clientSession", (Object)clientSession);
                bindings.put("userSession", (Object)userSession);
                bindings.put("keycloakSession", (Object)session);
            });
            if (attributeValue.getClass().isArray()) {
                attributeValue = Arrays.asList((Object[])attributeValue);
            }
            if (attributeValue instanceof Iterable) {
                if (singleAttribute) {
                    AttributeType singleAttributeType = AttributeStatementHelper.createAttributeType(mappingModel);
                    attributeStatement.addAttribute(new AttributeStatementType.ASTChoiceType(singleAttributeType));
                    for (Object value : (Iterable)attributeValue) {
                        singleAttributeType.addAttributeValue(value);
                    }
                } else {
                    for (Object value : (Iterable)attributeValue) {
                        AttributeStatementHelper.addAttribute(attributeStatement, mappingModel, value.toString());
                    }
                }
            } else {
                AttributeStatementHelper.addAttribute(attributeStatement, mappingModel, attributeValue.toString());
            }
        }
        catch (Exception ex) {
            LOGGER.error((Object)"Error during execution of ProtocolMapper script", (Throwable)ex);
            AttributeStatementHelper.addAttribute(attributeStatement, mappingModel, null);
        }
    }

    public void validateConfig(KeycloakSession session, RealmModel realm, ProtocolMapperContainerModel client, ProtocolMapperModel mapperModel) throws ProtocolMapperConfigException {
        String scriptCode = this.getScriptCode(mapperModel);
        if (scriptCode == null) {
            return;
        }
        ScriptingProvider scripting = (ScriptingProvider)session.getProvider(ScriptingProvider.class);
        ScriptModel scriptModel = scripting.createScript(realm.getId(), "text/javascript", mapperModel.getName() + "-script", scriptCode, "");
        try {
            scripting.prepareEvaluatableScript(scriptModel);
        }
        catch (ScriptCompilationException ex) {
            throw new ProtocolMapperConfigException("error", "{0}", new Object[]{ex.getMessage()});
        }
    }

    protected String getScriptCode(ProtocolMapperModel mappingModel) {
        return (String)mappingModel.getConfig().get("Script");
    }

    public static ProtocolMapperModel create(String name, String samlAttributeName, String nameFormat, String friendlyName, String script, boolean singleAttribute) {
        ProtocolMapperModel mapper = AttributeStatementHelper.createAttributeMapper(name, null, samlAttributeName, nameFormat, friendlyName, PROVIDER_ID);
        Map config = mapper.getConfig();
        config.put("Script", script);
        config.put(SINGLE_VALUE_ATTRIBUTE, Boolean.toString(singleAttribute));
        return mapper;
    }

    static {
        ProviderConfigProperty property = new ProviderConfigProperty();
        property.setType("Script");
        property.setLabel("Script");
        property.setName("Script");
        property.setHelpText("Script to compute the attribute value. \n Available variables: \n 'user' - the current user.\n 'realm' - the current realm.\n 'clientSession' - the current clientSession.\n 'userSession' - the current userSession.\n 'keycloakSession' - the current keycloakSession.\n\nTo use: the last statement is the value returned to Java.\nThe result will be tested if it can be iterated upon (e.g. an array or a collection).\n - If it is not, toString() will be called on the object to get the value of the attribute\n - If it is, toString() will be called on all elements to return multiple attribute values.\n");
        property.setDefaultValue((Object)"/**\n * Available variables: \n * user - the current user\n * realm - the current realm\n * clientSession - the current clientSession\n * userSession - the current userSession\n * keycloakSession - the current keycloakSession\n */\n\n\n//insert your code here...");
        configProperties.add(property);
        property = new ProviderConfigProperty();
        property.setName(SINGLE_VALUE_ATTRIBUTE);
        property.setLabel("Single Value Attribute");
        property.setType("boolean");
        property.setDefaultValue((Object)"true");
        property.setHelpText("If true, all values will be stored under one attribute with multiple attribute values.");
        configProperties.add(property);
        AttributeStatementHelper.setConfigProperties(configProperties);
    }
}

