/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.saml;

import java.io.IOException;
import java.net.URI;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.keycloak.forms.login.LoginFormsProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.saml.BaseSAML2BindingBuilder;
import org.keycloak.saml.common.exceptions.ConfigurationException;
import org.keycloak.saml.common.exceptions.ProcessingException;
import org.w3c.dom.Document;

public class JaxrsSAML2BindingBuilder
extends BaseSAML2BindingBuilder<JaxrsSAML2BindingBuilder> {
    private final KeycloakSession session;

    public JaxrsSAML2BindingBuilder(KeycloakSession session) {
        this.session = session;
    }

    public RedirectBindingBuilder redirectBinding(Document document) throws ProcessingException {
        return new RedirectBindingBuilder(this, document);
    }

    public PostBindingBuilder postBinding(Document document) throws ProcessingException {
        return new PostBindingBuilder(this, document);
    }

    public static class RedirectBindingBuilder
    extends BaseSAML2BindingBuilder.BaseRedirectBindingBuilder {
        public RedirectBindingBuilder(JaxrsSAML2BindingBuilder builder, Document document) throws ProcessingException {
            super((BaseSAML2BindingBuilder)builder, document);
        }

        public Response response(String redirectUri) throws ProcessingException, ConfigurationException, IOException {
            return this.response(redirectUri, false);
        }

        public Response request(String redirect) throws ProcessingException, ConfigurationException, IOException {
            return this.response(redirect, true);
        }

        private Response response(String redirectUri, boolean asRequest) throws ProcessingException, ConfigurationException, IOException {
            URI uri = this.generateURI(redirectUri, asRequest);
            logger.tracef("redirect-binding uri: %s", (Object)uri);
            CacheControl cacheControl = new CacheControl();
            cacheControl.setNoCache(true);
            return Response.status((int)302).location(uri).header("Pragma", (Object)"no-cache").header("Cache-Control", (Object)"no-cache, no-store").build();
        }
    }

    public class PostBindingBuilder
    extends BaseSAML2BindingBuilder.BasePostBindingBuilder {
        public PostBindingBuilder(JaxrsSAML2BindingBuilder builder, Document document) throws ProcessingException {
            super((BaseSAML2BindingBuilder)JaxrsSAML2BindingBuilder.this, (BaseSAML2BindingBuilder)builder, document);
        }

        public Response request(String actionUrl) throws ConfigurationException, ProcessingException, IOException {
            return this.createResponse(actionUrl, "SAMLRequest");
        }

        public Response response(String actionUrl) throws ConfigurationException, ProcessingException, IOException {
            return this.createResponse(actionUrl, "SAMLResponse");
        }

        private Response createResponse(String actionUrl, String key) throws ProcessingException, ConfigurationException, IOException {
            MultivaluedHashMap formData = new MultivaluedHashMap();
            formData.add((Object)"url", (Object)actionUrl);
            formData.add((Object)key, (Object)BaseSAML2BindingBuilder.getSAMLResponse((Document)this.document));
            if (this.getRelayState() != null) {
                formData.add((Object)"RelayState", (Object)this.getRelayState());
            }
            return ((LoginFormsProvider)JaxrsSAML2BindingBuilder.this.session.getProvider(LoginFormsProvider.class)).setFormData((MultivaluedMap)formData).createSamlPostForm();
        }
    }
}

