/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.common.util;

import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.keycloak.common.util.Resteasy;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakContext;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionTaskWithResult;
import org.keycloak.models.RealmModel;
import org.keycloak.sessions.RootAuthenticationSessionModel;

public abstract class ResponseSessionTask
implements KeycloakSessionTaskWithResult<Response> {
    private final KeycloakSession originalSession;

    public ResponseSessionTask(KeycloakSession originalSession) {
        this.originalSession = originalSession;
    }

    public Response run(KeycloakSession session) {
        KeycloakSession originalContextSession = Resteasy.getContextData(KeycloakSession.class);
        try {
            this.setupSessionContext(session);
            Resteasy.pushContext(KeycloakSession.class, session);
            Response response = this.runInternal(session);
            return response;
        }
        catch (WebApplicationException we) {
            Response response = we.getResponse();
            if (response.getEntity() != null) {
                Response response2 = response;
                return response2;
            }
            throw we;
        }
        finally {
            Resteasy.pushContext(KeycloakSession.class, originalContextSession);
        }
    }

    private void setupSessionContext(KeycloakSession session) {
        RootAuthenticationSessionModel rootAuthSession;
        if (this.originalSession == null) {
            return;
        }
        KeycloakContext context = this.originalSession.getContext();
        RealmModel realmModel = null;
        if (context.getRealm() != null) {
            realmModel = session.realms().getRealm(context.getRealm().getId());
            session.getContext().setRealm(realmModel);
        }
        ClientModel clientModel = null;
        if (context.getClient() != null) {
            clientModel = session.clients().getClientById(realmModel, context.getClient().getId());
            session.getContext().setClient(clientModel);
        }
        if (context.getAuthenticationSession() != null && (rootAuthSession = session.authenticationSessions().getRootAuthenticationSession(realmModel, context.getAuthenticationSession().getParentSession().getId())) != null) {
            session.getContext().setAuthenticationSession(rootAuthSession.getAuthenticationSession(clientModel, context.getAuthenticationSession().getTabId()));
        }
    }

    public abstract Response runInternal(KeycloakSession var1);
}

