/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authentication.requiredactions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.keycloak.Config;
import org.keycloak.authentication.InitiatedActionSupport;
import org.keycloak.authentication.RequiredActionContext;
import org.keycloak.authentication.RequiredActionFactory;
import org.keycloak.authentication.RequiredActionProvider;
import org.keycloak.common.Profile;
import org.keycloak.credential.CredentialModel;
import org.keycloak.credential.CredentialProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.UserModel;
import org.keycloak.models.credential.RecoveryAuthnCodesCredentialModel;
import org.keycloak.provider.EnvironmentDependentProviderFactory;

public class RecoveryAuthnCodesAction
implements RequiredActionProvider,
RequiredActionFactory,
EnvironmentDependentProviderFactory {
    private static final String FIELD_GENERATED_RECOVERY_AUTHN_CODES_HIDDEN = "generatedRecoveryAuthnCodes";
    private static final String FIELD_GENERATED_AT_HIDDEN = "generatedAt";
    private static final String FIELD_USER_LABEL_HIDDEN = "userLabel";
    public static final String PROVIDER_ID = UserModel.RequiredAction.CONFIGURE_RECOVERY_AUTHN_CODES.name();
    private static final RecoveryAuthnCodesAction INSTANCE = new RecoveryAuthnCodesAction();

    public String getId() {
        return PROVIDER_ID;
    }

    public String getDisplayText() {
        return "Recovery Authentication Codes";
    }

    public RequiredActionProvider create(KeycloakSession session) {
        return INSTANCE;
    }

    public void init(Config.Scope config) {
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public boolean isOneTimeAction() {
        return true;
    }

    public InitiatedActionSupport initiatedActionSupport() {
        return InitiatedActionSupport.SUPPORTED;
    }

    public void evaluateTriggers(RequiredActionContext context) {
    }

    public void requiredActionChallenge(RequiredActionContext context) {
        Response challenge = context.form().createResponse(UserModel.RequiredAction.CONFIGURE_RECOVERY_AUTHN_CODES);
        context.challenge(challenge);
    }

    public void processAction(RequiredActionContext reqActionContext) {
        CredentialProvider recoveryCodeCredentialProvider = (CredentialProvider)reqActionContext.getSession().getProvider(CredentialProvider.class, "keycloak-recovery-authn-codes");
        reqActionContext.getEvent().detail("credential_type", "recovery-authn-codes");
        MultivaluedMap httpReqParamsMap = reqActionContext.getHttpRequest().getDecodedFormParameters();
        ArrayList<String> generatedCodes = new ArrayList<String>(Arrays.asList(((String)httpReqParamsMap.getFirst((Object)FIELD_GENERATED_RECOVERY_AUTHN_CODES_HIDDEN)).split(",")));
        Long generatedAtTime = Long.parseLong((String)httpReqParamsMap.getFirst((Object)FIELD_GENERATED_AT_HIDDEN));
        String generatedUserLabel = (String)httpReqParamsMap.getFirst((Object)FIELD_USER_LABEL_HIDDEN);
        RecoveryAuthnCodesCredentialModel credentialModel = this.createFromValues(generatedCodes, generatedAtTime, generatedUserLabel);
        recoveryCodeCredentialProvider.createCredential(reqActionContext.getRealm(), reqActionContext.getUser(), (CredentialModel)credentialModel);
        reqActionContext.success();
    }

    protected RecoveryAuthnCodesCredentialModel createFromValues(List<String> generatedCodes, Long generatedAtTime, String generatedUserLabel) {
        return RecoveryAuthnCodesCredentialModel.createFromValues(generatedCodes, (long)generatedAtTime, (String)generatedUserLabel);
    }

    public void close() {
    }

    public boolean isSupported() {
        return Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.RECOVERY_CODES);
    }
}

