/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.authorization;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jboss.logging.Logger;
import org.keycloak.adapters.authorization.PathCache;
import org.keycloak.adapters.authorization.PolicyEnforcer;
import org.keycloak.authorization.client.AuthzClient;
import org.keycloak.authorization.client.resource.ProtectedResource;
import org.keycloak.common.util.PathMatcher;
import org.keycloak.representations.adapters.config.PolicyEnforcerConfig;
import org.keycloak.representations.idm.authorization.ResourceRepresentation;

public class PathConfigMatcher
extends PathMatcher<PolicyEnforcerConfig.PathConfig> {
    private static Logger LOGGER = Logger.getLogger(PolicyEnforcer.class);
    private final Map<String, PolicyEnforcerConfig.PathConfig> paths;
    private final PathCache pathCache;
    private final AuthzClient authzClient;
    private final PolicyEnforcerConfig enforcerConfig;

    PathConfigMatcher(PolicyEnforcerConfig enforcerConfig, AuthzClient authzClient) {
        this.enforcerConfig = enforcerConfig;
        PolicyEnforcerConfig.PathCacheConfig cacheConfig = enforcerConfig.getPathCacheConfig();
        if (cacheConfig == null) {
            cacheConfig = new PolicyEnforcerConfig.PathCacheConfig();
        }
        this.authzClient = authzClient;
        this.paths = this.configurePaths();
        this.pathCache = new PathCache(cacheConfig.getMaxEntries(), cacheConfig.getLifespan(), this.paths);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Initialization complete. Path configuration:");
            for (PolicyEnforcerConfig.PathConfig pathConfig : this.paths.values()) {
                LOGGER.debug((Object)pathConfig);
            }
        }
    }

    public PolicyEnforcerConfig.PathConfig matches(String targetUri) {
        PolicyEnforcerConfig.PathConfig pathConfig = this.pathCache.get(targetUri);
        if (this.pathCache.containsKey(targetUri) || pathConfig != null) {
            return pathConfig;
        }
        pathConfig = (PolicyEnforcerConfig.PathConfig)super.matches(targetUri);
        if ((this.enforcerConfig.getLazyLoadPaths().booleanValue() || this.enforcerConfig.getPathCacheConfig() != null) && (pathConfig == null || pathConfig.isInvalidated() || pathConfig.getPath().contains("*"))) {
            try {
                List matchingResources = this.authzClient.protection().resource().findByMatchingUri(targetUri);
                if (matchingResources.isEmpty()) {
                    if (pathConfig != null && pathConfig.isInvalidated()) {
                        this.paths.remove(targetUri);
                        return null;
                    }
                } else {
                    Map cipConfig = null;
                    PolicyEnforcerConfig.EnforcementMode enforcementMode = PolicyEnforcerConfig.EnforcementMode.ENFORCING;
                    ResourceRepresentation targetResource = (ResourceRepresentation)matchingResources.get(0);
                    List methodConfig = null;
                    boolean isStatic = false;
                    if (pathConfig != null) {
                        cipConfig = pathConfig.getClaimInformationPointConfig();
                        enforcementMode = pathConfig.getEnforcementMode();
                        methodConfig = pathConfig.getMethods();
                        isStatic = pathConfig.isStatic();
                    } else {
                        for (PolicyEnforcerConfig.PathConfig existingPath : this.paths.values()) {
                            if (!targetResource.getId().equals(existingPath.getId()) || !existingPath.isStatic() || PolicyEnforcerConfig.EnforcementMode.DISABLED.equals((Object)existingPath.getEnforcementMode())) continue;
                            return null;
                        }
                    }
                    pathConfig = (PolicyEnforcerConfig.PathConfig)PolicyEnforcerConfig.PathConfig.createPathConfigs((ResourceRepresentation)targetResource).iterator().next();
                    if (cipConfig != null) {
                        pathConfig.setClaimInformationPointConfig(cipConfig);
                    }
                    if (methodConfig != null) {
                        pathConfig.setMethods(methodConfig);
                    }
                    pathConfig.setStatic(isStatic);
                    pathConfig.setEnforcementMode(enforcementMode);
                }
            }
            catch (Exception cause) {
                LOGGER.errorf((Throwable)cause, "Could not lazy load resource with path [" + targetUri + "] from server", new Object[0]);
                return null;
            }
        }
        this.pathCache.put(targetUri, pathConfig);
        return pathConfig;
    }

    protected String getPath(PolicyEnforcerConfig.PathConfig entry) {
        return entry.getPath();
    }

    protected Collection<PolicyEnforcerConfig.PathConfig> getPaths() {
        return this.paths.values();
    }

    public PathCache getPathCache() {
        return this.pathCache;
    }

    protected PolicyEnforcerConfig.PathConfig resolvePathConfig(PolicyEnforcerConfig.PathConfig originalConfig, String path) {
        if (originalConfig.hasPattern()) {
            ProtectedResource resource = this.authzClient.protection().resource();
            List search = resource.findByUri(path);
            if (search.isEmpty()) {
                search = resource.findByUri(this.buildUriFromTemplate(originalConfig.getPath(), path, true));
            }
            if (!search.isEmpty()) {
                ResourceRepresentation targetResource = (ResourceRepresentation)search.get(0);
                PolicyEnforcerConfig.PathConfig config = (PolicyEnforcerConfig.PathConfig)PolicyEnforcerConfig.PathConfig.createPathConfigs((ResourceRepresentation)targetResource).iterator().next();
                config.setScopes(originalConfig.getScopes());
                config.setMethods(originalConfig.getMethods());
                config.setParentConfig(originalConfig);
                config.setEnforcementMode(originalConfig.getEnforcementMode());
                config.setClaimInformationPointConfig(originalConfig.getClaimInformationPointConfig());
                return config;
            }
        }
        return null;
    }

    public void removeFromCache(String pathConfig) {
        this.pathCache.remove(pathConfig);
    }

    public Map<String, PolicyEnforcerConfig.PathConfig> getPathConfig() {
        return this.paths;
    }

    private Map<String, PolicyEnforcerConfig.PathConfig> configurePaths() {
        ProtectedResource protectedResource = this.authzClient.protection().resource();
        boolean loadPathsFromServer = this.enforcerConfig.getLazyLoadPaths() == false;
        for (PolicyEnforcerConfig.PathConfig pathConfig : this.enforcerConfig.getPaths()) {
            if (PolicyEnforcerConfig.EnforcementMode.DISABLED.equals((Object)pathConfig.getEnforcementMode())) continue;
            loadPathsFromServer = false;
            break;
        }
        if (loadPathsFromServer) {
            LOGGER.info((Object)"No path provided in configuration.");
            Map<String, PolicyEnforcerConfig.PathConfig> paths = this.configureAllPathsForResourceServer(protectedResource);
            paths.putAll(this.configureDefinedPaths(protectedResource, this.enforcerConfig));
            return paths;
        }
        LOGGER.info((Object)"Paths provided in configuration.");
        return this.configureDefinedPaths(protectedResource, this.enforcerConfig);
    }

    private Map<String, PolicyEnforcerConfig.PathConfig> configureDefinedPaths(ProtectedResource protectedResource, PolicyEnforcerConfig enforcerConfig) {
        Map<String, PolicyEnforcerConfig.PathConfig> paths = Collections.synchronizedMap(new LinkedHashMap());
        for (PolicyEnforcerConfig.PathConfig pathConfig : enforcerConfig.getPaths()) {
            ResourceRepresentation resource;
            String resourceName = pathConfig.getName();
            String path = pathConfig.getPath();
            if (resourceName != null) {
                LOGGER.debugf("Trying to find resource with name [%s] for path [%s].", (Object)resourceName, (Object)path);
                resource = protectedResource.findByName(resourceName);
            } else {
                LOGGER.debugf("Trying to find resource with uri [%s] for path [%s].", (Object)path, (Object)path);
                List resources = protectedResource.findByUri(path);
                if (resources.isEmpty()) {
                    resources = protectedResource.findByMatchingUri(path);
                }
                if (resources.size() == 1) {
                    resource = (ResourceRepresentation)resources.get(0);
                } else {
                    if (resources.size() > 1) {
                        throw new RuntimeException("Multiple resources found with the same uri");
                    }
                    resource = null;
                }
            }
            if (resource != null) {
                pathConfig.setId(resource.getId());
                if (resourceName != null) {
                    pathConfig.setStatic(true);
                }
            }
            if (PolicyEnforcerConfig.EnforcementMode.DISABLED.equals((Object)pathConfig.getEnforcementMode())) {
                pathConfig.setStatic(true);
            }
            PolicyEnforcerConfig.PathConfig existingPath = null;
            for (PolicyEnforcerConfig.PathConfig current : paths.values()) {
                if (!current.getPath().equals(pathConfig.getPath())) continue;
                existingPath = current;
                break;
            }
            if (existingPath == null) {
                paths.put(pathConfig.getPath(), pathConfig);
                continue;
            }
            existingPath.getMethods().addAll(pathConfig.getMethods());
            existingPath.getScopes().addAll(pathConfig.getScopes());
        }
        return paths;
    }

    private Map<String, PolicyEnforcerConfig.PathConfig> configureAllPathsForResourceServer(ProtectedResource protectedResource) {
        LOGGER.info((Object)"Querying the server for all resources associated with this application.");
        Map<String, PolicyEnforcerConfig.PathConfig> paths = Collections.synchronizedMap(new HashMap());
        if (!this.enforcerConfig.getLazyLoadPaths().booleanValue()) {
            for (String id : protectedResource.findAll()) {
                ResourceRepresentation resourceDescription = protectedResource.findById(id);
                if (resourceDescription.getUris() == null || resourceDescription.getUris().isEmpty()) continue;
                for (PolicyEnforcerConfig.PathConfig pathConfig : PolicyEnforcerConfig.PathConfig.createPathConfigs((ResourceRepresentation)resourceDescription)) {
                    paths.put(pathConfig.getPath(), pathConfig);
                }
            }
        }
        return paths;
    }
}

