/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.osgi;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.jboss.logging.Logger;
import org.keycloak.adapters.KeycloakDeployment;
import org.keycloak.adapters.osgi.PathBasedKeycloakConfigResolver;
import org.keycloak.adapters.spi.HttpFacade;

public class HierarchicalPathBasedKeycloakConfigResolver
extends PathBasedKeycloakConfigResolver {
    protected static final Logger log = Logger.getLogger(HierarchicalPathBasedKeycloakConfigResolver.class);

    public HierarchicalPathBasedKeycloakConfigResolver() {
        this.prepopulateCache();
    }

    @Override
    public KeycloakDeployment resolve(HttpFacade.Request request) {
        URI uri = URI.create(request.getURI());
        String path = uri.getPath();
        if (path != null) {
            while (path.startsWith("/")) {
                path = path.substring(1);
            }
            String[] segments = path.split("/");
            List<String> paths = this.collectPaths(segments);
            for (String pathFragment : paths) {
                KeycloakDeployment cachedDeployment = super.getCachedDeployment(pathFragment);
                if (cachedDeployment == null) continue;
                return cachedDeployment;
            }
        }
        throw new IllegalStateException("Can't find Keycloak configuration related to URI path " + uri);
    }

    private List<String> collectPaths(String[] segments) {
        ArrayList<String> result = new ArrayList<String>(segments.length + 1);
        for (int idx = segments.length; idx >= 0; --idx) {
            StringBuilder sb = null;
            for (int i = 0; i < idx; ++i) {
                if (sb == null) {
                    sb = new StringBuilder();
                }
                sb.append("-").append(segments[i]);
            }
            result.add(sb == null ? "" : sb.toString().substring(1));
        }
        return result;
    }
}

