/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.jetty;

import javax.servlet.ServletRequest;
import org.eclipse.jetty.server.Authentication;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.UserIdentity;
import org.keycloak.adapters.AdapterTokenStore;
import org.keycloak.adapters.KeycloakDeployment;
import org.keycloak.adapters.jetty.Jetty94RequestAuthenticator;
import org.keycloak.adapters.jetty.Jetty94SessionManager;
import org.keycloak.adapters.jetty.JettyAdapterSessionStore;
import org.keycloak.adapters.jetty.core.AbstractKeycloakJettyAuthenticator;
import org.keycloak.adapters.jetty.core.JettyRequestAuthenticator;
import org.keycloak.adapters.jetty.core.JettySessionTokenStore;
import org.keycloak.adapters.jetty.spi.JettyHttpFacade;
import org.keycloak.adapters.jetty.spi.JettySessionManager;
import org.keycloak.adapters.jetty.spi.JettyUserSessionManagement;
import org.keycloak.adapters.spi.AdapterSessionStore;
import org.keycloak.adapters.spi.HttpFacade;

public class KeycloakJettyAuthenticator
extends AbstractKeycloakJettyAuthenticator {
    protected Request resolveRequest(ServletRequest req) {
        return Request.getBaseRequest((ServletRequest)req);
    }

    protected Authentication createAuthentication(UserIdentity userIdentity, Request request) {
        return new AbstractKeycloakJettyAuthenticator.KeycloakAuthentication(this.getAuthMethod(), userIdentity){

            public Authentication logout(ServletRequest servletRequest) {
                KeycloakJettyAuthenticator.this.logoutCurrent((Request)servletRequest);
                return super.logout(servletRequest);
            }
        };
    }

    public AdapterTokenStore createSessionTokenStore(Request request, KeycloakDeployment resolvedDeployment) {
        return new JettySessionTokenStore(request, resolvedDeployment, (AdapterSessionStore)new JettyAdapterSessionStore(request));
    }

    public JettyUserSessionManagement createSessionManagement(Request request) {
        return new JettyUserSessionManagement((JettySessionManager)new Jetty94SessionManager(request.getSessionHandler()));
    }

    protected JettyRequestAuthenticator createRequestAuthenticator(Request request, JettyHttpFacade facade, KeycloakDeployment deployment, AdapterTokenStore tokenStore) {
        return new Jetty94RequestAuthenticator((HttpFacade)facade, deployment, tokenStore, -1, request);
    }
}

