/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.admin.client.resource;

import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.util.List;
import java.util.Map;
import org.keycloak.representations.idm.AuthenticationExecutionInfoRepresentation;
import org.keycloak.representations.idm.AuthenticationExecutionRepresentation;
import org.keycloak.representations.idm.AuthenticationFlowRepresentation;
import org.keycloak.representations.idm.AuthenticatorConfigInfoRepresentation;
import org.keycloak.representations.idm.AuthenticatorConfigRepresentation;
import org.keycloak.representations.idm.ConfigPropertyRepresentation;
import org.keycloak.representations.idm.RequiredActionConfigInfoRepresentation;
import org.keycloak.representations.idm.RequiredActionConfigRepresentation;
import org.keycloak.representations.idm.RequiredActionProviderRepresentation;
import org.keycloak.representations.idm.RequiredActionProviderSimpleRepresentation;

public interface AuthenticationManagementResource {
    @GET
    @Path(value="/form-providers")
    @Produces(value={"application/json"})
    public List<Map<String, Object>> getFormProviders();

    @Path(value="/authenticator-providers")
    @GET
    @Produces(value={"application/json"})
    public List<Map<String, Object>> getAuthenticatorProviders();

    @Path(value="/client-authenticator-providers")
    @GET
    @Produces(value={"application/json"})
    public List<Map<String, Object>> getClientAuthenticatorProviders();

    @Path(value="/form-action-providers")
    @GET
    @Produces(value={"application/json"})
    public List<Map<String, Object>> getFormActionProviders();

    @Path(value="/flows")
    @GET
    @Produces(value={"application/json"})
    public List<AuthenticationFlowRepresentation> getFlows();

    @Path(value="/flows")
    @POST
    @Consumes(value={"application/json"})
    public Response createFlow(AuthenticationFlowRepresentation var1);

    @Path(value="/flows/{id}")
    @GET
    @Produces(value={"application/json"})
    public AuthenticationFlowRepresentation getFlow(@PathParam(value="id") String var1);

    @Path(value="/flows/{id}")
    @DELETE
    public void deleteFlow(@PathParam(value="id") String var1);

    @Path(value="/flows/{flowAlias}/copy")
    @POST
    @Consumes(value={"application/json"})
    public Response copy(@PathParam(value="flowAlias") String var1, Map<String, Object> var2);

    @Path(value="/flows/{id}")
    @PUT
    @Consumes(value={"application/json"})
    public void updateFlow(@PathParam(value="id") String var1, AuthenticationFlowRepresentation var2);

    @Path(value="/flows/{flowAlias}/executions/flow")
    @POST
    @Consumes(value={"application/json"})
    public void addExecutionFlow(@PathParam(value="flowAlias") String var1, Map<String, Object> var2);

    @Path(value="/flows/{flowAlias}/executions/execution")
    @POST
    @Consumes(value={"application/json"})
    public void addExecution(@PathParam(value="flowAlias") String var1, Map<String, Object> var2);

    @Path(value="/flows/{flowAlias}/executions")
    @GET
    @Produces(value={"application/json"})
    public List<AuthenticationExecutionInfoRepresentation> getExecutions(@PathParam(value="flowAlias") String var1);

    @Path(value="/flows/{flowAlias}/executions")
    @PUT
    @Consumes(value={"application/json"})
    public void updateExecutions(@PathParam(value="flowAlias") String var1, AuthenticationExecutionInfoRepresentation var2);

    @Path(value="/executions")
    @POST
    @Consumes(value={"application/json"})
    public Response addExecution(AuthenticationExecutionRepresentation var1);

    @Path(value="/executions/{executionId}")
    @GET
    @Produces(value={"application/json"})
    public AuthenticationExecutionRepresentation getExecution(@PathParam(value="executionId") String var1);

    @Path(value="/executions/{executionId}/raise-priority")
    @POST
    public void raisePriority(@PathParam(value="executionId") String var1);

    @Path(value="/executions/{executionId}/lower-priority")
    @POST
    public void lowerPriority(@PathParam(value="executionId") String var1);

    @Path(value="/executions/{executionId}")
    @DELETE
    public void removeExecution(@PathParam(value="executionId") String var1);

    @Path(value="/executions/{executionId}/config")
    @POST
    @Consumes(value={"application/json"})
    public Response newExecutionConfig(@PathParam(value="executionId") String var1, AuthenticatorConfigRepresentation var2);

    @Path(value="unregistered-required-actions")
    @GET
    @Produces(value={"application/json"})
    public List<RequiredActionProviderSimpleRepresentation> getUnregisteredRequiredActions();

    @Path(value="register-required-action")
    @POST
    @Consumes(value={"application/json"})
    public void registerRequiredAction(RequiredActionProviderSimpleRepresentation var1);

    @Path(value="required-actions")
    @GET
    @Produces(value={"application/json"})
    public List<RequiredActionProviderRepresentation> getRequiredActions();

    @Path(value="required-actions/{alias}")
    @GET
    @Produces(value={"application/json"})
    public RequiredActionProviderRepresentation getRequiredAction(@PathParam(value="alias") String var1);

    @Path(value="required-actions/{alias}")
    @PUT
    @Consumes(value={"application/json"})
    public void updateRequiredAction(@PathParam(value="alias") String var1, RequiredActionProviderRepresentation var2);

    @Path(value="required-actions/{alias}")
    @DELETE
    public void removeRequiredAction(@PathParam(value="alias") String var1);

    @Path(value="required-actions/{alias}/raise-priority")
    @POST
    public void raiseRequiredActionPriority(@PathParam(value="alias") String var1);

    @Path(value="required-actions/{alias}/lower-priority")
    @POST
    public void lowerRequiredActionPriority(@PathParam(value="alias") String var1);

    @Path(value="required-actions/{alias}/config-description")
    @GET
    @Produces(value={"application/json"})
    public RequiredActionConfigInfoRepresentation getRequiredActionConfigDescription(@PathParam(value="alias") String var1);

    @Path(value="required-actions/{alias}/config")
    @GET
    @Produces(value={"application/json"})
    public RequiredActionConfigRepresentation getRequiredActionConfig(@PathParam(value="alias") String var1);

    @Path(value="required-actions/{alias}/config")
    @DELETE
    public void removeRequiredActionConfig(@PathParam(value="alias") String var1);

    @Path(value="required-actions/{alias}/config")
    @PUT
    @Consumes(value={"application/json"})
    public void updateRequiredActionConfig(@PathParam(value="alias") String var1, RequiredActionConfigRepresentation var2);

    @Path(value="config-description/{providerId}")
    @GET
    @Produces(value={"application/json"})
    public AuthenticatorConfigInfoRepresentation getAuthenticatorConfigDescription(@PathParam(value="providerId") String var1);

    @Path(value="per-client-config-description")
    @GET
    @Produces(value={"application/json"})
    public Map<String, List<ConfigPropertyRepresentation>> getPerClientConfigDescription();

    @Path(value="config/{id}")
    @GET
    @Produces(value={"application/json"})
    public AuthenticatorConfigRepresentation getAuthenticatorConfig(@PathParam(value="id") String var1);

    @Path(value="config/{id}")
    @DELETE
    public void removeAuthenticatorConfig(@PathParam(value="id") String var1);

    @Path(value="config/{id}")
    @PUT
    @Consumes(value={"application/json"})
    public void updateAuthenticatorConfig(@PathParam(value="id") String var1, AuthenticatorConfigRepresentation var2);
}

