/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.jaxb.plugin.elementwrapper;

import com.sun.codemodel.JAnnotationUse;
import com.sun.codemodel.JAssignmentTarget;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JPackage;
import com.sun.codemodel.JType;
import com.sun.tools.xjc.BadCommandLineException;
import com.sun.tools.xjc.Options;
import com.sun.tools.xjc.Plugin;
import com.sun.tools.xjc.model.CClassInfo;
import com.sun.tools.xjc.model.CElementPropertyInfo;
import com.sun.tools.xjc.model.CPropertyInfo;
import com.sun.tools.xjc.model.CTypeRef;
import com.sun.tools.xjc.model.Model;
import com.sun.tools.xjc.outline.ClassOutline;
import com.sun.tools.xjc.outline.FieldOutline;
import com.sun.tools.xjc.outline.Outline;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlElementWrapper;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jvnet.jaxb.plugin.elementwrapper.Candidate;
import org.jvnet.jaxb.plugin.elementwrapper.Instantiation;
import org.xml.sax.ErrorHandler;

public class XmlElementWrapperPlugin
extends Plugin {
    protected final String OPTION_NAME = "XelementWrapper";
    private final String OPTION_NAME_DELETE = "-XelementWrapper:delete";
    private final String OPTION_NAME_INCLUDE = "-XelementWrapper:include";
    private final String OPTION_NAME_EXCLUDE = "-XelementWrapper:exclude";
    private final String OPTION_NAME_SUMMARY = "-XelementWrapper:summary";
    private final String OPTION_NAME_COLLECTION = "-XelementWrapper:collection";
    private final String OPTION_NAME_INSTANTIATE = "-XelementWrapper:instantiate";
    protected Map<String, Candidate> candidates = null;
    protected File includeFile = null;
    protected Set<String> include = null;
    protected File excludeFile = null;
    protected Set<String> exclude = null;
    protected File summaryFile = null;
    protected PrintWriter summary = null;
    protected boolean debugMode = false;
    protected boolean verbose = false;
    protected Class interfaceClass = List.class;
    protected Class collectionClass = ArrayList.class;
    protected Instantiation instantiation = Instantiation.EARLY;
    protected boolean deleteCandidates = false;
    protected String factoryClassName = "ObjectFactory";
    protected String debugClassName = "JAXBDebug";

    public String getOptionName() {
        return "XelementWrapper";
    }

    public String getUsage() {
        return "  -XelementWrapper : Replace collection types with fields having the @XmlElementWrapper and @XmlElement annotations.";
    }

    public void onActivated(Options opts) throws BadCommandLineException {
        this.debugMode = opts.debugMode;
        this.verbose = opts.verbose;
        this.writeDebug("JAXB Compilation started (onActivated):");
        this.writeDebug("\tbuildId        :\t" + Options.getBuildID());
        this.writeDebug("\tdefaultPackage :\t" + opts.defaultPackage);
        this.writeDebug("\tdefaultPackage2:\t" + opts.defaultPackage2);
        this.writeDebug("\tquiet          :\t" + opts.quiet);
        this.writeDebug("\tdebug          :\t" + opts.debugMode);
        this.writeDebug("\ttargetDir      :\t" + opts.targetDir);
        this.writeDebug("\tverbose        :\t" + opts.verbose);
        this.writeDebug("\tGrammars       :\t" + opts.getGrammars().length);
        for (int i = 0; i < opts.getGrammars().length; ++i) {
            this.writeDebug("\t  [" + i + "]: " + opts.getGrammars()[i].getSystemId());
        }
    }

    public int parseArgument(Options opt, String[] args, int i) throws BadCommandLineException, IOException {
        int recognized = 0;
        String arg = args[i];
        this.writeDebug("Argument[" + i + "] = " + arg);
        if (arg.startsWith("-XelementWrapper:delete")) {
            ++recognized;
            this.deleteCandidates = true;
        } else if (arg.startsWith("-XelementWrapper:include")) {
            String filename;
            ++recognized;
            this.include = new HashSet<String>();
            if (arg.length() > 8) {
                filename = arg.substring("-XelementWrapper:include".length()).trim();
            } else {
                filename = args[i + 1];
                ++recognized;
            }
            this.includeFile = new File(filename);
            this.readCandidates(this.includeFile, this.include);
        } else if (arg.startsWith("-XelementWrapper:exclude")) {
            String filename;
            ++recognized;
            this.exclude = new HashSet<String>();
            if (arg.length() > 8) {
                filename = arg.substring("-XelementWrapper:exclude".length()).trim();
            } else {
                filename = args[i + 1];
                ++recognized;
            }
            this.excludeFile = new File(filename);
            this.readCandidates(this.excludeFile, this.exclude);
        } else if (arg.startsWith("-XelementWrapper:summary")) {
            String filename;
            ++recognized;
            if (arg.length() > 8) {
                filename = arg.substring("-XelementWrapper:summary".length()).trim();
            } else {
                filename = args[i + 1];
                ++recognized;
            }
            this.summaryFile = new File(filename);
            this.summary = new PrintWriter(new FileOutputStream(this.summaryFile));
        } else if (arg.startsWith("-XelementWrapper:collection")) {
            String ccn;
            ++recognized;
            if (arg.length() > 11) {
                ccn = arg.substring("-XelementWrapper:collection".length()).trim();
            } else {
                ccn = args[i + 1];
                ++recognized;
            }
            try {
                this.collectionClass = Class.forName(ccn);
            }
            catch (ClassNotFoundException e) {
                throw new BadCommandLineException("-XelementWrapper:collection " + ccn + ": Class not found.");
            }
        } else if (arg.startsWith("-XelementWrapper:instantiate")) {
            String instantiate;
            ++recognized;
            if (arg.length() > 12) {
                instantiate = arg.substring("-XelementWrapper:instantiate".length()).trim().toUpperCase();
            } else {
                instantiate = args[i + 1].trim().toUpperCase();
                ++recognized;
            }
            this.instantiation = Instantiation.valueOf(instantiate);
        }
        return recognized;
    }

    public void postProcessModel(Model model, ErrorHandler errorHandler) {
        super.postProcessModel(model, errorHandler);
    }

    public boolean run(Outline model, Options opt, ErrorHandler errorHandler) {
        ArrayList<JMethod> methodsToRemove;
        int candidateCount = 0;
        int modificationCount = 0;
        int deletionCount = 0;
        this.writeDebug("JAXB Process Model (run)...");
        this.writeSummary(" ");
        this.writeSummary("Compilation:");
        this.writeSummary("\tDate         :\t-");
        this.writeSummary("\tVersion      :\t-");
        this.writeSummary("\tJAXB version :\t" + Options.getBuildID());
        this.writeSummary("\tInclude file :\t" + (Serializable)(this.includeFile == null ? "<none>" : this.includeFile));
        this.writeSummary("\tExclude file :\t" + (Serializable)(this.excludeFile == null ? "<none>" : this.excludeFile));
        this.writeSummary("\tSummary file :\t" + (Serializable)(this.summaryFile == null ? "<none>" : this.summaryFile));
        this.writeSummary("\tInstantiate  :\t" + this.instantiation);
        this.writeSummary("\tCollection   :\t" + this.collectionClass);
        this.writeSummary("\tInterface    :\t" + this.interfaceClass);
        this.writeSummary("\tDelete       :\t" + this.deleteCandidates);
        this.writeSummary(" ");
        this.candidates = this.findCandidateClasses(model.getModel(), errorHandler);
        this.writeSummary("Candidates:");
        for (Candidate c : this.candidates.values()) {
            if (this.isIncluded(c)) {
                this.writeSummary("\t[+] " + this.getIncludeOrExcludeReason(c) + ":\t" + c.getClassName());
                ++candidateCount;
                continue;
            }
            this.writeSummary("\t[-]: " + this.getIncludeOrExcludeReason(c) + ":\t" + c.getClassName());
        }
        this.writeSummary("\t" + candidateCount + " candidate(s) being considered.");
        this.writeSummary(" ");
        this.writeSummary("Modifications:");
        for (ClassOutline classOutline : model.getClasses()) {
            JDefinedClass implementationClass = classOutline.implClass;
            for (FieldOutline field : classOutline.getDeclaredFields()) {
                String fieldName = field.getPropertyInfo().getName(false);
                String typeName = field.getRawType().fullName();
                Candidate candidate = this.candidates.get(typeName);
                if (candidate == null || !this.isIncluded(candidate)) continue;
                this.writeSummary("\t" + classOutline.target.getName() + "#" + fieldName + "\t" + typeName);
                ++modificationCount;
                JDefinedClass candidateClass = model.getClazz((CClassInfo)candidate.getClassInfo()).implClass;
                List itemNarrowing = ((JClass)((JFieldVar)candidateClass.fields().get(candidate.getFieldName())).type()).getTypeParameters();
                JClass newInterfaceClass = implementationClass.owner().ref(this.interfaceClass).narrow(itemNarrowing);
                JClass newCollectionClass = implementationClass.owner().ref(this.collectionClass).narrow(itemNarrowing);
                JFieldVar implField = (JFieldVar)implementationClass.fields().get(fieldName);
                implementationClass.removeField(implField);
                implField = implementationClass.field(2, (JType)newInterfaceClass, fieldName);
                if (this.instantiation == Instantiation.EARLY) {
                    this.writeDebug("Applying EARLY instantiation...");
                    implField.init((JExpression)JExpr._new((JClass)newCollectionClass));
                }
                JAnnotationUse annotation = implField.annotate(XmlElementWrapper.class);
                annotation.param("name", XmlElementWrapperPlugin.elementName(field.getPropertyInfo()) == null ? fieldName : XmlElementWrapperPlugin.elementName(field.getPropertyInfo()));
                this.writeDebug("XmlElementWrapper(name=" + (XmlElementWrapperPlugin.elementName(field.getPropertyInfo()) == null ? fieldName : XmlElementWrapperPlugin.elementName(field.getPropertyInfo())) + ")");
                annotation = implField.annotate(XmlElement.class);
                annotation.param("name", candidate.getWrappedSchemaTypeName() == null ? candidate.getFieldName() : candidate.getWrappedSchemaTypeName());
                this.writeDebug("XmlElement(name=" + (candidate.getWrappedSchemaTypeName() == null ? candidate.getFieldName() : candidate.getWrappedSchemaTypeName()) + ")");
                methodsToRemove = new ArrayList();
                for (JMethod m : implementationClass.methods()) {
                    if (!m.name().equals("set" + this.firstUpper(fieldName)) && !m.name().equals("get" + this.firstUpper(fieldName))) continue;
                    methodsToRemove.add(m);
                }
                for (JMethod m : methodsToRemove) {
                    implementationClass.methods().remove(m);
                }
                JMethod method = implementationClass.method(1, (JType)newInterfaceClass, "get" + this.firstUpper(fieldName));
                if (this.instantiation == Instantiation.LAZY) {
                    this.writeDebug("Applying LAZY instantiation...");
                    method.body()._if(JExpr.ref((String)fieldName).eq(JExpr._null()))._then().assign((JAssignmentTarget)JExpr.ref((String)fieldName), (JExpression)JExpr._new((JClass)newCollectionClass));
                }
                method.body()._return((JExpression)JExpr.ref((String)fieldName));
            }
        }
        this.writeSummary("\t" + modificationCount + " modification(s) to original code.");
        this.writeSummary(" ");
        this.writeSummary("Deletions:");
        if (this.deleteCandidates) {
            for (Candidate c : this.candidates.values()) {
                JDefinedClass parent;
                if (!this.isIncluded(c)) continue;
                JDefinedClass candidateClass = model.getClazz((CClassInfo)c.getClassInfo()).implClass;
                JPackage pkg = candidateClass._package();
                JDefinedClass factoryClass = pkg._getClass(this.factoryClassName);
                methodsToRemove = new ArrayList<JMethod>();
                for (JMethod m : factoryClass.methods()) {
                    if (m.type().compareTo((JType)candidateClass) != 0) continue;
                    methodsToRemove.add(m);
                }
                for (JMethod m : methodsToRemove) {
                    this.writeSummary("\tRemoving method " + m.type().fullName() + " " + m.name() + " from " + factoryClass.fullName());
                    factoryClass.methods().remove(m);
                    ++deletionCount;
                }
                if (candidateClass.parentContainer().isClass()) {
                    parent = (JDefinedClass)candidateClass.parentContainer();
                    this.writeSummary("\tRemoving class " + candidateClass.fullName() + " from class " + parent.fullName());
                    Iterator itor = parent.classes();
                    while (itor.hasNext()) {
                        if (!((JDefinedClass)itor.next()).equals(candidateClass)) continue;
                        itor.remove();
                        break;
                    }
                    ++deletionCount;
                    continue;
                }
                parent = (JPackage)candidateClass.parentContainer();
                this.writeSummary("\tRemoving class " + candidateClass.fullName() + " from package " + parent.name());
                parent.remove((JClass)candidateClass);
                ++deletionCount;
            }
        }
        this.writeSummary("\t" + deletionCount + " deletion(s) from original code.");
        this.writeSummary(" ");
        try {
            this.writeDebug("Closing summary...");
            this.closeSummary();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.writeDebug("Done");
        return true;
    }

    protected boolean isIncluded(Candidate candidate) {
        if (!this.hasIncludes() && !this.hasExcludes()) {
            return true;
        }
        if (this.hasIncludes() && !this.hasExcludes()) {
            return this.include.contains(candidate.getClassName());
        }
        if (!this.hasIncludes() && this.hasExcludes()) {
            return !this.exclude.contains(candidate.getClassName());
        }
        return this.include.contains(candidate.getClassName()) && !this.exclude.contains(candidate.getClassName());
    }

    protected String getIncludeOrExcludeReason(Candidate candidate) {
        if (!this.hasIncludes() && !this.hasExcludes()) {
            return "(default)";
        }
        if (this.hasIncludes() && !this.hasExcludes()) {
            return "(included)";
        }
        if (!this.hasIncludes() && this.hasExcludes()) {
            return "(excluded)";
        }
        return "(override)";
    }

    protected boolean hasIncludes() {
        return this.include != null;
    }

    protected boolean hasExcludes() {
        return this.exclude != null;
    }

    protected void readCandidates(File file, Set<String> candidates) throws IOException {
        String line;
        LineNumberReader input = new LineNumberReader(new FileReader(file));
        while ((line = input.readLine()) != null) {
            if ((line = line.trim()).startsWith("#")) continue;
            candidates.add(line);
        }
        input.close();
    }

    protected String firstUpper(String s) {
        if (s == null) {
            return null;
        }
        if (s.length() == 0) {
            return "";
        }
        return s.substring(0, 1).toUpperCase() + s.substring(1);
    }

    protected Map<String, Candidate> findCandidateClasses(Model model, ErrorHandler errorHandler) {
        HashMap<String, Candidate> candidates = new HashMap<String, Candidate>();
        for (CClassInfo classInfo : model.beans().values()) {
            CPropertyInfo property;
            String className = classInfo.fullName();
            if (classInfo.getProperties().size() != 1 || !(property = (CPropertyInfo)classInfo.getProperties().get(0)).isCollection() || property.ref().size() != 1) continue;
            Candidate candidate = new Candidate(classInfo);
            candidates.put(className, candidate);
            this.writeDebug("Candidate found: " + candidate.getClassName() + ", " + candidate.getFieldName() + ", [" + candidate.getFieldTypeName() + "]");
        }
        return candidates;
    }

    protected void writeSummary(String s) {
        if (this.summary != null) {
            this.summary.println(s);
            if (this.verbose) {
                System.out.println(s);
            }
        } else if (this.verbose) {
            System.out.println(s);
        }
    }

    protected void closeSummary() throws IOException {
        if (this.summary != null) {
            this.summary.close();
        }
    }

    protected void writeDebug(String s) {
        if (this.debugMode) {
            System.out.println("DEBUG:" + s);
        }
    }

    protected static String elementName(CPropertyInfo property) {
        try {
            if (property instanceof CElementPropertyInfo) {
                return ((CTypeRef)((CElementPropertyInfo)property).getTypes().get(0)).getTagName().getLocalPart();
            }
            return null;
        }
        catch (Exception ex) {
            return null;
        }
    }
}

