/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.jaxb.plugin;

import com.sun.tools.xjc.model.CClassInfo;
import com.sun.tools.xjc.model.CEnumLeafInfo;
import com.sun.tools.xjc.model.CPropertyInfo;
import com.sun.tools.xjc.outline.ClassOutline;
import com.sun.tools.xjc.outline.EnumOutline;
import com.sun.tools.xjc.outline.FieldOutline;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.jvnet.jaxb.plugin.Ignoring;
import org.jvnet.jaxb.plugin.customizations.Customizations;
import org.jvnet.jaxb.plugin.customizations.LegacyCustomizations;

public class ComposedIgnoring
implements Ignoring {
    private final Log logger;
    private final Ignoring ignoring;
    private final Ignoring legacyIgnoring;

    public ComposedIgnoring(Log logger, Ignoring ignoring) {
        this(logger, ignoring, null);
    }

    public ComposedIgnoring(Log logger, Ignoring ignoring, Ignoring legacyIgnoring) {
        this.logger = logger;
        this.ignoring = ignoring;
        this.legacyIgnoring = legacyIgnoring;
    }

    @Override
    public QName[] getIgnoredCustomizationElementNames() {
        return this.ignoring.getIgnoredCustomizationElementNames();
    }

    @Override
    public boolean isIgnored(ClassOutline classOutline) {
        if (this.ignoring.isIgnored(classOutline)) {
            return true;
        }
        if (this.legacyIgnoring != null && this.legacyIgnoring.isIgnored(classOutline)) {
            this.logger.warn((Object)("Please migrate your namespace in xsd / xjb from " + LegacyCustomizations.NAMESPACE_URI + " to " + Customizations.NAMESPACE_URI));
            return true;
        }
        return false;
    }

    @Override
    public boolean isIgnored(EnumOutline enumOutline) {
        if (this.ignoring.isIgnored(enumOutline)) {
            return true;
        }
        if (this.legacyIgnoring != null && this.legacyIgnoring.isIgnored(enumOutline)) {
            this.logger.warn((Object)("Please migrate your namespace in xsd / xjb from " + LegacyCustomizations.NAMESPACE_URI + " to " + Customizations.NAMESPACE_URI));
            return true;
        }
        return false;
    }

    @Override
    public boolean isIgnored(FieldOutline fieldOutline) {
        if (this.ignoring.isIgnored(fieldOutline)) {
            return true;
        }
        if (this.legacyIgnoring != null && this.legacyIgnoring.isIgnored(fieldOutline)) {
            this.logger.warn((Object)("Please migrate your namespace in xsd / xjb from " + LegacyCustomizations.NAMESPACE_URI + " to " + Customizations.NAMESPACE_URI));
            return true;
        }
        return false;
    }

    @Override
    public boolean isIgnored(CClassInfo classInfo) {
        if (this.ignoring.isIgnored(classInfo)) {
            return true;
        }
        if (this.legacyIgnoring != null && this.legacyIgnoring.isIgnored(classInfo)) {
            this.logger.warn((Object)("Please migrate your namespace in xsd / xjb from " + LegacyCustomizations.NAMESPACE_URI + " to " + Customizations.NAMESPACE_URI));
            return true;
        }
        return false;
    }

    @Override
    public boolean isIgnored(CEnumLeafInfo enumLeafInfo) {
        if (this.ignoring.isIgnored(enumLeafInfo)) {
            return true;
        }
        if (this.legacyIgnoring != null && this.legacyIgnoring.isIgnored(enumLeafInfo)) {
            this.logger.warn((Object)("Please migrate your namespace in xsd / xjb from " + LegacyCustomizations.NAMESPACE_URI + " to " + Customizations.NAMESPACE_URI));
            return true;
        }
        return false;
    }

    @Override
    public boolean isIgnored(CPropertyInfo propertyInfo) {
        if (this.ignoring.isIgnored(propertyInfo)) {
            return true;
        }
        if (this.legacyIgnoring != null && this.legacyIgnoring.isIgnored(propertyInfo)) {
            this.logger.warn((Object)("Please migrate your namespace in xsd / xjb from " + LegacyCustomizations.NAMESPACE_URI + " to " + Customizations.NAMESPACE_URI));
            return true;
        }
        return false;
    }
}

