/*
 * Decompiled with CFR 0.152.
 */
package netx.jnlp;

import java.applet.Applet;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URL;
import netx.jnlp.JNLPFile;
import netx.jnlp.LaunchException;
import netx.jnlp.LaunchHandler;
import netx.jnlp.ParseException;
import netx.jnlp.cache.UpdatePolicy;
import netx.jnlp.runtime.AppThreadGroup;
import netx.jnlp.runtime.AppletInstance;
import netx.jnlp.runtime.ApplicationInstance;
import netx.jnlp.runtime.JNLPClassLoader;
import netx.jnlp.runtime.JNLPRuntime;
import netx.jnlp.util.Reflect;

public class Launcher {
    private static final ThreadGroup mainGroup = new ThreadGroup(Launcher.R("LAllThreadGroup"));
    private LaunchHandler handler = null;
    private UpdatePolicy updatePolicy = JNLPRuntime.getDefaultUpdatePolicy();
    private boolean context = true;
    static /* synthetic */ Class class$netx$jnlp$Launcher;
    static /* synthetic */ Class array$Ljava$lang$String;

    private static String R(String key) {
        return JNLPRuntime.getMessage(key);
    }

    public Launcher() {
        this(null, null);
        if (this.handler == null) {
            this.handler = JNLPRuntime.getDefaultLaunchHandler();
        }
    }

    public Launcher(LaunchHandler handler) {
        this(handler, null);
    }

    public Launcher(LaunchHandler handler, UpdatePolicy policy) {
        if (policy == null) {
            policy = JNLPRuntime.getDefaultUpdatePolicy();
        }
        this.handler = handler;
        this.updatePolicy = policy;
    }

    public void setUpdatePolicy(UpdatePolicy policy) {
        if (policy == null) {
            throw new IllegalArgumentException(Launcher.R("LNullUpdatePolicy"));
        }
        this.updatePolicy = policy;
    }

    public UpdatePolicy getUpdatePolicy() {
        return this.updatePolicy;
    }

    public void setCreateAppContext(boolean context) {
        this.context = context;
    }

    public boolean isCreateAppContext() {
        return this.context;
    }

    public ApplicationInstance launch(JNLPFile file) throws LaunchException {
        TgThread tg = new TgThread(file);
        tg.start();
        try {
            tg.join();
        }
        catch (InterruptedException ex) {
            throw this.launchWarning(new LaunchException(file, ex, Launcher.R("LSMinor"), Launcher.R("LCSystem"), Launcher.R("LThreadInterrupted"), Launcher.R("LThreadInterruptedInfo")));
        }
        if (tg.getException() != null) {
            throw tg.getException();
        }
        if (this.handler != null) {
            this.handler.launchCompleted(tg.getApplication());
        }
        return tg.getApplication();
    }

    public ApplicationInstance launch(URL location) throws LaunchException {
        return this.launch(this.toFile(location));
    }

    public void launchBackground(JNLPFile file) {
        BgRunner runner = new BgRunner(file, null);
        new Thread(runner).start();
    }

    public void launchBackground(URL location) {
        BgRunner runner = new BgRunner(null, location);
        new Thread(runner).start();
    }

    public void launchExternal(JNLPFile file) throws LaunchException {
        if (file.getSourceLocation() != null) {
            this.launchExternal(file.getSourceLocation());
        } else if (file.getFileLocation() != null) {
            this.launchExternal(file.getFileLocation());
        } else {
            this.launchError(new LaunchException(file, null, Launcher.R("LSFatal"), Launcher.R("LCExternalLaunch"), Launcher.R("LNullLocation"), Launcher.R("LNullLocationInfo")));
        }
    }

    public void launchExternal(URL location) throws LaunchException {
        try {
            File netxFile;
            URL cs = (class$netx$jnlp$Launcher == null ? (class$netx$jnlp$Launcher = Launcher.class$("netx.jnlp.Launcher")) : class$netx$jnlp$Launcher).getProtectionDomain().getCodeSource().getLocation();
            if (JNLPRuntime.isDebug()) {
                System.out.println("netx.jar path: " + cs.getPath());
            }
            if (!(netxFile = new File(cs.getPath())).exists()) {
                throw this.launchError(new LaunchException(null, null, Launcher.R("LSFatal"), Launcher.R("LCExternalLaunch"), Launcher.R("LNetxJarMissing"), Launcher.R("LNetxJarMissingInfo")));
            }
            String[] command = new String[]{"javaw", "-jar", netxFile.toString(), "-jnlp", location.toString(), "-verbose"};
            Process p = Runtime.getRuntime().exec(command);
            new StreamEater(p.getErrorStream()).start();
            new StreamEater(p.getInputStream()).start();
            p.getOutputStream().close();
        }
        catch (NullPointerException ex) {
            throw this.launchError(new LaunchException(null, null, Launcher.R("LSFatal"), Launcher.R("LCExternalLaunch"), Launcher.R("LNetxJarMissing"), Launcher.R("LNetxJarMissingInfo")));
        }
        catch (Exception ex) {
            throw this.launchError(new LaunchException(null, ex, Launcher.R("LSFatal"), Launcher.R("LCExternalLaunch"), Launcher.R("LCouldNotLaunch"), Launcher.R("LCouldNotLaunchInfo")));
        }
    }

    private JNLPFile toFile(URL location) throws LaunchException {
        try {
            JNLPFile file;
            block5: {
                file = null;
                try {
                    file = new JNLPFile(location, true, this.updatePolicy);
                }
                catch (ParseException ex) {
                    file = new JNLPFile(location, false, this.updatePolicy);
                    LaunchException lex = this.launchWarning(new LaunchException(file, ex, Launcher.R("LSMinor"), Launcher.R("LCFileFormat"), Launcher.R("LNotToSpec"), Launcher.R("LNotToSpecInfo")));
                    if (lex == null) break block5;
                    throw lex;
                }
            }
            return file;
        }
        catch (Exception ex) {
            if (ex instanceof LaunchException) {
                throw (LaunchException)ex;
            }
            throw this.launchError(new LaunchException(null, ex, Launcher.R("LSFatal"), Launcher.R("LCReadError"), Launcher.R("LCantRead"), Launcher.R("LCantReadInfo")));
        }
    }

    protected ApplicationInstance launchApplication(JNLPFile file) throws LaunchException {
        if (!file.isApplication()) {
            throw this.launchError(new LaunchException(file, null, Launcher.R("LSFatal"), Launcher.R("LCClient"), Launcher.R("LNotApplication"), Launcher.R("LNotApplicationInfo")));
        }
        try {
            ApplicationInstance app = this.createApplication(file);
            app.initialize();
            String mainName = file.getApplication().getMainClass();
            Class<?> mainClass = app.getClassLoader().loadClass(mainName);
            Method main = mainClass.getDeclaredMethod("main", array$Ljava$lang$String == null ? (array$Ljava$lang$String = Launcher.class$("[Ljava.lang.String;")) : array$Ljava$lang$String);
            String[] args = file.getApplication().getArguments();
            Thread.currentThread().setContextClassLoader(app.getClassLoader());
            main.invoke(null, new Object[]{args});
            return app;
        }
        catch (LaunchException lex) {
            throw this.launchError(lex);
        }
        catch (Exception ex) {
            throw this.launchError(new LaunchException(file, ex, Launcher.R("LSFatal"), Launcher.R("LCLaunching"), Launcher.R("LCouldNotLaunch"), Launcher.R("LCouldNotLaunchInfo")));
        }
    }

    protected ApplicationInstance launchApplet(JNLPFile file, boolean enableCodeBase) throws LaunchException {
        if (!file.isApplet()) {
            throw this.launchError(new LaunchException(file, null, Launcher.R("LSFatal"), Launcher.R("LCClient"), Launcher.R("LNotApplet"), Launcher.R("LNotAppletInfo")));
        }
        try {
            AppletInstance applet = this.createApplet(file, enableCodeBase);
            applet.initialize();
            applet.getAppletEnvironment().startApplet();
            return applet;
        }
        catch (LaunchException lex) {
            throw this.launchError(lex);
        }
        catch (Exception ex) {
            throw this.launchError(new LaunchException(file, ex, Launcher.R("LSFatal"), Launcher.R("LCLaunching"), Launcher.R("LCouldNotLaunch"), Launcher.R("LCouldNotLaunchInfo")));
        }
    }

    protected ApplicationInstance launchInstaller(JNLPFile file) throws LaunchException {
        throw this.launchError(new LaunchException(file, null, Launcher.R("LSFatal"), Launcher.R("LCNotSupported"), Launcher.R("LNoInstallers"), Launcher.R("LNoInstallersInfo")));
    }

    protected AppletInstance createApplet(JNLPFile file, boolean enableCodeBase) throws LaunchException {
        try {
            JNLPClassLoader loader = JNLPClassLoader.getInstance(file, this.updatePolicy);
            if (enableCodeBase || file.getResources().getJARs().length == 0) {
                loader.enableCodeBase();
            }
            AppThreadGroup group = (AppThreadGroup)Thread.currentThread().getThreadGroup();
            String appletName = file.getApplet().getMainClass();
            Class appletClass = loader.loadClass(appletName);
            Applet applet = (Applet)appletClass.newInstance();
            AppletInstance appletInstance = new AppletInstance(file, group, loader, applet);
            group.setApplication(appletInstance);
            loader.setApplication(appletInstance);
            return appletInstance;
        }
        catch (Exception ex) {
            throw this.launchError(new LaunchException(file, ex, Launcher.R("LSFatal"), Launcher.R("CLInit"), Launcher.R("LInitApplet"), Launcher.R("LInitAppletInfo")));
        }
    }

    protected ApplicationInstance createApplication(JNLPFile file) throws LaunchException {
        try {
            JNLPClassLoader loader = JNLPClassLoader.getInstance(file, this.updatePolicy);
            AppThreadGroup group = (AppThreadGroup)Thread.currentThread().getThreadGroup();
            ApplicationInstance app = new ApplicationInstance(file, group, loader);
            group.setApplication(app);
            loader.setApplication(app);
            return app;
        }
        catch (Exception ex) {
            throw this.launchError(new LaunchException(file, ex, Launcher.R("LSFatal"), Launcher.R("CLInit"), Launcher.R("LInitApplet"), Launcher.R("LInitAppletInfo")));
        }
    }

    protected AppThreadGroup createThreadGroup(JNLPFile file) {
        return new AppThreadGroup(mainGroup, file.getTitle());
    }

    private LaunchException launchError(LaunchException ex) {
        if (this.handler != null) {
            this.handler.launchError(ex);
        }
        return ex;
    }

    private LaunchException launchWarning(LaunchException ex) {
        if (this.handler != null && !this.handler.launchWarning(ex)) {
            return ex;
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class StreamEater
    extends Thread {
        private InputStream stream;

        StreamEater(InputStream stream) {
            this.stream = new BufferedInputStream(stream);
        }

        public void run() {
            try {
                int c;
                while ((c = this.stream.read()) != -1) {
                    System.out.write(c);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private class BgRunner
    implements Runnable {
        private JNLPFile file;
        private URL location;

        BgRunner(JNLPFile file, URL location) {
            this.file = file;
            this.location = location;
        }

        public void run() {
            try {
                if (this.file != null) {
                    Launcher.this.launch(this.file);
                }
                if (this.location != null) {
                    Launcher.this.launch(this.location);
                }
            }
            catch (LaunchException launchException) {
                // empty catch block
            }
        }
    }

    private class TgThread
    extends Thread {
        private JNLPFile file;
        private ApplicationInstance application;
        private LaunchException exception;

        TgThread(JNLPFile file) {
            super((ThreadGroup)Launcher.this.createThreadGroup(file), file.getTitle());
            this.file = file;
        }

        public void run() {
            block6: {
                try {
                    if (Launcher.this.context) {
                        new Reflect().invokeStatic("sun.awt.SunToolkit", "createNewAppContext");
                    }
                    if (this.file.isApplication()) {
                        this.application = Launcher.this.launchApplication(this.file);
                        break block6;
                    }
                    if (this.file.isApplet()) {
                        this.application = Launcher.this.launchApplet(this.file, true);
                        break block6;
                    }
                    if (this.file.isInstaller()) {
                        this.application = Launcher.this.launchInstaller(this.file);
                        break block6;
                    }
                    throw Launcher.this.launchError(new LaunchException(this.file, null, Launcher.R("LSFatal"), Launcher.R("LCClient"), Launcher.R("LNotLaunchable"), Launcher.R("LNotLaunchableInfo")));
                }
                catch (LaunchException ex) {
                    this.exception = ex;
                }
            }
        }

        public LaunchException getException() {
            return this.exception;
        }

        public ApplicationInstance getApplication() {
            return this.application;
        }
    }
}

