/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine.extension;

import java.util.concurrent.TimeoutException;
import org.jspecify.annotations.Nullable;
import org.junit.jupiter.engine.extension.TimeoutDuration;
import org.junit.platform.commons.util.Preconditions;

class TimeoutExceptionFactory {
    private TimeoutExceptionFactory() {
    }

    static TimeoutException create(String methodSignature, TimeoutDuration timeoutDuration, @Nullable Throwable failure) {
        String message = "%s timed out after %s".formatted(Preconditions.notNull((Object)methodSignature, (String)"method signature must not be null"), Preconditions.notNull((Object)timeoutDuration, (String)"timeout duration must not be null"));
        TimeoutException timeoutException = new TimeoutException(message);
        if (failure != null) {
            timeoutException.addSuppressed(failure);
        }
        return timeoutException;
    }

    static TimeoutException create(String methodSignature, TimeoutDuration timeoutDuration) {
        return TimeoutExceptionFactory.create(methodSignature, timeoutDuration, null);
    }
}

