/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine.extension;

import java.util.Collections;
import java.util.List;
import org.junit.jupiter.api.extension.Extension;
import org.junit.jupiter.api.extension.TestTemplateInvocationContext;
import org.junit.jupiter.engine.extension.DefaultRepetitionInfo;
import org.junit.jupiter.engine.extension.RepeatedTestDisplayNameFormatter;
import org.junit.jupiter.engine.extension.RepetitionExtension;

class RepeatedTestInvocationContext
implements TestTemplateInvocationContext {
    private final DefaultRepetitionInfo repetitionInfo;
    private final RepeatedTestDisplayNameFormatter formatter;

    RepeatedTestInvocationContext(DefaultRepetitionInfo repetitionInfo, RepeatedTestDisplayNameFormatter formatter) {
        this.repetitionInfo = repetitionInfo;
        this.formatter = formatter;
    }

    public String getDisplayName(int invocationIndex) {
        return this.formatter.format(this.repetitionInfo.currentRepetition(), this.repetitionInfo.totalRepetitions());
    }

    public List<Extension> getAdditionalExtensions() {
        return Collections.singletonList(new RepetitionExtension(this.repetitionInfo));
    }
}

