/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine.discovery;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.junit.jupiter.engine.descriptor.ClassTestDescriptor;
import org.junit.jupiter.engine.discovery.ElementResolver;
import org.junit.jupiter.engine.discovery.predicates.IsInnerClass;
import org.junit.platform.commons.logging.Logger;
import org.junit.platform.commons.logging.LoggerFactory;
import org.junit.platform.commons.util.ReflectionUtils;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.UniqueId;

class JavaElementsResolver {
    private static final Logger logger = LoggerFactory.getLogger(JavaElementsResolver.class);
    private static final IsInnerClass isInnerClass = new IsInnerClass();
    private final TestDescriptor engineDescriptor;
    private final Set<ElementResolver> resolvers;

    JavaElementsResolver(TestDescriptor engineDescriptor, Set<ElementResolver> resolvers) {
        this.engineDescriptor = engineDescriptor;
        this.resolvers = resolvers;
    }

    void resolveClass(Class<?> testClass) {
        Set<TestDescriptor> resolvedDescriptors = this.resolveContainerWithParents(testClass);
        resolvedDescriptors.forEach(this::resolveChildren);
        if (resolvedDescriptors.isEmpty()) {
            logger.debug(() -> String.format("Class '%s' could not be resolved.", testClass.getName()));
        }
    }

    void resolveMethod(Class<?> testClass, Method testMethod) {
        Set<TestDescriptor> potentialParents = this.resolveContainerWithParents(testClass);
        Set<TestDescriptor> resolvedDescriptors = this.resolveForAllParents(testMethod, potentialParents);
        if (resolvedDescriptors.isEmpty()) {
            logger.debug(() -> String.format("Method '%s' could not be resolved.", testMethod.toGenericString()));
        }
        this.logMultipleTestDescriptorsForSingleElement(testMethod, resolvedDescriptors);
    }

    private Set<TestDescriptor> resolveContainerWithParents(Class<?> testClass) {
        if (isInnerClass.test(testClass)) {
            Set<TestDescriptor> potentialParents = this.resolveContainerWithParents(testClass.getDeclaringClass());
            return this.resolveForAllParents(testClass, potentialParents);
        }
        return this.resolveForAllParents(testClass, Collections.singleton(this.engineDescriptor));
    }

    void resolveUniqueId(UniqueId uniqueId) {
        uniqueId.getEngineId().ifPresent(engineId -> {
            if ("junit-jupiter".equals(engineId)) {
                ArrayList<UniqueId.Segment> remainingSegments = new ArrayList<UniqueId.Segment>(uniqueId.getSegments());
                remainingSegments.remove(0);
                int numSegmentsToResolve = remainingSegments.size();
                int numSegmentsResolved = this.resolveUniqueId(this.engineDescriptor, remainingSegments);
                if (numSegmentsResolved == 0) {
                    logger.warn(() -> String.format("Unique ID '%s' could not be resolved.", uniqueId));
                } else if (numSegmentsResolved != numSegmentsToResolve) {
                    logger.warn(() -> {
                        List segments = uniqueId.getSegments();
                        List unresolved = segments.subList(1, segments.size());
                        unresolved = unresolved.subList(numSegmentsResolved, unresolved.size());
                        return String.format("Unique ID '%s' could only be partially resolved. All resolved segments will be executed; however, the following segments could not be resolved: %s", uniqueId, unresolved);
                    });
                }
            }
        });
    }

    private int resolveUniqueId(TestDescriptor parent, List<UniqueId.Segment> remainingSegments) {
        if (remainingSegments.isEmpty()) {
            this.resolveChildren(parent);
            return 0;
        }
        UniqueId.Segment head = remainingSegments.remove(0);
        for (ElementResolver resolver : this.resolvers) {
            Optional<TestDescriptor> resolvedDescriptor = resolver.resolveUniqueId(head, parent);
            if (!resolvedDescriptor.isPresent()) continue;
            Optional<TestDescriptor> foundTestDescriptor = this.findTestDescriptorByUniqueId(resolvedDescriptor.get().getUniqueId());
            TestDescriptor descriptor = foundTestDescriptor.orElseGet(() -> {
                TestDescriptor newDescriptor = (TestDescriptor)resolvedDescriptor.get();
                parent.addChild(newDescriptor);
                return newDescriptor;
            });
            return 1 + this.resolveUniqueId(descriptor, remainingSegments);
        }
        return 0;
    }

    private Set<TestDescriptor> resolveContainerWithChildren(Class<?> containerClass, Set<TestDescriptor> potentialParents) {
        Set<TestDescriptor> resolvedDescriptors = this.resolveForAllParents(containerClass, potentialParents);
        resolvedDescriptors.forEach(this::resolveChildren);
        return resolvedDescriptors;
    }

    private Set<TestDescriptor> resolveForAllParents(AnnotatedElement element, Set<TestDescriptor> potentialParents) {
        HashSet<TestDescriptor> resolvedDescriptors = new HashSet<TestDescriptor>();
        potentialParents.forEach(parent -> resolvedDescriptors.addAll(this.resolve(element, (TestDescriptor)parent)));
        return resolvedDescriptors;
    }

    private void resolveChildren(TestDescriptor descriptor) {
        if (descriptor instanceof ClassTestDescriptor) {
            Class<?> testClass = ((ClassTestDescriptor)descriptor).getTestClass();
            this.resolveContainedMethods(descriptor, testClass);
            this.resolveContainedNestedClasses(descriptor, testClass);
        }
    }

    private void resolveContainedNestedClasses(TestDescriptor containerDescriptor, Class<?> clazz) {
        List nestedClassesCandidates = ReflectionUtils.findNestedClasses(clazz, (Predicate)isInnerClass);
        nestedClassesCandidates.forEach(nestedClass -> this.resolveContainerWithChildren((Class<?>)nestedClass, Collections.singleton(containerDescriptor)));
    }

    private void resolveContainedMethods(TestDescriptor containerDescriptor, Class<?> testClass) {
        List testMethodCandidates = ReflectionUtils.findMethods(testClass, method -> !ReflectionUtils.isPrivate((Member)method), (ReflectionUtils.HierarchyTraversalMode)ReflectionUtils.HierarchyTraversalMode.TOP_DOWN);
        testMethodCandidates.forEach(method -> this.resolve((AnnotatedElement)method, containerDescriptor));
    }

    private Set<TestDescriptor> resolve(AnnotatedElement element, TestDescriptor parent) {
        Set<TestDescriptor> descriptors = this.resolvers.stream().map(resolver -> this.tryToResolveWithResolver(element, parent, (ElementResolver)resolver)).filter(testDescriptors -> !testDescriptors.isEmpty()).flatMap(Collection::stream).collect(Collectors.toSet());
        this.logMultipleTestDescriptorsForSingleElement(element, descriptors);
        return descriptors;
    }

    private Set<TestDescriptor> tryToResolveWithResolver(AnnotatedElement element, TestDescriptor parent, ElementResolver resolver) {
        Set<TestDescriptor> resolvedDescriptors = resolver.resolveElement(element, parent);
        LinkedHashSet<TestDescriptor> result = new LinkedHashSet<TestDescriptor>();
        resolvedDescriptors.forEach(testDescriptor -> {
            Optional<TestDescriptor> existingTestDescriptor = this.findTestDescriptorByUniqueId(testDescriptor.getUniqueId());
            if (existingTestDescriptor.isPresent()) {
                result.add(existingTestDescriptor.get());
            } else {
                parent.addChild(testDescriptor);
                result.add((TestDescriptor)testDescriptor);
            }
        });
        return result;
    }

    private Optional<TestDescriptor> findTestDescriptorByUniqueId(UniqueId uniqueId) {
        return this.engineDescriptor.findByUniqueId(uniqueId);
    }

    private void logMultipleTestDescriptorsForSingleElement(AnnotatedElement element, Set<TestDescriptor> descriptors) {
        if (descriptors.size() > 1 && element instanceof Method) {
            Method method = (Method)element;
            logger.warn(() -> String.format("Possible configuration error: method [%s] resulted in multiple TestDescriptors %s. This is typically the result of annotating a method with multiple competing annotations such as @Test, @RepeatedTest, @ParameterizedTest, @TestFactory, etc.", method.toGenericString(), descriptors.stream().map(d -> d.getClass().getName()).collect(Collectors.toList())));
        }
    }
}

