/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.api;

import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import org.junit.jupiter.api.AssertionUtils;

class AssertFalse {
    private AssertFalse() {
    }

    static void assertFalse(boolean condition) {
        AssertFalse.assertFalse(() -> condition, () -> null);
    }

    static void assertFalse(boolean condition, String message) {
        AssertFalse.assertFalse(() -> condition, () -> message);
    }

    static void assertFalse(boolean condition, Supplier<String> messageSupplier) {
        AssertFalse.assertFalse(() -> condition, messageSupplier);
    }

    static void assertFalse(BooleanSupplier booleanSupplier) {
        AssertFalse.assertFalse(booleanSupplier, () -> null);
    }

    static void assertFalse(BooleanSupplier booleanSupplier, String message) {
        AssertFalse.assertFalse(booleanSupplier, () -> message);
    }

    static void assertFalse(BooleanSupplier booleanSupplier, Supplier<String> messageSupplier) {
        if (booleanSupplier.getAsBoolean()) {
            AssertionUtils.fail(AssertionUtils.format(false, true, AssertionUtils.nullSafeGet(messageSupplier)));
        }
    }
}

