/*
 * Decompiled with CFR 0.152.
 */
package org.jsmpp.examples;

import java.io.IOException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.log4j.PropertyConfigurator;
import org.jsmpp.InvalidResponseException;
import org.jsmpp.PDUException;
import org.jsmpp.bean.BindType;
import org.jsmpp.bean.DataCodings;
import org.jsmpp.bean.ESMClass;
import org.jsmpp.bean.NumberingPlanIndicator;
import org.jsmpp.bean.OptionalParameter;
import org.jsmpp.bean.RegisteredDelivery;
import org.jsmpp.bean.TypeOfNumber;
import org.jsmpp.extra.NegativeResponseException;
import org.jsmpp.extra.ResponseTimeoutException;
import org.jsmpp.session.SMPPSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StressClient
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(StressClient.class);
    private static final String DEFAULT_SYSID = "j";
    private static final String DEFAULT_PASSWORD = "jpwd";
    private static final String DEFAULT_SOURCEADDR = "1616";
    private static final String DEFAULT_DESTADDR = "62161616";
    private static final String DEFAULT_LOG4J_PATH = "stress/client-log4j.properties";
    private static final String DEFAULT_HOST = "localhost";
    private static final Integer DEFAULT_PORT = 8056;
    private static final Long DEFAULT_TRANSACTIONTIMER = 2000L;
    private static final Integer DEFAULT_BULK_SIZE = 100000;
    private static final Integer DEFAULT_PROCESSOR_DEGREE = 3;
    private static final Integer DEFAULT_MAX_OUTSTANDING = 10;
    private AtomicInteger requestCounter = new AtomicInteger();
    private AtomicInteger totalRequestCounter = new AtomicInteger();
    private AtomicInteger responseCounter = new AtomicInteger();
    private AtomicInteger totalResponseCounter = new AtomicInteger();
    private AtomicLong maxDelay = new AtomicLong();
    private ExecutorService execService;
    private String host;
    private int port;
    private int bulkSize;
    private SMPPSession smppSession = new SMPPSession();
    private AtomicBoolean exit = new AtomicBoolean();
    private int id;
    private String systemId;
    private String password;
    private String sourceAddr;
    private String destinationAddr;

    public StressClient(int id, String host, int port, int bulkSize, String systemId, String password, String sourceAddr, String destinationAddr, long transactionTimer, int pduProcessorDegree, int maxOutstanding) {
        this.id = id;
        this.host = host;
        this.port = port;
        this.bulkSize = bulkSize;
        this.systemId = systemId;
        this.password = password;
        this.sourceAddr = sourceAddr;
        this.destinationAddr = destinationAddr;
        this.smppSession.setPduProcessorDegree(pduProcessorDegree);
        this.smppSession.setTransactionTimer(transactionTimer);
        this.execService = Executors.newFixedThreadPool(maxOutstanding);
    }

    private void shutdown() {
        this.execService.shutdown();
        this.exit.set(true);
    }

    @Override
    public void run() {
        try {
            this.smppSession.connectAndBind(this.host, this.port, BindType.BIND_TRX, this.systemId, this.password, "cln", TypeOfNumber.UNKNOWN, NumberingPlanIndicator.UNKNOWN, null);
            LOGGER.info("Bound to {}:{}", (Object)this.host, (Object)this.port);
        }
        catch (IOException e) {
            LOGGER.error("Failed initialize connection or bind", (Throwable)e);
            return;
        }
        new TrafficWatcherThread().start();
        LOGGER.info("Starting to send {} bulk messages", (Object)this.bulkSize);
        for (int i = 0; i < this.bulkSize && !this.exit.get(); ++i) {
            this.execService.execute(this.newSendTask("Hello " + this.id + " idx=" + i));
        }
        while (!this.exit.get()) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        LOGGER.info("Done");
        this.smppSession.unbindAndClose();
    }

    private Runnable newSendTask(final String message) {
        return new Runnable(){

            @Override
            public void run() {
                try {
                    StressClient.this.requestCounter.incrementAndGet();
                    long startTime = System.currentTimeMillis();
                    StressClient.this.smppSession.submitShortMessage(null, TypeOfNumber.UNKNOWN, NumberingPlanIndicator.UNKNOWN, StressClient.this.sourceAddr, TypeOfNumber.UNKNOWN, NumberingPlanIndicator.UNKNOWN, StressClient.this.destinationAddr, new ESMClass(), (byte)0, (byte)0, null, null, new RegisteredDelivery(0), (byte)0, DataCodings.ZERO, (byte)0, message.getBytes(), new OptionalParameter[0]);
                    long delay = System.currentTimeMillis() - startTime;
                    StressClient.this.responseCounter.incrementAndGet();
                    if (StressClient.this.maxDelay.get() < delay) {
                        StressClient.this.maxDelay.set(delay);
                    }
                }
                catch (PDUException e) {
                    LOGGER.error("Failed submit short message '" + message + "'", (Throwable)e);
                    StressClient.this.shutdown();
                }
                catch (ResponseTimeoutException e) {
                    LOGGER.error("Failed submit short message '" + message + "'", (Throwable)e);
                    StressClient.this.shutdown();
                }
                catch (InvalidResponseException e) {
                    LOGGER.error("Failed submit short message '" + message + "'", (Throwable)e);
                    StressClient.this.shutdown();
                }
                catch (NegativeResponseException e) {
                    LOGGER.error("Failed submit short message '" + message + "'", (Throwable)e);
                    StressClient.this.shutdown();
                }
                catch (IOException e) {
                    LOGGER.error("Failed submit short message '" + message + "'", (Throwable)e);
                    StressClient.this.shutdown();
                }
            }
        };
    }

    public static void main(String[] args) {
        int maxOutstanding;
        int processorDegree;
        int bulkSize;
        long transactionTimer;
        int port;
        PropertyConfigurator.configure((String)System.getProperty("jsmpp.server.log4jPath", DEFAULT_LOG4J_PATH));
        String host = System.getProperty("jsmpp.client.host", DEFAULT_HOST);
        String systemId = System.getProperty("jsmpp.client.systemId", DEFAULT_SYSID);
        String password = System.getProperty("jsmpp.client.password", DEFAULT_PASSWORD);
        String sourceAddr = System.getProperty("jsmpp.client.sourceAddr", DEFAULT_SOURCEADDR);
        String destinationAddr = System.getProperty("jsmpp.client.destinationAddr", DEFAULT_DESTADDR);
        try {
            port = Integer.parseInt(System.getProperty("jsmpp.client.port", DEFAULT_PORT.toString()));
        }
        catch (NumberFormatException e) {
            port = DEFAULT_PORT;
        }
        try {
            transactionTimer = Integer.parseInt(System.getProperty("jsmpp.client.transactionTimer", DEFAULT_TRANSACTIONTIMER.toString()));
        }
        catch (NumberFormatException e) {
            transactionTimer = DEFAULT_TRANSACTIONTIMER;
        }
        try {
            bulkSize = Integer.parseInt(System.getProperty("jsmpp.client.bulkSize", DEFAULT_BULK_SIZE.toString()));
        }
        catch (NumberFormatException e) {
            bulkSize = DEFAULT_BULK_SIZE;
        }
        try {
            processorDegree = Integer.parseInt(System.getProperty("jsmpp.client.procDegree", DEFAULT_PROCESSOR_DEGREE.toString()));
        }
        catch (NumberFormatException e) {
            processorDegree = DEFAULT_PROCESSOR_DEGREE;
        }
        try {
            maxOutstanding = Integer.parseInt(System.getProperty("jsmpp.client.maxOutstanding", DEFAULT_MAX_OUTSTANDING.toString()));
        }
        catch (NumberFormatException e) {
            maxOutstanding = DEFAULT_MAX_OUTSTANDING;
        }
        LOGGER.info("Target server {}:{}", (Object)host, (Object)port);
        LOGGER.info("System ID: {}", (Object)systemId);
        LOGGER.info("Password: {}", (Object)password);
        LOGGER.info("Source address: {}", (Object)sourceAddr);
        LOGGER.info("Destination address: {}", (Object)destinationAddr);
        LOGGER.info("Transaction timer: {}", (Object)transactionTimer);
        LOGGER.info("Bulk size: {}", (Object)bulkSize);
        LOGGER.info("Max outstanding: {}", (Object)maxOutstanding);
        LOGGER.info("Processor degree: {}", (Object)processorDegree);
        StressClient stressClient = new StressClient(0, host, port, bulkSize, systemId, password, sourceAddr, destinationAddr, transactionTimer, processorDegree, maxOutstanding);
        stressClient.run();
    }

    private class TrafficWatcherThread
    extends Thread {
        private TrafficWatcherThread() {
        }

        @Override
        public void run() {
            LOGGER.info("Starting traffic watcher...");
            while (!StressClient.this.exit.get()) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                int requestPerSecond = StressClient.this.requestCounter.getAndSet(0);
                int responsePerSecond = StressClient.this.responseCounter.getAndSet(0);
                long maxDelayPerSecond = StressClient.this.maxDelay.getAndSet(0L);
                StressClient.this.totalRequestCounter.addAndGet(requestPerSecond);
                int total = StressClient.this.totalResponseCounter.addAndGet(responsePerSecond);
                LOGGER.info("Request/Response per second: {}/{} of {} maxDelay={}", new Object[]{requestPerSecond, responsePerSecond, total, maxDelayPerSecond});
                if (total != StressClient.this.bulkSize) continue;
                StressClient.this.shutdown();
            }
        }
    }
}

