/*
 * Decompiled with CFR 0.152.
 */
package org.jsmpp.examples;

import java.io.IOException;
import java.util.Date;
import org.jsmpp.InvalidResponseException;
import org.jsmpp.PDUException;
import org.jsmpp.bean.Alphabet;
import org.jsmpp.bean.BindType;
import org.jsmpp.bean.DataCoding;
import org.jsmpp.bean.ESMClass;
import org.jsmpp.bean.GeneralDataCoding;
import org.jsmpp.bean.MessageClass;
import org.jsmpp.bean.NumberingPlanIndicator;
import org.jsmpp.bean.OptionalParameter;
import org.jsmpp.bean.RegisteredDelivery;
import org.jsmpp.bean.SMSCDeliveryReceipt;
import org.jsmpp.bean.TypeOfNumber;
import org.jsmpp.extra.NegativeResponseException;
import org.jsmpp.extra.ResponseTimeoutException;
import org.jsmpp.session.BindParameter;
import org.jsmpp.session.SMPPSession;
import org.jsmpp.util.AbsoluteTimeFormatter;
import org.jsmpp.util.TimeFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleSubmitExample {
    private static final Logger LOGGER = LoggerFactory.getLogger(SimpleSubmitExample.class);
    private static final TimeFormatter TIME_FORMATTER = new AbsoluteTimeFormatter();

    public static void main(String[] args) {
        SMPPSession session = new SMPPSession();
        try {
            LOGGER.info("Connecting");
            String systemId = session.connectAndBind("localhost", 8056, new BindParameter(BindType.BIND_TX, "j", "jpwda", "cp", TypeOfNumber.UNKNOWN, NumberingPlanIndicator.UNKNOWN, null));
            LOGGER.info("Connected with SMSC with system id {}", (Object)systemId);
            try {
                String messageId = session.submitShortMessage("CMT", TypeOfNumber.INTERNATIONAL, NumberingPlanIndicator.UNKNOWN, "1616", TypeOfNumber.INTERNATIONAL, NumberingPlanIndicator.UNKNOWN, "628176504657", new ESMClass(), (byte)0, (byte)1, TIME_FORMATTER.format(new Date()), null, new RegisteredDelivery(SMSCDeliveryReceipt.DEFAULT), (byte)0, (DataCoding)new GeneralDataCoding(Alphabet.ALPHA_DEFAULT, MessageClass.CLASS1, false), (byte)0, "jSMPP simplify SMPP on Java platform".getBytes(), new OptionalParameter[0]);
                LOGGER.info("Message submitted, message_id is {}", (Object)messageId);
            }
            catch (PDUException e) {
                LOGGER.error("Invalid PDU parameter", (Throwable)e);
            }
            catch (ResponseTimeoutException e) {
                LOGGER.error("Response timeout", (Throwable)e);
            }
            catch (InvalidResponseException e) {
                LOGGER.error("Receive invalid response", (Throwable)e);
            }
            catch (NegativeResponseException e) {
                LOGGER.error("Receive negative response, e");
            }
            catch (IOException e) {
                LOGGER.error("IO error occurred", (Throwable)e);
            }
            session.unbindAndClose();
        }
        catch (IOException e) {
            LOGGER.error("Failed connect and bind to host", (Throwable)e);
        }
    }
}

