/*
 * Decompiled with CFR 0.152.
 */
package org.jsmpp.examples;

import java.io.IOException;
import org.jsmpp.bean.BindType;
import org.jsmpp.bean.NumberingPlanIndicator;
import org.jsmpp.bean.TypeOfNumber;
import org.jsmpp.examples.session.connection.socket.TrustStoreSSLSocketConnectionFactory;
import org.jsmpp.session.BindParameter;
import org.jsmpp.session.SMPPSession;
import org.jsmpp.session.connection.ConnectionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenAndBindExample {
    private static final Logger LOGGER = LoggerFactory.getLogger(OpenAndBindExample.class);

    public static void main(String[] args) throws Exception {
        boolean useSsl = true;
        String host = "localhost";
        int port = 8056;
        SMPPSession session = useSsl ? new SMPPSession((ConnectionFactory)new TrustStoreSSLSocketConnectionFactory()) : new SMPPSession();
        try {
            LOGGER.info("Connect and bind to {} port {}{}", new Object[]{host, port, useSsl ? " (SSL)" : ""});
            String systemId = session.connectAndBind(host, port, new BindParameter(BindType.BIND_TRX, "j", "jpwd", "cp", TypeOfNumber.UNKNOWN, NumberingPlanIndicator.UNKNOWN, null));
            LOGGER.info("Connected with SMSC with system id {}", (Object)systemId);
            try {
                Thread.sleep(10000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        catch (IOException e) {
            LOGGER.error("Failed connect and bind to host", (Throwable)e);
        }
        session.unbindAndClose();
    }
}

