/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.instructions;

import java.util.EnumSet;
import org.jruby.RubyProc;
import org.jruby.ir.IRFlags;
import org.jruby.ir.IRScope;
import org.jruby.ir.IRVisitor;
import org.jruby.ir.Operation;
import org.jruby.ir.instructions.ClosureAcceptingInstr;
import org.jruby.ir.instructions.FixedArityInstr;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.instructions.OneOperandResultBaseInstr;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.operands.WrappedIRClosure;
import org.jruby.ir.persistence.IRReaderDecoder;
import org.jruby.ir.persistence.IRWriterEncoder;
import org.jruby.ir.transformations.inlining.CloneInfo;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Block;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class BuildLambdaInstr
extends OneOperandResultBaseInstr
implements FixedArityInstr,
ClosureAcceptingInstr {
    public BuildLambdaInstr(Variable result2, WrappedIRClosure lambdaBody) {
        super(Operation.LAMBDA, result2, lambdaBody);
    }

    @Override
    public boolean computeScopeFlags(IRScope scope, EnumSet<IRFlags> flags2) {
        flags2.add(IRFlags.BINDING_HAS_ESCAPED);
        return true;
    }

    @Override
    public Instr clone(CloneInfo ii) {
        return new BuildLambdaInstr(ii.getRenamedVariable(this.getResult()), (WrappedIRClosure)this.getLambdaBody().cloneForInlining(ii));
    }

    public WrappedIRClosure getLambdaBody() {
        return (WrappedIRClosure)this.getOperand1();
    }

    @Override
    public Operand getClosureArg() {
        return this.getOperand1();
    }

    @Override
    public boolean hasLiteralClosure() {
        return this.getClosureArg() instanceof WrappedIRClosure;
    }

    @Override
    public void encode(IRWriterEncoder e) {
        super.encode(e);
        e.encode(this.getLambdaBody());
    }

    public static BuildLambdaInstr decode(IRReaderDecoder d) {
        return new BuildLambdaInstr(d.decodeVariable(), (WrappedIRClosure)d.decodeOperand());
    }

    @Override
    public Object interpret(ThreadContext context, StaticScope currScope, DynamicScope currDynScope, IRubyObject self2, Object[] temp) {
        this.getLambdaBody().getClosure().getStaticScope().determineModule();
        Block block = (Block)this.getLambdaBody().retrieve(context, self2, currScope, currDynScope, temp);
        return RubyProc.newProc(context.runtime, block, Block.Type.LAMBDA);
    }

    @Override
    public void visit(IRVisitor visitor) {
        visitor.BuildLambdaInstr(this);
    }
}

