/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.representations;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jruby.ir.Tuple;
import org.jruby.ir.instructions.BranchInstr;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.instructions.JumpInstr;
import org.jruby.ir.instructions.JumpTargetInstr;
import org.jruby.ir.representations.BasicBlock;
import org.jruby.ir.representations.CFG;
import org.jruby.ir.util.IGVHelper;
import org.jruby.ir.util.IGVInstrListener;

public class IGVCFGVisitor {
    PrintStream writer;
    Map<BasicBlock, Integer> indexOffsets = new HashMap<BasicBlock, Integer>();
    List<Tuple<Integer, Integer>> instrEdges = new ArrayList<Tuple<Integer, Integer>>();
    List<Tuple<Integer, JumpTargetInstr>> extraInstrEdges = new ArrayList<Tuple<Integer, JumpTargetInstr>>();
    Instr lastInstr = null;
    IGVInstrListener listener;

    public IGVCFGVisitor(CFG cfg, PrintStream writer, String name2) {
        this.writer = writer;
        this.listener = (IGVInstrListener)cfg.getScope().getManager().getInstructionsListener();
        this.CFG(cfg, name2);
        this.listener.reset();
    }

    protected void visitBasicBlocks(CFG cfg) {
        for (BasicBlock basicBlock : cfg.getBasicBlocks()) {
            this.BasicBlock(basicBlock);
        }
    }

    protected void visitEdges(CFG cfg) {
        for (BasicBlock basicBlock : cfg.getBasicBlocks()) {
            IGVHelper.startTag(this.writer, "block", "name", basicBlock.getLabel());
            IGVHelper.startTag(this.writer, "successors");
            for (BasicBlock destination : cfg.getOutgoingDestinations(basicBlock)) {
                IGVHelper.emptyTag(this.writer, "successor", "name", destination.getLabel());
            }
            IGVHelper.endTag(this.writer, "successors");
            IGVHelper.startTag(this.writer, "nodes");
            for (Instr instr : basicBlock.getInstrs()) {
                IGVHelper.emptyTag(this.writer, "node", "id", System.identityHashCode(instr));
            }
            for (Instr instr : this.listener.removedList(basicBlock)) {
                IGVHelper.emptyTag(this.writer, "removeNode", "id", System.identityHashCode(instr));
            }
            IGVHelper.endTag(this.writer, "nodes");
            IGVHelper.endTag(this.writer, "block");
        }
    }

    protected void visitInstrs(BasicBlock basicBlock) {
        List<Instr> instrs = basicBlock.getInstrs();
        int size2 = instrs.size();
        if (size2 > 0) {
            int lastIPC = this.Instr(instrs.get(0));
            if (this.lastInstr != null && !(this.lastInstr instanceof JumpInstr)) {
                this.instrEdges.add(new Tuple<Integer, Integer>(System.identityHashCode(this.lastInstr), lastIPC));
            }
            for (int i2 = 1; i2 < size2; ++i2) {
                int ipc = this.Instr(instrs.get(i2));
                this.instrEdges.add(new Tuple<Integer, Integer>(lastIPC, ipc));
                lastIPC = ipc;
            }
            this.lastInstr = instrs.get(size2 - 1);
        }
    }

    public void BasicBlock(BasicBlock basicBlock) {
        if (!basicBlock.getInstrs().isEmpty()) {
            this.indexOffsets.put(basicBlock, System.identityHashCode(basicBlock.getInstrs().get(0)));
        }
        this.visitInstrs(basicBlock);
    }

    public void CFG(CFG cfg, String name2) {
        IGVHelper.startTag(this.writer, "graph");
        IGVHelper.startTag(this.writer, "properties");
        IGVHelper.property(this.writer, "name", name2);
        IGVHelper.endTag(this.writer, "properties");
        IGVHelper.startTag(this.writer, "nodes");
        this.visitBasicBlocks(cfg);
        IGVHelper.endTag(this.writer, "nodes");
        IGVHelper.startTag(this.writer, "edges");
        for (Tuple<Integer, Integer> tuple : this.instrEdges) {
            IGVHelper.emptyTag(this.writer, "edge", "from", tuple.a, "to", tuple.b);
        }
        for (Tuple<Integer, Object> tuple : this.extraInstrEdges) {
            IGVHelper.emptyTag(this.writer, "edge", "from", tuple.a, "to", this.indexOffsets.get(cfg.getBBForLabel(((JumpTargetInstr)tuple.b).getJumpTarget())));
        }
        for (Tuple<Object, Object> tuple : this.listener.getRemovedEdges()) {
            IGVHelper.emptyTag(this.writer, "removedEdge", "from", System.identityHashCode(tuple.a), "to", System.identityHashCode(tuple.b));
        }
        IGVHelper.endTag(this.writer, "edges");
        IGVHelper.startTag(this.writer, "controlFlow");
        this.visitEdges(cfg);
        IGVHelper.endTag(this.writer, "controlFlow");
        IGVHelper.endTag(this.writer, "graph");
    }

    public int Instr(Instr instr) {
        int ipc = System.identityHashCode(instr);
        IGVHelper.startTag(this.writer, "node", "id", ipc);
        IGVHelper.startTag(this.writer, "properties");
        IGVHelper.property(this.writer, "label", ipc);
        IGVHelper.property(this.writer, "name", instr);
        if (instr instanceof BranchInstr) {
            this.extraInstrEdges.add(new Tuple<Integer, JumpTargetInstr>(ipc, (JumpTargetInstr)((Object)instr)));
        }
        IGVHelper.endTag(this.writer, "properties");
        IGVHelper.endTag(this.writer, "node");
        return ipc;
    }
}

