/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.ffi.jffi;

import com.kenai.jffi.CallingConvention;
import com.kenai.jffi.Function;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyHash;
import org.jruby.RubyModule;
import org.jruby.anno.JRubyMethod;
import org.jruby.ext.ffi.AbstractInvoker;
import org.jruby.ext.ffi.Enums;
import org.jruby.ext.ffi.MemoryIO;
import org.jruby.ext.ffi.Pointer;
import org.jruby.ext.ffi.Type;
import org.jruby.ext.ffi.jffi.CodeMemoryIO;
import org.jruby.ext.ffi.jffi.FFIUtil;
import org.jruby.ext.ffi.jffi.MethodFactory;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class JFFIInvoker
extends AbstractInvoker {
    private final Function function;
    private final Type returnType;
    private final Type[] parameterTypes;
    private final CallingConvention convention;
    private final IRubyObject enums;

    public static RubyClass createInvokerClass(Ruby runtime2, RubyModule module) {
        RubyClass result2 = module.defineClassUnder("Invoker", module.getClass("AbstractInvoker"), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
        result2.defineAnnotatedMethods(AbstractInvoker.class);
        result2.defineAnnotatedMethods(JFFIInvoker.class);
        result2.defineAnnotatedConstants(JFFIInvoker.class);
        return result2;
    }

    JFFIInvoker(Ruby runtime2, long address2, Type returnType, Type[] parameterTypes, CallingConvention convention) {
        this(runtime2, runtime2.getModule("FFI").getClass("Invoker"), new CodeMemoryIO(runtime2, address2), returnType, parameterTypes, convention, null);
    }

    JFFIInvoker(Ruby runtime2, RubyClass klass, MemoryIO fptr, Type returnType, Type[] parameterTypes, CallingConvention convention, IRubyObject enums) {
        super(runtime2, klass, parameterTypes.length, fptr);
        com.kenai.jffi.Type jffiReturnType = FFIUtil.getFFIType(returnType);
        if (jffiReturnType == null) {
            throw runtime2.newArgumentError("Invalid return type " + returnType);
        }
        com.kenai.jffi.Type[] jffiParamTypes = new com.kenai.jffi.Type[parameterTypes.length];
        for (int i2 = 0; i2 < jffiParamTypes.length; ++i2) {
            jffiParamTypes[i2] = FFIUtil.getFFIType(parameterTypes[i2]);
            if (jffiParamTypes[i2] != null) continue;
            throw runtime2.newArgumentError("Invalid parameter type " + parameterTypes[i2]);
        }
        this.function = new Function(fptr.address(), jffiReturnType, jffiParamTypes);
        this.parameterTypes = (Type[])parameterTypes.clone();
        this.returnType = returnType;
        this.convention = convention;
        this.enums = enums;
        this.getSingletonClass().addMethod("call", this.createDynamicMethod(this.getSingletonClass()));
    }

    @JRubyMethod(name={"new"}, meta=true, required=4)
    public static IRubyObject newInstance(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        if (!(args2[0] instanceof Pointer)) {
            throw context.runtime.newTypeError("Invalid function address " + args2[0].getMetaClass().getName() + " (expected FFI::Pointer)");
        }
        if (!(args2[1] instanceof RubyArray)) {
            throw context.runtime.newTypeError("Invalid parameter array " + args2[1].getMetaClass().getName() + " (expected Array)");
        }
        if (!(args2[2] instanceof Type)) {
            throw context.runtime.newTypeError("Invalid return type " + args2[2]);
        }
        Pointer ptr = (Pointer)args2[0];
        RubyArray paramTypes = (RubyArray)args2[1];
        Type returnType = (Type)args2[2];
        String convention = "default";
        IRubyObject enums = null;
        if (args2[3] instanceof RubyHash) {
            RubyHash options2 = (RubyHash)args2[3];
            convention = options2.fastARef(context.runtime.newSymbol("convention")).asJavaString();
            enums = options2.fastARef(context.runtime.newSymbol("enums"));
            if (!(enums == null || enums.isNil() || enums instanceof RubyHash || enums instanceof Enums)) {
                throw context.runtime.newTypeError("wrong type for options[:enum] " + enums.getMetaClass().getName() + " (expected Hash or Enums)");
            }
        } else {
            convention = args2[3].asJavaString();
        }
        Type[] parameterTypes = new Type[paramTypes.size()];
        for (int i2 = 0; i2 < parameterTypes.length; ++i2) {
            IRubyObject type2 = paramTypes.entry(i2);
            if (!(type2 instanceof Type)) {
                throw context.runtime.newArgumentError("Invalid parameter type");
            }
            parameterTypes[i2] = (Type)paramTypes.entry(i2);
        }
        MemoryIO fptr = ptr.getMemoryIO();
        return new JFFIInvoker(context.runtime, (RubyClass)recv2, fptr, returnType, parameterTypes, "stdcall".equals(convention) ? CallingConvention.STDCALL : CallingConvention.DEFAULT, enums);
    }

    @Override
    public DynamicMethod createDynamicMethod(RubyModule module) {
        return MethodFactory.createDynamicMethod(this.getRuntime(), module, this.function, this.returnType, this.parameterTypes, this.convention, this.enums, false);
    }
}

