/*
 * Decompiled with CFR 0.152.
 */
package jnr.posix;

import java.io.FileDescriptor;
import jnr.constants.platform.Errno;
import jnr.constants.platform.Sysconf;
import jnr.ffi.Pointer;
import jnr.ffi.mapper.FromNativeContext;
import jnr.posix.BaseNativePOSIX;
import jnr.posix.FileStat;
import jnr.posix.LibCProvider;
import jnr.posix.LinuxFileStat32;
import jnr.posix.LinuxFileStat64;
import jnr.posix.LinuxLibC;
import jnr.posix.LinuxMsgHdr;
import jnr.posix.LinuxPasswd;
import jnr.posix.LinuxSocketMacros;
import jnr.posix.MsgHdr;
import jnr.posix.NativeTimes;
import jnr.posix.POSIXHandler;
import jnr.posix.SocketMacros;
import jnr.posix.Times;
import jnr.posix.util.Platform;

final class LinuxPOSIX
extends BaseNativePOSIX {
    private volatile boolean use_fxstat64 = true;
    private volatile boolean use_lxstat64 = true;
    private volatile boolean use_xstat64 = true;
    private final int statVersion;
    public static final BaseNativePOSIX.PointerConverter PASSWD = new BaseNativePOSIX.PointerConverter(){

        public Object fromNative(Object arg2, FromNativeContext ctx) {
            return arg2 != null ? new LinuxPasswd((Pointer)arg2) : null;
        }
    };

    LinuxPOSIX(LibCProvider libcProvider, POSIXHandler handler) {
        super(libcProvider, handler);
        if (Platform.IS_32_BIT) {
            this.statVersion = 3;
        } else {
            FileStat stat2 = this.allocateStat();
            this.statVersion = ((LinuxLibC)this.libc()).__xstat64(0, "/dev/null", stat2) < 0 ? 1 : 0;
        }
    }

    public FileStat allocateStat() {
        if (Platform.IS_32_BIT) {
            return new LinuxFileStat32(this);
        }
        return new LinuxFileStat64(this);
    }

    public MsgHdr allocateMsgHdr() {
        return new LinuxMsgHdr(this);
    }

    public SocketMacros socketMacros() {
        return LinuxSocketMacros.INSTANCE;
    }

    private int old_fstat(int fd, FileStat stat2) {
        try {
            return super.fstat(fd, stat2);
        }
        catch (UnsatisfiedLinkError ex2) {
            this.handler.unimplementedError("fstat");
            return -1;
        }
    }

    public int fstat(int fd, FileStat stat2) {
        if (this.use_fxstat64) {
            try {
                int ret = ((LinuxLibC)this.libc()).__fxstat64(this.statVersion, fd, stat2);
                if (ret < 0) {
                    this.handler.error(Errno.valueOf(this.errno()), "fstat", Integer.toString(fd));
                }
                return ret;
            }
            catch (UnsatisfiedLinkError ex) {
                this.use_fxstat64 = false;
                return this.old_fstat(fd, stat2);
            }
        }
        return this.old_fstat(fd, stat2);
    }

    public FileStat fstat(int fd) {
        FileStat stat2 = this.allocateStat();
        int ret = this.fstat(fd, stat2);
        if (ret < 0) {
            this.handler.error(Errno.valueOf(this.errno()), "fstat", Integer.toString(fd));
        }
        return stat2;
    }

    public FileStat fstat(FileDescriptor fileDescriptor) {
        FileStat stat2 = this.allocateStat();
        int fd = this.helper.getfd(fileDescriptor);
        int ret = this.fstat(fd, stat2);
        if (ret < 0) {
            this.handler.error(Errno.valueOf(this.errno()), "fstat", Integer.toString(fd));
        }
        return stat2;
    }

    private final int old_lstat(String path2, FileStat stat2) {
        try {
            return super.lstat(path2, stat2);
        }
        catch (UnsatisfiedLinkError ex) {
            this.handler.unimplementedError("lstat");
            return -1;
        }
    }

    public int lstat(String path2, FileStat stat2) {
        if (this.use_lxstat64) {
            try {
                return ((LinuxLibC)this.libc()).__lxstat64(this.statVersion, path2, stat2);
            }
            catch (UnsatisfiedLinkError ex) {
                this.use_lxstat64 = false;
                return this.old_lstat(path2, stat2);
            }
        }
        return this.old_lstat(path2, stat2);
    }

    public FileStat lstat(String path2) {
        FileStat stat2 = this.allocateStat();
        int ret = this.lstat(path2, stat2);
        if (ret < 0) {
            this.handler.error(Errno.valueOf(this.errno()), "lstat", path2);
        }
        return stat2;
    }

    private final int old_stat(String path2, FileStat stat2) {
        try {
            return super.stat(path2, stat2);
        }
        catch (UnsatisfiedLinkError ex) {
            this.handler.unimplementedError("stat");
            return -1;
        }
    }

    public int stat(String path2, FileStat stat2) {
        if (this.use_xstat64) {
            try {
                return ((LinuxLibC)this.libc()).__xstat64(this.statVersion, path2, stat2);
            }
            catch (UnsatisfiedLinkError ex) {
                this.use_xstat64 = false;
                return this.old_stat(path2, stat2);
            }
        }
        return this.old_stat(path2, stat2);
    }

    public FileStat stat(String path2) {
        FileStat stat2 = this.allocateStat();
        int ret = this.stat(path2, stat2);
        if (ret < 0) {
            this.handler.error(Errno.valueOf(this.errno()), "stat", path2);
        }
        return stat2;
    }

    public long sysconf(Sysconf name2) {
        return this.libc().sysconf(name2);
    }

    public Times times() {
        return NativeTimes.times(this);
    }
}

