/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime.profile.builtin;

import java.io.PrintStream;
import java.util.Arrays;
import java.util.Comparator;
import org.jruby.runtime.profile.builtin.Invocation;
import org.jruby.runtime.profile.builtin.InvocationSet;
import org.jruby.runtime.profile.builtin.MethodData;
import org.jruby.runtime.profile.builtin.ProfileData;
import org.jruby.runtime.profile.builtin.ProfilePrinter;
import org.jruby.util.collections.IntHashMap;

public class GraphProfilePrinter
extends ProfilePrinter {
    public GraphProfilePrinter(ProfileData profileData) {
        super(profileData);
    }

    GraphProfilePrinter(ProfileData profileData, Invocation topInvocation) {
        super(profileData, topInvocation);
    }

    @Override
    public void printHeader(PrintStream out) {
        out.printf("\n%s profile results:\n", this.getThreadName());
    }

    @Override
    public void printProfile(PrintStream out, boolean first2) {
        Invocation topInvocation = this.getTopInvocation();
        if (!first2) {
            out.println();
        }
        out.printf("Total time: %s\n\n", GraphProfilePrinter.nanoString(topInvocation.getDuration()));
        out.println(" %total   %self       total        self    children                 calls  name");
        IntHashMap<MethodData> methods2 = GraphProfilePrinter.methodData(topInvocation);
        MethodData[] sortedMethods = methods2.values().toArray(new MethodData[methods2.size()]);
        Arrays.sort(sortedMethods, new Comparator<MethodData>(){

            @Override
            public int compare(MethodData md1, MethodData md2) {
                long time2;
                long time1 = md1.totalTime();
                return time1 == (time2 = md2.totalTime()) ? 0 : (time1 < time2 ? 1 : -1);
            }
        });
        for (final MethodData data2 : sortedMethods) {
            if (this.isProfilerInvocation((Invocation)data2.invocations.get(0))) continue;
            out.println("---------------------------------------------------------------------------------------------------------");
            int serial = data2.serialNumber;
            if (serial != 0) {
                int[] parentSerialsInts = data2.parents();
                Integer[] parentSerials = new Integer[parentSerialsInts.length];
                for (int i2 = 0; i2 < parentSerialsInts.length; ++i2) {
                    parentSerials[i2] = parentSerialsInts[i2];
                }
                Arrays.sort(parentSerials, new Comparator<Integer>(){

                    @Override
                    public int compare(Integer parent1, Integer parent2) {
                        long time2;
                        long time1 = data2.rootInvocationsFromParent(parent1).totalTime();
                        return time1 == (time2 = data2.rootInvocationsFromParent(parent2).totalTime()) ? 0 : (time1 < time2 ? -1 : 1);
                    }
                });
                if (parentSerials.length > 0) {
                    Integer[] arr$ = parentSerials;
                    int len$ = arr$.length;
                    for (int i$ = 0; i$ < len$; ++i$) {
                        int parentSerial = arr$[i$];
                        String callerName = this.methodName(parentSerial);
                        InvocationSet invs = data2.rootInvocationsFromParent(parentSerial);
                        out.print("                 ");
                        GraphProfilePrinter.pad(out, 10, GraphProfilePrinter.nanoString(invs.totalTime()));
                        out.print("  ");
                        GraphProfilePrinter.pad(out, 10, GraphProfilePrinter.nanoString(invs.selfTime()));
                        out.print("  ");
                        GraphProfilePrinter.pad(out, 10, GraphProfilePrinter.nanoString(invs.childTime()));
                        out.print("  ");
                        GraphProfilePrinter.pad(out, 20, Integer.toString(data2.invocationsFromParent(parentSerial).totalCalls()) + "/" + Integer.toString(data2.totalCalls()));
                        out.print("  ");
                        out.print(callerName);
                        out.println("");
                    }
                }
            }
            String displayName = this.methodName(serial);
            if (topInvocation.getDuration() == 0L) {
                out.print("   100%    100%  ");
            } else {
                out.print("  ");
                GraphProfilePrinter.pad(out, 4, Long.toString(data2.totalTime() * 100L / topInvocation.getDuration()));
                out.print("%   ");
                GraphProfilePrinter.pad(out, 4, Long.toString(data2.selfTime() * 100L / topInvocation.getDuration()));
                out.print("%  ");
            }
            GraphProfilePrinter.pad(out, 10, GraphProfilePrinter.nanoString(data2.totalTime()));
            out.print("  ");
            GraphProfilePrinter.pad(out, 10, GraphProfilePrinter.nanoString(data2.selfTime()));
            out.print("  ");
            GraphProfilePrinter.pad(out, 10, GraphProfilePrinter.nanoString(data2.childTime()));
            out.print("  ");
            GraphProfilePrinter.pad(out, 20, Integer.toString(data2.totalCalls()));
            out.print("  ");
            out.print(displayName);
            out.println("");
            int[] childSerialsInts = data2.children();
            Integer[] childSerials = new Integer[childSerialsInts.length];
            for (int i3 = 0; i3 < childSerialsInts.length; ++i3) {
                childSerials[i3] = childSerialsInts[i3];
            }
            Arrays.sort(childSerials, new Comparator<Integer>(){

                @Override
                public int compare(Integer child1, Integer child2) {
                    long time2;
                    long time1 = data2.rootInvocationsOfChild(child1).totalTime();
                    return time1 == (time2 = data2.rootInvocationsOfChild(child2).totalTime()) ? 0 : (time1 < time2 ? 1 : -1);
                }
            });
            if (childSerials.length <= 0) continue;
            Integer[] arr$ = childSerials;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                int childSerial = arr$[i$];
                if (this.isThisProfilerInvocation(childSerial)) continue;
                String callerName = this.methodName(childSerial);
                InvocationSet invs = data2.rootInvocationsOfChild(childSerial);
                out.print("                 ");
                GraphProfilePrinter.pad(out, 10, GraphProfilePrinter.nanoString(invs.totalTime()));
                out.print("  ");
                GraphProfilePrinter.pad(out, 10, GraphProfilePrinter.nanoString(invs.selfTime()));
                out.print("  ");
                GraphProfilePrinter.pad(out, 10, GraphProfilePrinter.nanoString(invs.childTime()));
                out.print("  ");
                GraphProfilePrinter.pad(out, 20, Integer.toString(data2.invocationsOfChild(childSerial).totalCalls()) + "/" + Integer.toString(methods2.get(childSerial).totalCalls()));
                out.print("  ");
                out.print(callerName);
                out.println("");
            }
        }
    }
}

