/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.instructions;

import java.util.Map;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.ir.IRVisitor;
import org.jruby.ir.Operation;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.instructions.ResultInstr;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.operands.UndefinedValue;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.transformations.inlining.InlinerInfo;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Block;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.opto.Invalidator;

public class LexicalSearchConstInstr
extends Instr
implements ResultInstr {
    Operand definingScope;
    String constName;
    private Variable result;
    private volatile transient Object cachedConstant = null;
    private Object generation = -1;
    private Invalidator invalidator;

    public LexicalSearchConstInstr(Variable result2, Operand definingScope, String constName) {
        super(Operation.LEXICAL_SEARCH_CONST);
        assert (result2 != null) : "LexicalSearchConstInstr result is null";
        this.definingScope = definingScope;
        this.constName = constName;
        this.result = result2;
    }

    @Override
    public Operand[] getOperands() {
        return new Operand[]{this.definingScope};
    }

    @Override
    public void simplifyOperands(Map<Operand, Operand> valueMap, boolean force) {
        this.definingScope = this.definingScope.getSimplifiedOperand(valueMap, force);
    }

    @Override
    public Variable getResult() {
        return this.result;
    }

    @Override
    public void updateResult(Variable v) {
        this.result = v;
    }

    @Override
    public Instr cloneForInlining(InlinerInfo ii) {
        return new LexicalSearchConstInstr(ii.getRenamedVariable(this.result), this.definingScope.cloneForInlining(ii), this.constName);
    }

    @Override
    public String toString() {
        return super.toString() + "(" + this.definingScope + ", " + this.constName + ")";
    }

    private Object cache(ThreadContext context, DynamicScope currDynScope, IRubyObject self2, Object[] temp, Ruby runtime, Object constant) {
        StaticScope staticScope = (StaticScope)this.definingScope.retrieve(context, self2, currDynScope, temp);
        RubyClass object = runtime.getObject();
        Object object2 = constant = staticScope == null ? object.getConstant(this.constName) : staticScope.getConstantInner(this.constName);
        if (constant == null) {
            constant = UndefinedValue.UNDEFINED;
        } else {
            this.generation = this.invalidator(runtime).getData();
            this.cachedConstant = constant;
        }
        return constant;
    }

    private boolean isCached(Ruby runtime, Object value2) {
        return value2 != null && this.generation == this.invalidator(runtime).getData();
    }

    @Override
    public Object interpret(ThreadContext context, DynamicScope currDynScope, IRubyObject self2, Object[] temp, Block block) {
        Ruby runtime = context.runtime;
        Object constant = this.cachedConstant;
        if (!this.isCached(runtime, constant)) {
            constant = this.cache(context, currDynScope, self2, temp, runtime, constant);
        }
        return constant;
    }

    @Override
    public void visit(IRVisitor visitor) {
        visitor.LexicalSearchConstInstr(this);
    }

    private Invalidator invalidator(Ruby runtime) {
        if (this.invalidator == null) {
            this.invalidator = runtime.getConstantInvalidator(this.constName);
        }
        return this.invalidator;
    }
}

