/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.instructions;

import java.util.Map;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyObject;
import org.jruby.RubySymbol;
import org.jruby.internal.runtime.methods.InterpretedIRMethod;
import org.jruby.ir.IRMethod;
import org.jruby.ir.IRVisitor;
import org.jruby.ir.Operation;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.transformations.inlining.InlinerInfo;
import org.jruby.runtime.Block;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

public class DefineClassMethodInstr
extends Instr {
    private Operand container;
    private final IRMethod method;

    public DefineClassMethodInstr(Operand container, IRMethod method2) {
        super(Operation.DEF_CLASS_METH);
        this.container = container;
        this.method = method2;
    }

    @Override
    public String toString() {
        return (Object)((Object)this.getOperation()) + "(" + this.container + ", " + this.method.getName() + ", " + this.method.getFileName() + ")";
    }

    public IRMethod getMethod() {
        return this.method;
    }

    @Override
    public Instr cloneForInlining(InlinerInfo ii) {
        return new DefineClassMethodInstr(this.container.cloneForInlining(ii), this.method);
    }

    @Override
    public Object interpret(ThreadContext context, DynamicScope currDynScope, IRubyObject self2, Object[] temp, Block block) {
        String name2 = this.method.getName();
        Ruby runtime = context.runtime;
        RubyObject obj = (RubyObject)this.container.retrieve(context, self2, currDynScope, temp);
        if (obj instanceof RubyFixnum || obj instanceof RubySymbol) {
            throw runtime.newTypeError("can't define singleton method \"" + name2 + "\" for " + obj.getMetaClass().getBaseName());
        }
        if (obj.isFrozen()) {
            throw runtime.newFrozenError("object");
        }
        RubyClass rubyClass = obj.getSingletonClass();
        rubyClass.addMethod(name2, new InterpretedIRMethod(this.method, Visibility.PUBLIC, rubyClass));
        obj.callMethod(context, "singleton_method_added", (IRubyObject)runtime.fastNewSymbol(name2));
        return null;
    }

    @Override
    public Operand[] getOperands() {
        return new Operand[]{this.container};
    }

    @Override
    public void simplifyOperands(Map<Operand, Operand> valueMap, boolean force) {
        this.container = this.container.getSimplifiedOperand(valueMap, force);
    }

    @Override
    public void visit(IRVisitor visitor) {
        visitor.DefineClassMethodInstr(this);
    }
}

