/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util.collections;

import java.util.HashSet;
import java.util.Set;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBoolean;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class StringArraySet
extends RubyArray {
    private final Set<String> set = new HashSet<String>();

    public StringArraySet(Ruby runtime) {
        super(runtime, 4);
    }

    @Override
    public synchronized RubyArray append(IRubyObject item) {
        String string2 = this.getStringFromItem(item);
        RubyArray result2 = super.append(item);
        this.set.add(string2);
        return result2;
    }

    @Override
    public synchronized void clear() {
        super.clear();
        this.set.clear();
    }

    @Override
    public synchronized IRubyObject delete(ThreadContext context, IRubyObject item, Block block) {
        String string2 = this.getStringFromItem(item);
        IRubyObject result2 = super.delete(context, item, block);
        this.set.remove(string2);
        return result2;
    }

    @Override
    public synchronized IRubyObject delete_if(ThreadContext context, Block block) {
        IRubyObject result2 = super.delete_if(context, block);
        this.rehash();
        return result2;
    }

    @Override
    public synchronized RubyBoolean include_p(ThreadContext context, IRubyObject item) {
        return context.runtime.newBoolean(this.set.contains(this.getStringFromItem(item)));
    }

    @Override
    public synchronized IRubyObject replace(IRubyObject orig) {
        IRubyObject result2 = super.replace(orig);
        this.rehash();
        return result2;
    }

    @Override
    public synchronized IRubyObject unshift(IRubyObject item) {
        String string2 = this.getStringFromItem(item);
        IRubyObject result2 = super.unshift(item);
        this.set.add(string2);
        return result2;
    }

    @Override
    public synchronized IRubyObject unshift(IRubyObject[] items) {
        IRubyObject result2 = super.unshift(items);
        this.putAll(this.toJavaArray());
        return result2;
    }

    @Override
    public synchronized IRubyObject aset(IRubyObject arg0, IRubyObject arg1) {
        IRubyObject result2 = super.aset(arg0, arg1);
        this.rehash();
        return result2;
    }

    @Override
    public synchronized IRubyObject aset(IRubyObject arg0, IRubyObject arg1, IRubyObject arg2) {
        IRubyObject result2 = super.aset(arg0, arg1, arg2);
        this.rehash();
        return result2;
    }

    @Override
    public synchronized IRubyObject aset19(IRubyObject arg0, IRubyObject arg1) {
        IRubyObject result2 = super.aset19(arg0, arg1);
        this.rehash();
        return result2;
    }

    @Override
    public synchronized RubyArray collectBang(ThreadContext context, Block block) {
        RubyArray result2 = super.collectBang(context, block);
        this.rehash();
        return result2;
    }

    @Override
    public synchronized IRubyObject collect_bang(ThreadContext context, Block block) {
        IRubyObject result2 = super.collect_bang(context, block);
        this.rehash();
        return result2;
    }

    @Override
    public synchronized IRubyObject compact() {
        IRubyObject result2 = super.compact();
        this.rehash();
        return result2;
    }

    @Override
    public synchronized IRubyObject drop(ThreadContext context, IRubyObject n) {
        IRubyObject result2 = super.drop(context, n);
        this.rehash();
        return result2;
    }

    @Override
    public synchronized IRubyObject drop_while(ThreadContext context, Block block) {
        IRubyObject result2 = super.drop_while(context, block);
        this.rehash();
        return result2;
    }

    @Override
    public synchronized IRubyObject flatten_bang(ThreadContext context) {
        IRubyObject result2 = super.flatten_bang(context);
        this.rehash();
        return result2;
    }

    @Override
    public synchronized IRubyObject flatten_bang(ThreadContext context, IRubyObject arg2) {
        IRubyObject result2 = super.flatten_bang(context, arg2);
        this.rehash();
        return result2;
    }

    @Override
    public synchronized IRubyObject flatten_bang19(ThreadContext context) {
        IRubyObject result2 = super.flatten_bang19(context);
        this.rehash();
        return result2;
    }

    @Override
    public synchronized IRubyObject flatten_bang19(ThreadContext context, IRubyObject arg2) {
        IRubyObject result2 = super.flatten_bang19(context, arg2);
        this.rehash();
        return result2;
    }

    @Override
    public synchronized IRubyObject insert() {
        IRubyObject result2 = super.insert();
        this.rehash();
        return result2;
    }

    @Override
    public synchronized IRubyObject insert(IRubyObject arg2) {
        IRubyObject result2 = super.insert(arg2);
        this.rehash();
        return result2;
    }

    @Override
    public synchronized IRubyObject insert(IRubyObject arg1, IRubyObject arg2) {
        IRubyObject result2 = super.insert(arg1, arg2);
        this.rehash();
        return result2;
    }

    @Override
    public synchronized IRubyObject insert(IRubyObject[] args2) {
        IRubyObject result2 = super.insert(args2);
        this.rehash();
        return result2;
    }

    @Override
    public synchronized IRubyObject insert19(IRubyObject arg2) {
        IRubyObject result2 = super.insert19(arg2);
        this.rehash();
        return result2;
    }

    @Override
    public synchronized IRubyObject insert19(IRubyObject arg1, IRubyObject arg2) {
        IRubyObject result2 = super.insert19(arg1, arg2);
        this.rehash();
        return result2;
    }

    @Override
    public synchronized IRubyObject insert19(IRubyObject[] args2) {
        IRubyObject result2 = super.insert19(args2);
        this.rehash();
        return result2;
    }

    @Override
    public synchronized IRubyObject map_bang(ThreadContext context, Block block) {
        IRubyObject result2 = super.map_bang(context, block);
        this.rehash();
        return result2;
    }

    @Override
    public synchronized IRubyObject pop(ThreadContext context) {
        IRubyObject result2 = super.pop(context);
        this.rehash();
        return result2;
    }

    @Override
    public synchronized IRubyObject pop(ThreadContext context, IRubyObject num) {
        IRubyObject result2 = super.pop(context, num);
        this.rehash();
        return result2;
    }

    @Override
    public synchronized RubyArray push_m(IRubyObject[] items) {
        RubyArray result2 = super.push_m(items);
        this.rehash();
        return result2;
    }

    @Override
    public synchronized RubyArray push_m19(IRubyObject[] items) {
        RubyArray result2 = super.push_m19(items);
        this.rehash();
        return result2;
    }

    @Override
    public synchronized IRubyObject rejectBang(ThreadContext context, Block block) {
        IRubyObject result2 = super.rejectBang(context, block);
        this.rehash();
        return result2;
    }

    @Override
    public synchronized IRubyObject reject_bang(ThreadContext context, Block block) {
        IRubyObject result2 = super.reject_bang(context, block);
        this.rehash();
        return result2;
    }

    @Override
    public synchronized IRubyObject select_bang(ThreadContext context, Block block) {
        IRubyObject result2 = super.select_bang(context, block);
        this.rehash();
        return result2;
    }

    @Override
    public synchronized IRubyObject shift(ThreadContext context) {
        IRubyObject result2 = super.shift(context);
        this.rehash();
        return result2;
    }

    @Override
    public synchronized IRubyObject shift(ThreadContext context, IRubyObject num) {
        IRubyObject result2 = super.shift(context, num);
        this.rehash();
        return result2;
    }

    @Override
    public synchronized IRubyObject slice_bang(IRubyObject arg0) {
        IRubyObject result2 = super.slice_bang(arg0);
        this.rehash();
        return result2;
    }

    @Override
    public synchronized IRubyObject slice_bang(IRubyObject arg0, IRubyObject arg1) {
        IRubyObject result2 = super.slice_bang(arg0, arg1);
        this.rehash();
        return result2;
    }

    @Override
    public synchronized IRubyObject unshift() {
        IRubyObject result2 = super.unshift();
        this.rehash();
        return result2;
    }

    @Override
    public synchronized IRubyObject unshift19() {
        IRubyObject result2 = super.unshift19();
        this.rehash();
        return result2;
    }

    @Override
    public synchronized IRubyObject unshift19(IRubyObject item) {
        IRubyObject result2 = super.unshift19(item);
        this.rehash();
        return result2;
    }

    public synchronized boolean containsString(String element) {
        return this.set.contains(element);
    }

    private String getStringFromItem(IRubyObject item) {
        return item.convertToString().asJavaString();
    }

    private void rehash() {
        this.set.clear();
        this.putAll(this.toJavaArray());
    }

    private void putAll(IRubyObject[] items) {
        for (IRubyObject item : items) {
            String string2 = this.getStringFromItem(item);
            this.set.add(string2);
        }
    }
}

