/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.instructions;

import org.jruby.ir.IRVisitor;
import org.jruby.ir.Operation;
import org.jruby.ir.instructions.CopyInstr;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.instructions.OptArgMultipleAsgnInstr;
import org.jruby.ir.instructions.ReceiveArgBase;
import org.jruby.ir.operands.UndefinedValue;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.transformations.inlining.InlinerInfo;
import org.jruby.runtime.builtin.IRubyObject;

public class ReceiveOptArgInstr
extends ReceiveArgBase {
    public final int argOffset;
    public final int numUsedArgs;

    public ReceiveOptArgInstr(Variable result2, int numUsedArgs, int argOffset, int optArgIndex) {
        super(Operation.RECV_OPT_ARG, result2, optArgIndex);
        this.argOffset = argOffset;
        this.numUsedArgs = numUsedArgs;
    }

    @Override
    public String toString() {
        return (this.isDead() ? "[DEAD]" : "") + (this.hasUnusedResult() ? "[DEAD-RESULT]" : "") + this.getResult() + " = " + (Object)((Object)this.getOperation()) + "(" + this.numUsedArgs + "," + this.argOffset + "," + this.argIndex + ")";
    }

    @Override
    public Instr cloneForInlining(InlinerInfo ii) {
        int optArgIndex = this.argIndex;
        int minReqdArgs = optArgIndex + this.numUsedArgs;
        if (ii.canMapArgsStatically()) {
            int n = ii.getArgsCount();
            return new CopyInstr(ii.getRenamedVariable(this.result), minReqdArgs < n ? ii.getArg(this.argOffset + optArgIndex) : UndefinedValue.UNDEFINED);
        }
        return new OptArgMultipleAsgnInstr(ii.getRenamedVariable(this.result), ii.getArgs(), this.argOffset + optArgIndex, minReqdArgs);
    }

    @Override
    public Instr cloneForBlockCloning(InlinerInfo ii) {
        int optArgIndex = this.argIndex;
        return new ReceiveOptArgInstr(ii.getRenamedVariable(this.result), this.numUsedArgs, this.argOffset, optArgIndex);
    }

    public Object receiveOptArg(IRubyObject[] args2, int kwArgHashCount) {
        int optArgIndex = this.argIndex;
        return optArgIndex + this.numUsedArgs + kwArgHashCount < args2.length ? args2[this.argOffset + optArgIndex] : UndefinedValue.UNDEFINED;
    }

    @Override
    public void visit(IRVisitor visitor) {
        visitor.ReceiveOptArgInstr(this);
    }
}

