/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.internal.runtime.methods;

import java.io.ByteArrayOutputStream;
import org.jruby.RubyModule;
import org.jruby.compiler.Compilable;
import org.jruby.internal.runtime.AbstractIRMethod;
import org.jruby.internal.runtime.SplitSuperState;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.internal.runtime.methods.ExitableReturn;
import org.jruby.internal.runtime.methods.MethodSplitState;
import org.jruby.ir.IRMethod;
import org.jruby.ir.IRScope;
import org.jruby.ir.interpreter.ExitableInterpreterContext;
import org.jruby.ir.interpreter.InterpreterContext;
import org.jruby.ir.persistence.IRDumper;
import org.jruby.ir.runtime.IRRuntimeHelpers;
import org.jruby.runtime.Block;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.log.Logger;
import org.jruby.util.log.LoggerFactory;

public class MixedModeIRMethod
extends AbstractIRMethod
implements Compilable<DynamicMethod> {
    private static final Logger LOG = LoggerFactory.getLogger(MixedModeIRMethod.class);
    private boolean displayedCFG = false;
    private volatile DynamicMethod actualMethod;

    public MixedModeIRMethod(IRScope method2, Visibility visibility, RubyModule implementationClass) {
        super(method2, visibility, implementationClass);
        if (!implementationClass.getRuntime().getInstanceConfig().isJitEnabled()) {
            this.setCallCount(-1);
        }
        method2.compilable = this;
    }

    public DynamicMethod getActualMethod() {
        return this.actualMethod;
    }

    protected void post(InterpreterContext ic, ThreadContext context) {
        context.popFrame();
        if (ic.popDynScope()) {
            context.popScope();
        }
    }

    protected void pre(InterpreterContext ic, ThreadContext context, IRubyObject self2, String name2, Block block, RubyModule implClass) {
        context.preMethodFrameOnly(implClass, name2, self2, block);
        if (ic.pushNewDynScope()) {
            context.pushScope(DynamicScope.newDynamicScope(ic.getStaticScope()));
        }
    }

    protected void preSplit(InterpreterContext ic, ThreadContext context, IRubyObject self2, String name2, Block block, RubyModule implClass, DynamicScope scope) {
        context.preMethodFrameOnly(implClass, name2, self2, block);
        if (ic.pushNewDynScope()) {
            context.pushScope(scope);
        }
    }

    @Override
    protected void printMethodIR() {
        ByteArrayOutputStream baos = IRDumper.printIR(this.getIRScope(), false);
        LOG.info("Printing simple IR for " + this.getIRScope().getId() + ":\n" + new String(baos.toByteArray()), new Object[0]);
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, IRubyObject[] args2, Block block) {
        DynamicMethod jittedMethod;
        if (IRRuntimeHelpers.isDebug()) {
            this.doDebug();
        }
        if (this.callCount >= 0) {
            MixedModeIRMethod.tryJit(context, this);
        }
        if ((jittedMethod = this.actualMethod) != null) {
            return jittedMethod.call(context, self2, clazz, name2, args2, block);
        }
        return this.INTERPRET_METHOD(context, this.ensureInstrsReady(), clazz, self2, name2, args2, block);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IRubyObject INTERPRET_METHOD(ThreadContext context, InterpreterContext ic, RubyModule implClass, IRubyObject self2, String name2, IRubyObject[] args2, Block block) {
        try {
            ThreadContext.pushBacktrace(context, name2, ic.getFileName(), ic.getLine());
            if (ic.hasExplicitCallProtocol()) {
                IRubyObject iRubyObject = ic.getEngine().interpret(context, null, self2, ic, implClass, name2, args2, block);
                return iRubyObject;
            }
            try {
                this.pre(ic, context, self2, name2, block, implClass);
                IRubyObject iRubyObject = ic.getEngine().interpret(context, null, self2, ic, implClass, name2, args2, block);
                this.post(ic, context);
                return iRubyObject;
            }
            catch (Throwable throwable) {
                this.post(ic, context);
                throw throwable;
            }
        }
        finally {
            ThreadContext.popBacktrace(context);
        }
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, Block block) {
        DynamicMethod jittedMethod;
        if (IRRuntimeHelpers.isDebug()) {
            this.doDebug();
        }
        if (this.callCount >= 0) {
            MixedModeIRMethod.tryJit(context, this);
        }
        if ((jittedMethod = this.actualMethod) != null) {
            return jittedMethod.call(context, self2, clazz, name2, block);
        }
        return this.INTERPRET_METHOD(context, this.ensureInstrsReady(), clazz, self2, name2, block);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IRubyObject INTERPRET_METHOD(ThreadContext context, InterpreterContext ic, RubyModule implClass, IRubyObject self2, String name2, Block block) {
        try {
            ThreadContext.pushBacktrace(context, name2, ic.getFileName(), ic.getLine());
            if (ic.hasExplicitCallProtocol()) {
                IRubyObject iRubyObject = ic.getEngine().interpret(context, null, self2, ic, implClass, name2, block);
                return iRubyObject;
            }
            try {
                this.pre(ic, context, self2, name2, block, implClass);
                IRubyObject iRubyObject = ic.getEngine().interpret(context, null, self2, ic, implClass, name2, block);
                this.post(ic, context);
                return iRubyObject;
            }
            catch (Throwable throwable) {
                this.post(ic, context);
                throw throwable;
            }
        }
        finally {
            ThreadContext.popBacktrace(context);
        }
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, IRubyObject arg0, Block block) {
        DynamicMethod jittedMethod;
        if (IRRuntimeHelpers.isDebug()) {
            this.doDebug();
        }
        if (this.callCount >= 0) {
            MixedModeIRMethod.tryJit(context, this);
        }
        if ((jittedMethod = this.actualMethod) != null) {
            return jittedMethod.call(context, self2, clazz, name2, arg0, block);
        }
        return this.INTERPRET_METHOD(context, this.ensureInstrsReady(), clazz, self2, name2, arg0, block);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IRubyObject INTERPRET_METHOD(ThreadContext context, InterpreterContext ic, RubyModule implClass, IRubyObject self2, String name2, IRubyObject arg1, Block block) {
        try {
            ThreadContext.pushBacktrace(context, name2, ic.getFileName(), ic.getLine());
            if (ic.hasExplicitCallProtocol()) {
                IRubyObject iRubyObject = ic.getEngine().interpret(context, null, self2, ic, implClass, name2, arg1, block);
                return iRubyObject;
            }
            try {
                this.pre(ic, context, self2, name2, block, implClass);
                IRubyObject iRubyObject = ic.getEngine().interpret(context, null, self2, ic, implClass, name2, arg1, block);
                this.post(ic, context);
                return iRubyObject;
            }
            catch (Throwable throwable) {
                this.post(ic, context);
                throw throwable;
            }
        }
        finally {
            ThreadContext.popBacktrace(context);
        }
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, IRubyObject arg0, IRubyObject arg1, Block block) {
        DynamicMethod jittedMethod;
        if (IRRuntimeHelpers.isDebug()) {
            this.doDebug();
        }
        if (this.callCount >= 0) {
            MixedModeIRMethod.tryJit(context, this);
        }
        if ((jittedMethod = this.actualMethod) != null) {
            return jittedMethod.call(context, self2, clazz, name2, arg0, arg1, block);
        }
        return this.INTERPRET_METHOD(context, this.ensureInstrsReady(), clazz, self2, name2, arg0, arg1, block);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IRubyObject INTERPRET_METHOD(ThreadContext context, InterpreterContext ic, RubyModule implClass, IRubyObject self2, String name2, IRubyObject arg1, IRubyObject arg2, Block block) {
        try {
            ThreadContext.pushBacktrace(context, name2, ic.getFileName(), ic.getLine());
            if (ic.hasExplicitCallProtocol()) {
                IRubyObject iRubyObject = ic.getEngine().interpret(context, null, self2, ic, implClass, name2, arg1, arg2, block);
                return iRubyObject;
            }
            try {
                this.pre(ic, context, self2, name2, block, implClass);
                IRubyObject iRubyObject = ic.getEngine().interpret(context, null, self2, ic, implClass, name2, arg1, arg2, block);
                this.post(ic, context);
                return iRubyObject;
            }
            catch (Throwable throwable) {
                this.post(ic, context);
                throw throwable;
            }
        }
        finally {
            ThreadContext.popBacktrace(context);
        }
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, Block block) {
        DynamicMethod jittedMethod;
        if (IRRuntimeHelpers.isDebug()) {
            this.doDebug();
        }
        if (this.callCount >= 0) {
            MixedModeIRMethod.tryJit(context, this);
        }
        if ((jittedMethod = this.actualMethod) != null) {
            return jittedMethod.call(context, self2, clazz, name2, arg0, arg1, arg2, block);
        }
        return this.INTERPRET_METHOD(context, this.ensureInstrsReady(), clazz, self2, name2, arg0, arg1, arg2, block);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IRubyObject INTERPRET_METHOD(ThreadContext context, InterpreterContext ic, RubyModule implClass, IRubyObject self2, String name2, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3, Block block) {
        try {
            ThreadContext.pushBacktrace(context, name2, ic.getFileName(), ic.getLine());
            if (ic.hasExplicitCallProtocol()) {
                IRubyObject iRubyObject = ic.getEngine().interpret(context, null, self2, ic, implClass, name2, arg1, arg2, arg3, block);
                return iRubyObject;
            }
            try {
                this.pre(ic, context, self2, name2, block, implClass);
                IRubyObject iRubyObject = ic.getEngine().interpret(context, null, self2, ic, implClass, name2, arg1, arg2, arg3, block);
                this.post(ic, context);
                return iRubyObject;
            }
            catch (Throwable throwable) {
                this.post(ic, context);
                throw throwable;
            }
        }
        finally {
            ThreadContext.popBacktrace(context);
        }
    }

    @Override
    public SplitSuperState<MethodSplitState> startSplitSuperCall(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, IRubyObject[] args2, Block block) {
        ExitableInterpreterContext ic = ((IRMethod)this.getIRScope()).builtInterpreterContextForJavaConstructor();
        if (ic == null) {
            return null;
        }
        MethodSplitState state2 = new MethodSplitState(context, ic, clazz, self2, name2);
        ExitableReturn result2 = this.INTERPRET_METHOD(state2, args2, block);
        return new SplitSuperState<MethodSplitState>(result2, state2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ExitableReturn INTERPRET_METHOD(MethodSplitState state2, IRubyObject[] args2, Block block) {
        try {
            ThreadContext.pushBacktrace(state2.context, state2.name, state2.eic.getFileName(), state2.eic.getLine());
            try {
                this.preSplit(state2.eic, state2.context, state2.self, state2.name, block, state2.implClass, state2.scope);
                ExitableReturn exitableReturn = state2.eic.getEngine().interpret(state2.context, null, state2.self, state2.eic, state2.state, state2.implClass, state2.name, args2, block);
                this.post(state2.eic, state2.context);
                return exitableReturn;
            }
            catch (Throwable throwable) {
                this.post(state2.eic, state2.context);
                throw throwable;
            }
        }
        finally {
            ThreadContext.popBacktrace(state2.context);
        }
    }

    @Override
    public void finishSplitCall(SplitSuperState state2) {
        if (IRRuntimeHelpers.isDebug()) {
            this.doDebug();
        }
        this.INTERPRET_METHOD((MethodSplitState)state2.state, IRubyObject.NULL_ARRAY, Block.NULL_BLOCK);
    }

    private void doDebug() {
        this.ensureInstrsReady();
        LOG.info("Executing '" + this.getIRScope().getId() + "'", new Object[0]);
        if (!this.displayedCFG) {
            LOG.info(this.getIRScope().debugOutput(), new Object[0]);
            this.displayedCFG = true;
        }
    }

    @Override
    public void completeBuild(DynamicMethod newMethod) {
        this.setCallCount(-1);
        newMethod.serialNumber = this.serialNumber;
        this.actualMethod = newMethod;
        this.getImplementationClass().invalidateCacheDescendants();
    }

    @Override
    public DynamicMethod dup() {
        MixedModeIRMethod x = (MixedModeIRMethod)super.dup();
        x.callCount = this.callCount;
        x.actualMethod = this.actualMethod;
        return x;
    }
}

