/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime.backtrace;

import com.headius.backport9.stack.StackWalker;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.jruby.Ruby;
import org.jruby.runtime.backtrace.BacktraceElement;
import org.jruby.runtime.backtrace.FrameType;
import org.jruby.runtime.backtrace.RubyStackTraceElement;
import org.jruby.util.JavaNameMangler;

public class BacktraceData
implements Serializable {
    public static final StackTraceElement[] EMPTY_STACK_TRACE = new StackTraceElement[0];
    private RubyStackTraceElement[] backtraceElements;
    private final Stream<StackWalker.StackFrame> stackStream;
    private final Stream<BacktraceElement> rubyTrace;
    private final boolean fullTrace;
    private final boolean rawTrace;
    private final boolean maskNative;
    private final boolean includeNonFiltered;
    public static final BacktraceData EMPTY = new BacktraceData(Stream.empty(), Stream.empty(), false, false, false, false);

    public BacktraceData(Stream<StackWalker.StackFrame> stackStream, Stream<BacktraceElement> rubyTrace, boolean fullTrace, boolean rawTrace, boolean maskNative, boolean includeNonFiltered) {
        this.stackStream = stackStream;
        this.rubyTrace = rubyTrace;
        this.fullTrace = fullTrace;
        this.rawTrace = rawTrace;
        this.maskNative = maskNative;
        this.includeNonFiltered = includeNonFiltered;
    }

    public final RubyStackTraceElement[] getBacktrace(Ruby runtime2) {
        if (this.backtraceElements == null) {
            this.backtraceElements = this.constructBacktrace(runtime2.getBoundMethods());
        }
        return this.backtraceElements;
    }

    public final RubyStackTraceElement[] getPartialBacktrace(Ruby runtime2, int level2) {
        if (this.backtraceElements == null) {
            this.backtraceElements = this.constructBacktrace(runtime2.getBoundMethods(), level2);
        }
        return this.backtraceElements;
    }

    public RubyStackTraceElement[] getBacktraceWithoutRuby() {
        return this.constructBacktrace(Collections.EMPTY_MAP);
    }

    private RubyStackTraceElement[] constructBacktrace(Map<String, Map<String, String>> boundMethods) {
        return this.constructBacktrace(boundMethods, Integer.MAX_VALUE);
    }

    private RubyStackTraceElement[] constructBacktrace(Map<String, Map<String, String>> boundMethods, int count2) {
        ArrayList<RubyStackTraceElement> trace2 = new ArrayList<RubyStackTraceElement>();
        boolean dupFrame = false;
        String dupFrameName = null;
        Iterator stackIter = this.stackStream.iterator();
        Iterator backIter = this.rubyTrace.iterator();
        StackWalker.StackFrame previousElement = null;
        while (stackIter.hasNext() && trace2.size() < count2) {
            FrameType frameType;
            FrameType type2;
            String decodedName;
            List<String> mangledTuple;
            StackWalker.StackFrame element = (StackWalker.StackFrame)stackIter.next();
            int line = element.getLineNumber();
            String filename2 = element.getFileName();
            String methodName = element.getMethodName();
            String className = element.getClassName();
            if (!this.rawTrace && filename2 != null && !filename2.endsWith(".java") && (mangledTuple = JavaNameMangler.decodeMethodTuple(methodName)) != null && (decodedName = JavaNameMangler.decodeMethodName(type2 = JavaNameMangler.decodeFrameTypeFromMangledName(mangledTuple.get(1)), mangledTuple)) != null) {
                if (previousElement != null && element.getMethodName().equals(previousElement.getMethodName() + "$__VARARGS__")) {
                    previousElement = null;
                    continue;
                }
                RubyStackTraceElement rubyElement = new RubyStackTraceElement(className, decodedName, filename2, line, false, type2);
                if (this.maskNative && dupFrame) {
                    dupFrame = false;
                    trace2.add(new RubyStackTraceElement(className, dupFrameName, filename2, line, false, type2));
                }
                trace2.add(rubyElement);
                previousElement = element;
                continue;
            }
            String rubyName = methodName;
            if (this.fullTrace || (rubyName = BacktraceData.getBoundMethodName(boundMethods, className, methodName)) != null) {
                filename2 = BacktraceData.packagedFilenameFromElement(filename2, className);
                if (this.maskNative) {
                    dupFrame = true;
                    dupFrameName = rubyName;
                    continue;
                }
                trace2.add(new RubyStackTraceElement(className, rubyName, filename2, line, false));
                if (!this.fullTrace) continue;
            }
            if (backIter.hasNext() && (frameType = FrameType.getInterpreterFrame(className, methodName)) != null) {
                String newName;
                BacktraceElement rubyFrame = (BacktraceElement)backIter.next();
                switch (frameType) {
                    case METHOD: {
                        newName = rubyFrame.method;
                        break;
                    }
                    case BLOCK: {
                        newName = rubyFrame.method;
                        break;
                    }
                    case CLASS: {
                        newName = "<class:" + rubyFrame.method + '>';
                        break;
                    }
                    case MODULE: {
                        newName = "<module:" + rubyFrame.method + '>';
                        break;
                    }
                    case METACLASS: {
                        newName = "singleton class";
                        break;
                    }
                    case ROOT: {
                        newName = "<main>";
                        break;
                    }
                    case EVAL: {
                        newName = rubyFrame.method == null || rubyFrame.method.isEmpty() ? "<main>" : rubyFrame.method;
                        break;
                    }
                    default: {
                        newName = rubyFrame.method;
                    }
                }
                RubyStackTraceElement rubyElement = new RubyStackTraceElement("RUBY", newName, rubyFrame.filename, rubyFrame.line + 1, false, frameType);
                if (this.maskNative && dupFrame) {
                    dupFrame = false;
                    trace2.add(new RubyStackTraceElement(rubyElement.getClassName(), dupFrameName, rubyElement.getFileName(), rubyElement.getLineNumber(), rubyElement.isBinding(), rubyElement.getFrameType()));
                }
                trace2.add(rubyElement);
                continue;
            }
            if (!this.includeNonFiltered || BacktraceData.isFilteredClass(className)) continue;
            filename2 = BacktraceData.packagedFilenameFromElement(filename2, className);
            trace2.add(new RubyStackTraceElement(className, methodName, filename2, line, false));
        }
        return trace2.toArray(RubyStackTraceElement.EMPTY_ARRAY);
    }

    public static String getBoundMethodName(Map<String, Map<String, String>> boundMethods, String className, String methodName) {
        Map<String, String> javaToRuby = boundMethods.get(className);
        return javaToRuby == null ? null : javaToRuby.get(methodName);
    }

    private static String packagedFilenameFromElement(String filename2, String className) {
        if (filename2 == null) {
            return className.replace('.', '/');
        }
        int lastDot = className.lastIndexOf(46);
        if (lastDot == -1) {
            return filename2;
        }
        String pkgPath = className.substring(0, lastDot + 1).replace('.', '/');
        if (filename2.indexOf(47) > -1 && filename2.startsWith(pkgPath)) {
            return filename2;
        }
        return pkgPath + filename2;
    }

    private static boolean isFilteredClass(String className) {
        if (className.startsWith("sun.reflect.")) {
            return true;
        }
        String org_jruby_ = "org.jruby.";
        if (className.startsWith("org.jruby.")) {
            String subPackage;
            int dot = className.indexOf(46, "org.jruby.".length());
            if (dot == -1) {
                return false;
            }
            switch (subPackage = className.substring("org.jruby.".length(), dot)) {
                case "anno": {
                    return true;
                }
                case "ast": {
                    return true;
                }
                case "exceptions": {
                    return true;
                }
                case "gen": {
                    return true;
                }
                case "ir": {
                    return true;
                }
                case "internal": {
                    return true;
                }
                case "java": {
                    return true;
                }
                case "parser": {
                    return true;
                }
                case "platform": {
                    return true;
                }
                case "runtime": {
                    return true;
                }
                case "util": {
                    return true;
                }
            }
        }
        return false;
    }
}

