/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.instructions;

import org.jruby.ir.IRVisitor;
import org.jruby.ir.Operation;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.instructions.NoOperandInstr;
import org.jruby.ir.persistence.IRReaderDecoder;
import org.jruby.ir.persistence.IRWriterEncoder;
import org.jruby.ir.transformations.inlining.CloneInfo;

public class ToggleBacktraceInstr
extends NoOperandInstr {
    private final boolean requiresBacktrace;

    public ToggleBacktraceInstr(boolean requiresBacktrace) {
        super(Operation.TOGGLE_BACKTRACE);
        this.requiresBacktrace = requiresBacktrace;
    }

    public boolean requiresBacktrace() {
        return this.requiresBacktrace;
    }

    @Override
    public String[] toStringNonOperandArgs() {
        return new String[]{"" + this.requiresBacktrace};
    }

    @Override
    public void encode(IRWriterEncoder e) {
        super.encode(e);
        e.encode(this.requiresBacktrace);
    }

    public static ToggleBacktraceInstr decode(IRReaderDecoder d) {
        return d.getCurrentScope().getManager().needsBacktrace(d.decodeBoolean());
    }

    @Override
    public void visit(IRVisitor visitor) {
        visitor.ToggleBacktraceInstr(this);
    }

    @Override
    public Instr clone(CloneInfo info) {
        return this;
    }
}

