/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import org.jcodings.Encoding;
import org.jcodings.specific.USASCIIEncoding;
import org.jruby.Ruby;
import org.jruby.RubyModule;
import org.jruby.RubyString;
import org.jruby.runtime.ThreadContext;
import org.jruby.util.ByteList;
import org.jruby.util.ConvertBytes;
import org.jruby.util.RubyStringBuilder;
import org.jruby.util.io.EncodingUtils;

public class Inspector {
    public static final ByteList EMPTY_ARRAY_BL = new ByteList(new byte[]{91, 93}, (Encoding)USASCIIEncoding.INSTANCE, false);
    public static final ByteList RECURSIVE_ARRAY_BL = new ByteList(new byte[]{91, 46, 46, 46, 93}, (Encoding)USASCIIEncoding.INSTANCE, false);
    public static final ByteList EMPTY_HASH_BL = new ByteList(new byte[]{123, 125}, (Encoding)USASCIIEncoding.INSTANCE, false);
    public static final ByteList RECURSIVE_HASH_BL = new ByteList(new byte[]{123, 46, 46, 46, 125}, (Encoding)USASCIIEncoding.INSTANCE, false);
    private static final byte[] COLON_ZERO_X = new byte[]{58, 48, 120};
    public static final byte[] COLON = new byte[]{58};
    public static final byte[] SPACE = new byte[]{32};
    public static final byte[] SLASH = new byte[]{47};
    public static final byte[] COLON_SPACE = new byte[]{58, 32};
    public static final byte[] GT = new byte[]{62};
    public static final byte[] COMMA = new byte[]{44};
    public static final byte[] COMMA_SPACE = new byte[]{44, 32};
    public static final byte[] BEG_BRACKET = new byte[]{91};
    public static final byte[] END_BRACKET = new byte[]{93};
    public static final byte[] END_BRACKET_GT = new byte[]{93, 62};
    public static final byte[] SPACE_HASHROCKET_SPACE = new byte[]{32, 61, 62, 32};
    public static final byte[] SPACE_DOT_DOT_DOT_GT = " ...>".getBytes();
    public static final byte[] EQUALS = "=".getBytes();

    public static RubyString inspectPrefix(ThreadContext context, RubyModule type2, int hash2) {
        Ruby runtime2 = context.runtime;
        RubyString buf = Inspector.inspectPrefixTypeOnly(context, type2);
        EncodingUtils.encStrBufCat(runtime2, buf, COLON_ZERO_X);
        EncodingUtils.encStrBufCat(runtime2, buf, ConvertBytes.longToHexBytes(hash2));
        return buf;
    }

    public static RubyString inspectPrefix(ThreadContext context, RubyModule type2) {
        Ruby runtime2 = context.runtime;
        RubyString buf = Inspector.inspectPrefixTypeOnly(context, type2);
        EncodingUtils.encStrBufCat(runtime2, buf, COLON);
        return buf;
    }

    public static RubyString inspectPrefixTypeOnly(ThreadContext context, RubyModule type2) {
        RubyString name2 = RubyStringBuilder.types(context, type2);
        RubyString buf = RubyString.newStringLight(context.runtime, 2 + name2.length() + 3 + 8 + 1, (Encoding)USASCIIEncoding.INSTANCE);
        RubyString rubyString = buf.cat(35).cat(60);
        rubyString.catWithCodeRange(name2);
        return buf;
    }
}

