/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.IOException;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Arrays;
import jnr.ffi.NativeType;
import jnr.ffi.Platform;
import jnr.ffi.Runtime;
import jnr.ffi.Type;
import org.jcodings.Encoding;
import org.jcodings.specific.ASCIIEncoding;
import org.jruby.FiberScheduler;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBignum;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyEnumerator;
import org.jruby.RubyFile;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyIO;
import org.jruby.RubyInteger;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.anno.JRubyConstant;
import org.jruby.anno.JRubyMethod;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;
import org.jruby.util.io.ChannelFD;
import org.jruby.util.io.OpenFile;

public class RubyIOBuffer
extends RubyObject {
    public static final Runtime FFI_RUNTIME = Runtime.getSystemRuntime();
    @JRubyConstant
    public static final int PAGE_SIZE = 8196;
    @JRubyConstant
    public static final int DEFAULT_SIZE = 8196;
    @JRubyConstant
    public static final int EXTERNAL = 1;
    @JRubyConstant
    public static final int INTERNAL = 2;
    @JRubyConstant
    public static final int MAPPED = 4;
    @JRubyConstant
    public static final int SHARED = 8;
    @JRubyConstant
    public static final int LOCKED = 32;
    @JRubyConstant
    public static final int PRIVATE = 64;
    @JRubyConstant
    public static final int READONLY = 128;
    @JRubyConstant
    public static final int LITTLE_ENDIAN = 4;
    @JRubyConstant
    public static final int BIG_ENDIAN = 8;
    @JRubyConstant
    public static final int HOST_ENDIAN = Platform.getNativePlatform().isBigEndian() ? 8 : 4;
    @JRubyConstant
    public static final int NETWORK_ENDIAN = 8;
    private ByteBuffer base;
    private int size;
    private int flags;
    private IRubyObject source;

    public static RubyClass createIOBufferClass(Ruby runtime2) {
        RubyClass IOBuffer = runtime2.getIO().defineClassUnder("Buffer", runtime2.getObject(), RubyIOBuffer::new);
        IOBuffer.includeModule(runtime2.getComparable());
        IOBuffer.defineAnnotatedMethods(RubyIOBuffer.class);
        IOBuffer.defineAnnotatedConstants(RubyIOBuffer.class);
        RubyClass IO = runtime2.getIO();
        IO.setConstant("READABLE", runtime2.newFixnum(1));
        IO.setConstant("WRITABLE", runtime2.newFixnum(2));
        return IOBuffer;
    }

    public static RubyIOBuffer newBuffer(Ruby runtime2, ByteBuffer base, int size2, int flags2) {
        if (base == null) {
            return RubyIOBuffer.newBuffer(runtime2, size2, flags2);
        }
        return new RubyIOBuffer(runtime2, runtime2.getIOBuffer(), base, size2, flags2);
    }

    public static RubyIOBuffer newBuffer(Ruby runtime2, int size2, int flags2) {
        return new RubyIOBuffer(runtime2, runtime2.getIOBuffer(), RubyIOBuffer.newBufferBase(runtime2, size2, flags2), size2, flags2);
    }

    public static RubyIOBuffer newBuffer(ThreadContext context, RubyString string2, int flags2) {
        ByteList bytes2 = string2.getByteList();
        int size2 = bytes2.realSize();
        return RubyIOBuffer.newBuffer(context.runtime, ByteBuffer.wrap(bytes2.unsafeBytes(), bytes2.begin(), size2), size2, flags2);
    }

    public RubyIOBuffer(Ruby runtime2, RubyClass metaClass) {
        super(runtime2, metaClass);
    }

    public RubyIOBuffer(Ruby runtime2, RubyClass metaClass, ByteBuffer base, int size2, int flags2) {
        super(runtime2, metaClass);
        this.base = base;
        this.size = size2;
        this.flags = flags2;
    }

    @JRubyMethod(name={"for"}, meta=true)
    public static IRubyObject rbFor(ThreadContext context, IRubyObject self2, IRubyObject _string, Block block) {
        int flags2;
        RubyString string2 = _string.convertToString();
        int n = flags2 = string2.isFrozen() ? 128 : 0;
        if (!block.isGiven()) {
            string2 = string2.newFrozen();
            flags2 = 128;
        } else if ((flags2 & 0x80) != 128) {
            string2.modify();
        }
        RubyIOBuffer buffer = RubyIOBuffer.newBuffer(context, string2, flags2);
        if (block.isGiven()) {
            return block.yieldSpecific(context, buffer);
        }
        return buffer;
    }

    @JRubyMethod(meta=true)
    public static IRubyObject string(ThreadContext context, IRubyObject self2, IRubyObject _length, Block block) {
        Ruby runtime2 = context.runtime;
        int size2 = _length.convertToInteger().getIntValue();
        if (size2 < 0) {
            throw runtime2.newArgumentError("negative string size (or size too big)");
        }
        RubyString string2 = RubyString.newString(runtime2, new byte[size2]);
        ByteList bytes2 = string2.getByteList();
        ByteBuffer wrap2 = ByteBuffer.wrap(bytes2.unsafeBytes(), bytes2.begin(), size2);
        RubyIOBuffer buffer = RubyIOBuffer.newBuffer(context.runtime, wrap2, size2, 0);
        block.yieldSpecific(context, buffer);
        return string2;
    }

    @JRubyMethod(name={"map"}, meta=true)
    public static IRubyObject map(ThreadContext context, IRubyObject self2, IRubyObject _file) {
        RubyFile file2 = RubyIOBuffer.checkFile(context, _file);
        int size2 = RubyIOBuffer.getSizeFromFile(context, file2);
        return RubyIOBuffer.map(context, file2, size2, 0, 0);
    }

    private static RubyFile checkFile(ThreadContext context, IRubyObject _file) {
        RubyIO io2 = RubyIO.convertToIO(context, _file);
        if (!(io2 instanceof RubyFile)) {
            throw context.runtime.newTypeError(_file, context.runtime.getFile());
        }
        RubyFile file2 = (RubyFile)io2;
        return file2;
    }

    @JRubyMethod(name={"map"}, meta=true)
    public static IRubyObject map(ThreadContext context, IRubyObject self2, IRubyObject _file, IRubyObject _size) {
        RubyFile file2 = RubyIOBuffer.checkFile(context, _file);
        int size2 = RubyIOBuffer.getSizeForMap(context, file2, _size);
        return RubyIOBuffer.map(context, file2, size2, 0, 0);
    }

    @JRubyMethod(name={"map"}, meta=true)
    public static IRubyObject map(ThreadContext context, IRubyObject self2, IRubyObject _file, IRubyObject _size, IRubyObject _offset) {
        RubyFile file2 = RubyIOBuffer.checkFile(context, _file);
        int size2 = RubyIOBuffer.getSizeForMap(context, file2, _size);
        int offset2 = RubyNumeric.num2int(_offset);
        return RubyIOBuffer.map(context, file2, size2, offset2, 0);
    }

    private static int getSizeForMap(ThreadContext context, RubyFile file2, IRubyObject _size) {
        int size2 = !_size.isNil() ? RubyIOBuffer.extractSize(context, _size) : RubyIOBuffer.getSizeFromFile(context, file2);
        return size2;
    }

    private static int getSizeFromFile(ThreadContext context, RubyFile _file) {
        long file_size = _file.getSize(context);
        if (file_size < 0L) {
            throw context.runtime.newArgumentError("Invalid negative file size!");
        }
        if (file_size > Integer.MAX_VALUE) {
            throw context.runtime.newArgumentError("File larger than address space!");
        }
        int size2 = (int)file_size;
        return size2;
    }

    @JRubyMethod(name={"map"}, required=1, optional=3, meta=true)
    public static IRubyObject map(ThreadContext context, IRubyObject self2, IRubyObject[] args2) {
        switch (args2.length) {
            case 1: {
                return RubyIOBuffer.map(context, self2, args2[0]);
            }
            case 2: {
                return RubyIOBuffer.map(context, self2, args2[0], args2[1]);
            }
            case 3: {
                return RubyIOBuffer.map(context, self2, args2[0], args2[1], args2[2]);
            }
            case 4: {
                return RubyIOBuffer.map(context, self2, args2[0], args2[1], args2[2], args2[3]);
            }
        }
        return context.nil;
    }

    public static IRubyObject map(ThreadContext context, IRubyObject self2, IRubyObject _file, IRubyObject _size, IRubyObject _offset, IRubyObject _flags) {
        RubyFile file2 = RubyIOBuffer.checkFile(context, _file);
        int size2 = RubyIOBuffer.getSizeForMap(context, file2, _size);
        int offset2 = RubyNumeric.num2int(_offset);
        int flags2 = RubyNumeric.num2int(_flags);
        return RubyIOBuffer.map(context, file2, size2, offset2, flags2);
    }

    private static RubyIOBuffer map(ThreadContext context, RubyFile file2, int size2, int offset2, int flags2) {
        RubyIOBuffer buffer = new RubyIOBuffer(context.runtime, context.runtime.getIOBuffer());
        ChannelFD descriptor = file2.getOpenFileChecked().fd();
        RubyIOBuffer.mapFile(context, buffer, descriptor, size2, offset2, flags2);
        return buffer;
    }

    private static void mapFile(ThreadContext context, RubyIOBuffer buffer, ChannelFD descriptor, int size2, int offset2, int flags2) {
        MappedByteBuffer base;
        FileChannel.MapMode protect = FileChannel.MapMode.READ_ONLY;
        boolean access = false;
        if ((flags2 & 0x80) == 128) {
            buffer.flags |= 0x80;
        } else {
            protect = FileChannel.MapMode.READ_WRITE;
        }
        if ((flags2 & 0x40) == 64) {
            buffer.flags |= 0x40;
            protect = FileChannel.MapMode.PRIVATE;
        } else {
            buffer.flags |= 1;
            buffer.flags |= 8;
        }
        if (descriptor.chFile == null) {
            throw context.runtime.newTypeError("Cannot map non-file resource: " + descriptor.ch);
        }
        try {
            base = descriptor.chFile.map(protect, offset2, size2);
        }
        catch (IOException ioe) {
            throw Helpers.newIOErrorFromException(context.runtime, ioe);
        }
        buffer.base = base;
        buffer.size = size2;
        buffer.flags |= 4;
    }

    public static IRubyObject map(ThreadContext context, IRubyObject self2, RubyFile _file, int _size, int _offset, int _flags) {
        return context.nil;
    }

    @Override
    @JRubyMethod(name={"initialize"})
    public IRubyObject initialize(ThreadContext context) {
        return this.initialize(context, 8196);
    }

    @JRubyMethod(name={"initialize"})
    public IRubyObject initialize(ThreadContext context, IRubyObject size2) {
        return this.initialize(context, size2.convertToInteger().getIntValue());
    }

    @JRubyMethod(name={"initialize"})
    public IRubyObject initialize(ThreadContext context, IRubyObject _size, IRubyObject flags2) {
        IRubyObject nil = context.nil;
        int size2 = _size.convertToInteger().getIntValue();
        this.initialize(context, new byte[size2], size2, flags2.convertToInteger().getIntValue(), nil);
        return nil;
    }

    public IRubyObject initialize(ThreadContext context, int size2) {
        IRubyObject nil = context.nil;
        this.initialize(context, new byte[size2], size2, RubyIOBuffer.flagsForSize(size2), nil);
        return nil;
    }

    public void initialize(ThreadContext context, byte[] baseBytes, int size2, int flags2, IRubyObject source2) {
        ByteBuffer base = null;
        if (baseBytes != null) {
            base = ByteBuffer.wrap(baseBytes);
        } else if (size2 != 0) {
            base = RubyIOBuffer.newBufferBase(context.runtime, size2, flags2);
        } else {
            return;
        }
        this.base = base;
        this.size = size2;
        this.flags = flags2;
        this.source = source2.isNil() ? null : source2;
    }

    private static ByteBuffer newBufferBase(Ruby runtime2, int size2, int flags2) {
        ByteBuffer base;
        if ((flags2 & 2) == 2) {
            base = ByteBuffer.allocate(size2);
        } else if ((flags2 & 4) == 4) {
            base = ByteBuffer.allocateDirect(size2);
        } else {
            throw runtime2.newBufferAllocationError("Could not allocate buffer!");
        }
        return base;
    }

    private static int flagsForSize(int size2) {
        if (size2 >= 8196) {
            return 4;
        }
        return 2;
    }

    @JRubyMethod(name={"initialize_copy"})
    public IRubyObject initialize_copy(ThreadContext context, IRubyObject other) {
        RubyIOBuffer otherBuffer = (RubyIOBuffer)other;
        ByteBuffer sourceBase = otherBuffer.getBufferForReading(context);
        int sourceSize = otherBuffer.size;
        this.initialize(context, null, sourceSize, RubyIOBuffer.flagsForSize(this.size), context.nil);
        return this.copy(context, otherBuffer, 0, sourceSize, 0);
    }

    @JRubyMethod(name={"inspect"})
    public IRubyObject inspect(ThreadContext context) {
        RubyString result2 = this.to_s(context);
        if (this.validate() && this.size <= 256) {
            RubyIOBuffer.hexdump(context, result2, 16, this.base, this.size, false);
        }
        return result2;
    }

    private boolean validate() {
        if (this.source != null) {
            return this.validateSlice(this.source, this.base, this.size);
        }
        return true;
    }

    private boolean validateSlice(IRubyObject source2, ByteBuffer base, int size2) {
        ByteBuffer sourceBase = null;
        int sourceSize = 0;
        if (source2 instanceof RubyString) {
            ByteList sourceBytes = ((RubyString)source2).getByteList();
            sourceSize = sourceBytes.getRealSize();
            sourceBase = ByteBuffer.wrap(sourceBytes.getUnsafeBytes(), sourceBytes.begin(), sourceSize);
        } else {
            RubyIOBuffer sourceBuffer = (RubyIOBuffer)source2;
            sourceBase = sourceBuffer.base;
            sourceSize = sourceBuffer.size;
        }
        if (sourceBase == null) {
            return false;
        }
        if (base.hasArray() && sourceBase.hasArray() && base.array() != sourceBase.array()) {
            return false;
        }
        int end2 = size2;
        int sourceEnd = sourceSize;
        return end2 <= sourceEnd;
    }

    @JRubyMethod(name={"hexdump"})
    public IRubyObject hexdump(ThreadContext context) {
        ByteBuffer base = this.base;
        int size2 = this.size;
        if (this.validate() && base != null) {
            RubyString result2 = RubyString.newStringLight(context.runtime, size2 * 3 + size2 / 16 * 12 + 1);
            RubyIOBuffer.hexdump(context, result2, 16, base, size2, true);
            return result2;
        }
        return context.nil;
    }

    private static RubyString hexdump(ThreadContext context, RubyString string2, int width, ByteBuffer base, int size2, boolean first2) {
        byte[] text = new byte[width + 1];
        text[width] = 0;
        for (int offset2 = 0; offset2 < size2; offset2 += width) {
            Arrays.fill(text, (byte)0);
            if (first2) {
                string2.cat("0x".getBytes());
                String hex2 = String.format("0x%08x ", offset2);
                string2.cat(hex2.getBytes());
                first2 = false;
            } else {
                string2.cat(String.format("\n0x%08x ", offset2).getBytes());
            }
            for (int i2 = 0; i2 < width; ++i2) {
                if (offset2 + i2 < size2) {
                    int value2 = Byte.toUnsignedInt(base.get(offset2 + i2));
                    text[i2] = value2 < 127 && value2 >= 32 ? (int)value2 : 46;
                    string2.cat(String.format("%02x", value2).getBytes());
                    continue;
                }
                string2.cat("   ".getBytes());
            }
            string2.cat(32);
            string2.cat(text);
        }
        return string2;
    }

    @JRubyMethod(name={"to_s"})
    public RubyString to_s(ThreadContext context) {
        RubyString result2 = RubyString.newString(context.runtime, "#<");
        result2.append(this.getMetaClass().name(context));
        result2.cat(String.format(" %d+%d", System.identityHashCode(this.base), this.size).getBytes());
        if (this.base == null) {
            result2.cat(" NULL".getBytes());
        }
        if (this.isExternal()) {
            result2.cat(" EXTERNAL".getBytes());
        }
        if (this.isInternal()) {
            result2.cat(" INTERNAL".getBytes());
        }
        if (this.isMapped()) {
            result2.cat(" MAPPED".getBytes());
        }
        if (this.isShared()) {
            result2.cat(" SHARED".getBytes());
        }
        if (this.isLocked()) {
            result2.cat(" LOCKED".getBytes());
        }
        if (this.isReadonly()) {
            result2.cat(" READONLY".getBytes());
        }
        if (this.source != null) {
            result2.cat(" SLICE".getBytes());
        }
        if (!this.validate()) {
            result2.cat(" INVALID".getBytes());
        }
        return result2.cat(">".getBytes());
    }

    @JRubyMethod(name={"size"})
    public IRubyObject size(ThreadContext context) {
        return context.runtime.newFixnum(this.size);
    }

    @JRubyMethod(name={"valid?"})
    public IRubyObject valid_p(ThreadContext context) {
        return RubyBoolean.newBoolean(context, this.validate());
    }

    @JRubyMethod(name={"transfer"})
    public IRubyObject transfer(ThreadContext context) {
        if (this.isLocked()) {
            throw context.runtime.newBufferLockedError("Cannot transfer ownership of locked buffer!");
        }
        RubyIOBuffer instance = new RubyIOBuffer(context.runtime, this.getMetaClass());
        instance.base = this.base;
        instance.size = this.size;
        instance.flags = this.flags;
        instance.source = this.source;
        this.zero(context);
        return instance;
    }

    private void zero(ThreadContext context) {
        this.base = null;
        this.size = 0;
        this.source = null;
    }

    @JRubyMethod(name={"null?"})
    public IRubyObject null_p(ThreadContext context) {
        return RubyBoolean.newBoolean(context, this.base == null);
    }

    @JRubyMethod(name={"empty?"})
    public IRubyObject empty_p(ThreadContext context) {
        return RubyBoolean.newBoolean(context, this.size == 0);
    }

    @JRubyMethod(name={"external?"})
    public IRubyObject external_p(ThreadContext context) {
        return RubyBoolean.newBoolean(context, this.isExternal());
    }

    private boolean isExternal() {
        return (this.flags & 1) == 1;
    }

    @JRubyMethod(name={"internal?"})
    public IRubyObject internal_p(ThreadContext context) {
        return RubyBoolean.newBoolean(context, this.isInternal());
    }

    private boolean isInternal() {
        return (this.flags & 2) == 2;
    }

    @JRubyMethod(name={"mapped?"})
    public IRubyObject mapped_p(ThreadContext context) {
        return RubyBoolean.newBoolean(context, this.isMapped());
    }

    private boolean isMapped() {
        return (this.flags & 4) == 4;
    }

    @JRubyMethod(name={"shared?"})
    public IRubyObject shared_p(ThreadContext context) {
        return RubyBoolean.newBoolean(context, false);
    }

    private boolean isShared() {
        return (this.flags & 8) == 8;
    }

    @JRubyMethod(name={"locked?"})
    public IRubyObject locked_p(ThreadContext context) {
        return RubyBoolean.newBoolean(context, this.isLocked());
    }

    private boolean isLocked() {
        return (this.flags & 0x20) == 32;
    }

    @JRubyMethod(name={"readonly?"})
    public IRubyObject readonly_p(ThreadContext context) {
        return RubyBoolean.newBoolean(context, this.isReadonly());
    }

    private boolean isReadonly() {
        return (this.flags & 0x80) == 128;
    }

    @JRubyMethod(name={"locked"})
    public IRubyObject locked(ThreadContext context, Block block) {
        this.checkLocked(context);
        this.flags |= 0x20;
        IRubyObject result2 = block.yield(context, this);
        this.flags &= 0xFFFFFFDF;
        return result2;
    }

    private void checkLocked(ThreadContext context) {
        if (this.isLocked()) {
            throw context.runtime.newBufferLockedError("Buffer already locked!");
        }
    }

    public IRubyObject lock(ThreadContext context) {
        this.checkLocked(context);
        this.flags |= 0x20;
        return this;
    }

    public IRubyObject unlock(ThreadContext context) {
        if ((this.flags & 0x20) == 0) {
            throw context.runtime.newBufferLockedError("Buffer not locked!");
        }
        this.flags &= 0xFFFFFFDF;
        return this;
    }

    private boolean tryUnlock() {
        if (this.isLocked()) {
            this.flags &= 0xFFFFFFDF;
            return true;
        }
        return false;
    }

    @JRubyMethod(name={"slice"})
    public IRubyObject slice(ThreadContext context) {
        return this.slice(context, 0, this.size);
    }

    @JRubyMethod(name={"slice"})
    public IRubyObject slice(ThreadContext context, IRubyObject _offset) {
        int offset2 = RubyNumeric.num2int(_offset);
        if (offset2 < 0) {
            throw context.runtime.newArgumentError("Offset can't be negative!");
        }
        return this.slice(context, offset2, this.size - offset2);
    }

    @JRubyMethod(name={"slice"})
    public IRubyObject slice(ThreadContext context, IRubyObject _offset, IRubyObject _length) {
        int offset2 = RubyNumeric.num2int(_offset);
        if (offset2 < 0) {
            throw context.runtime.newArgumentError("Offset can't be negative!");
        }
        int length2 = RubyNumeric.num2int(_length);
        if (length2 < 0) {
            throw context.runtime.newArgumentError("Length can't be negative!");
        }
        return this.slice(context, offset2, length2);
    }

    public IRubyObject slice(ThreadContext context, int offset2, int length2) {
        this.validateRange(context, offset2, length2);
        this.base.position(offset2);
        this.base.limit(offset2 + length2);
        ByteBuffer slice2 = this.base.slice();
        this.base.clear();
        return RubyIOBuffer.newBuffer(context.runtime, slice2, length2, this.flags);
    }

    private void validateRange(ThreadContext context, int offset2, int length2) {
        if (offset2 + length2 > this.size) {
            throw context.runtime.newArgumentError("Specified offset+length is bigger than the buffer size!");
        }
    }

    @Override
    @JRubyMethod(name={"<=>"})
    public IRubyObject op_cmp(ThreadContext context, IRubyObject other) {
        return context.runtime.newFixnum(this.base.compareTo(((RubyIOBuffer)other).base));
    }

    @JRubyMethod(name={"resize"})
    public IRubyObject resize(ThreadContext context, IRubyObject size2) {
        this.resize(context, size2.convertToInteger().getIntValue());
        return this;
    }

    public void resize(ThreadContext context, int size2) {
        if (this.isLocked()) {
            throw context.runtime.newBufferLockedError("Cannot resize locked buffer!");
        }
        if (this.base == null) {
            this.initialize(context, null, size2, RubyIOBuffer.flagsForSize(size2), context.nil);
            return;
        }
        if (this.isExternal()) {
            throw context.runtime.newBufferAccessError("Cannot resize external buffer!");
        }
        ByteBuffer newBase = this.base.isDirect() ? ByteBuffer.allocateDirect(size2) : ByteBuffer.allocate(size2);
        this.base.limit(Math.min(size2, this.base.capacity()));
        newBase.put(this.base);
        newBase.clear();
        this.base = newBase;
        this.size = size2;
    }

    @JRubyMethod(name={"clear"})
    public IRubyObject clear(ThreadContext context) {
        return this.clear(context, 0, 0, this.size);
    }

    @JRubyMethod(name={"clear"})
    public IRubyObject clear(ThreadContext context, IRubyObject value2) {
        return this.clear(context, RubyNumeric.num2int(value2), 0, this.size);
    }

    @JRubyMethod(name={"clear"})
    public IRubyObject clear(ThreadContext context, IRubyObject _value, IRubyObject _offset) {
        int value2 = RubyNumeric.num2int(_value);
        int offset2 = RubyNumeric.num2int(_offset);
        return this.clear(context, value2, offset2, this.size - offset2);
    }

    @JRubyMethod(name={"clear"})
    public IRubyObject clear(ThreadContext context, IRubyObject _value, IRubyObject _offset, IRubyObject _length) {
        int value2 = RubyNumeric.num2int(_value);
        int offset2 = RubyNumeric.num2int(_offset);
        int length2 = RubyNumeric.num2int(_length);
        return this.clear(context, value2, offset2, length2);
    }

    private IRubyObject clear(ThreadContext context, int value2, int offset2, int length2) {
        ByteBuffer buffer = this.getBufferForWriting(context);
        if (offset2 + length2 > this.size) {
            throw context.runtime.newArgumentError("The given offset + length out of bounds!");
        }
        if (buffer.hasArray()) {
            Arrays.fill(buffer.array(), offset2, offset2 + length2, (byte)value2);
        }
        return this;
    }

    private ByteBuffer getBufferForWriting(ThreadContext context) {
        if (this.isReadonly()) {
            throw context.runtime.newBufferAccessError("Buffer is not writable!");
        }
        if (this.base != null) {
            return this.base;
        }
        throw context.runtime.newBufferAllocationError("The buffer is not allocated!");
    }

    private ByteBuffer getBufferForReading(ThreadContext context) {
        if (this.base != null) {
            return this.base;
        }
        throw context.runtime.newBufferAllocationError("The buffer is not allocated!");
    }

    @JRubyMethod(name={"free"})
    public IRubyObject free(ThreadContext context) {
        if (this.isLocked()) {
            throw context.runtime.newBufferLockedError("Buffer is locked!");
        }
        this.freeInternal(context);
        return this;
    }

    private boolean freeInternal(ThreadContext context) {
        if (this.base != null) {
            this.base = null;
            this.size = 0;
            this.flags = 0;
            this.source = null;
            return true;
        }
        return false;
    }

    @JRubyMethod(name={"size_of"}, meta=true)
    public static IRubyObject size_of(ThreadContext context, IRubyObject self2, IRubyObject dataType) {
        if (dataType instanceof RubyArray) {
            long total2 = 0L;
            RubyArray array2 = (RubyArray)dataType;
            int size2 = array2.size();
            for (int i2 = 0; i2 < size2; ++i2) {
                Object elt = array2.eltOk(i2);
                total2 += (long)RubyIOBuffer.getDataType(elt).type.size();
            }
        }
        return RubyFixnum.newFixnum(context.runtime, RubyIOBuffer.getDataType(dataType).type.size());
    }

    private boolean isBigEndian() {
        return (this.flags & 8) == 8;
    }

    private boolean isLittleEndian() {
        return (this.flags & 4) == 4;
    }

    private boolean isHostEndian() {
        return (this.flags & 0xC) == HOST_ENDIAN;
    }

    private static DataType getDataType(IRubyObject dataType) {
        return DataType.valueOf(RubySymbol.objectToSymbolString(dataType));
    }

    private static byte readByte(ThreadContext context, ByteBuffer buffer, int offset2) {
        return buffer.get(offset2);
    }

    private static int readUnsignedByte(ThreadContext context, ByteBuffer buffer, int offset2) {
        return Byte.toUnsignedInt(buffer.get(offset2));
    }

    private static void writeByte(ThreadContext context, ByteBuffer buffer, int offset2, byte value2) {
        buffer.put(offset2, value2);
    }

    private static void writeUnsignedByte(ThreadContext context, ByteBuffer buffer, int offset2, int value2) {
        buffer.put(offset2, (byte)value2);
    }

    private static short readShort(ThreadContext context, ByteBuffer buffer, int offset2, ByteOrder order2) {
        short s2 = buffer.getShort(offset2);
        if (order2 == ByteOrder.BIG_ENDIAN) {
            return s2;
        }
        return Short.reverseBytes(s2);
    }

    private static int readUnsignedShort(ThreadContext context, ByteBuffer buffer, int offset2, ByteOrder order2) {
        return Short.toUnsignedInt(RubyIOBuffer.readShort(context, buffer, offset2, order2));
    }

    private static void writeShort(ThreadContext context, ByteBuffer buffer, int offset2, ByteOrder order2, short value2) {
        if (order2 == ByteOrder.BIG_ENDIAN) {
            buffer.putShort(offset2, value2);
            return;
        }
        buffer.putShort(offset2, Short.reverseBytes(value2));
    }

    private static void writeUnsignedShort(ThreadContext context, ByteBuffer buffer, int offset2, ByteOrder order2, int value2) {
        RubyIOBuffer.writeShort(context, buffer, offset2, order2, (short)value2);
    }

    private static int readInt(ThreadContext context, ByteBuffer buffer, int offset2, ByteOrder order2) {
        int i2 = buffer.getInt(offset2);
        if (order2 == ByteOrder.BIG_ENDIAN) {
            return i2;
        }
        return Integer.reverseBytes(i2);
    }

    private static long readUnsignedInt(ThreadContext context, ByteBuffer buffer, int offset2, ByteOrder order2) {
        return Integer.toUnsignedLong(RubyIOBuffer.readInt(context, buffer, offset2, order2));
    }

    private static void writeInt(ThreadContext context, ByteBuffer buffer, int offset2, ByteOrder order2, int value2) {
        if (order2 == ByteOrder.BIG_ENDIAN) {
            buffer.putInt(offset2, value2);
            return;
        }
        buffer.putInt(offset2, Integer.reverseBytes(value2));
    }

    private static void writeUnsignedInt(ThreadContext context, ByteBuffer buffer, int offset2, ByteOrder order2, long value2) {
        RubyIOBuffer.writeInt(context, buffer, offset2, order2, (int)value2);
    }

    private static long readLong(ThreadContext context, ByteBuffer buffer, int offset2, ByteOrder order2) {
        long l = buffer.getLong(offset2);
        if (order2 == ByteOrder.BIG_ENDIAN) {
            return l;
        }
        return Long.reverseBytes(l);
    }

    private static BigInteger readUnsignedLong(ThreadContext context, ByteBuffer buffer, int offset2, ByteOrder order2) {
        long l = RubyIOBuffer.readLong(context, buffer, offset2, order2);
        if (l > 0L) {
            return BigInteger.valueOf(l);
        }
        byte[] bytes2 = new byte[8];
        for (int i2 = 7; i2 >= 0; --i2) {
            bytes2[i2] = (byte)(l & 0xFFL);
            l >>= 8;
        }
        return new BigInteger(1, bytes2);
    }

    private static void writeLong(ThreadContext context, ByteBuffer buffer, int offset2, ByteOrder order2, long value2) {
        if (order2 == ByteOrder.BIG_ENDIAN) {
            buffer.putLong(offset2, value2);
            return;
        }
        buffer.putLong(offset2, Long.reverseBytes(value2));
    }

    private static void writeUnsignedLong(ThreadContext context, ByteBuffer buffer, int offset2, ByteOrder order2, long value2) {
        RubyIOBuffer.writeLong(context, buffer, offset2, order2, value2);
    }

    private static float readFloat(ThreadContext context, ByteBuffer buffer, int offset2, ByteOrder order2) {
        float f = buffer.getFloat(offset2);
        if (order2 == ByteOrder.BIG_ENDIAN) {
            return f;
        }
        return Float.intBitsToFloat(Integer.reverseBytes(Float.floatToIntBits(f)));
    }

    private static void writeFloat(ThreadContext context, ByteBuffer buffer, int offset2, ByteOrder order2, float value2) {
        if (order2 == ByteOrder.BIG_ENDIAN) {
            buffer.putFloat(offset2, value2);
            return;
        }
        buffer.putFloat(offset2, Float.intBitsToFloat(Integer.reverseBytes(Float.floatToIntBits(value2))));
    }

    private static double readDouble(ThreadContext context, ByteBuffer buffer, int offset2, ByteOrder order2) {
        double f = buffer.getDouble(offset2);
        if (order2 == ByteOrder.BIG_ENDIAN) {
            return f;
        }
        return Double.longBitsToDouble(Long.reverseBytes(Double.doubleToLongBits(f)));
    }

    private static void writeDouble(ThreadContext context, ByteBuffer buffer, int offset2, ByteOrder order2, double value2) {
        if (order2 == ByteOrder.BIG_ENDIAN) {
            buffer.putDouble(offset2, value2);
            return;
        }
        buffer.putDouble(offset2, Double.longBitsToDouble(Long.reverseBytes(Double.doubleToLongBits(value2))));
    }

    private static IRubyObject wrap(Ruby runtime2, long value2) {
        return RubyFixnum.newFixnum(runtime2, value2);
    }

    private static IRubyObject wrap(Ruby runtime2, BigInteger value2) {
        return RubyBignum.newBignum(runtime2, value2);
    }

    private static IRubyObject wrap(Ruby runtime2, double value2) {
        return RubyFloat.newFloat(runtime2, value2);
    }

    private static long unwrapLong(IRubyObject value2) {
        return value2.convertToInteger().getLongValue();
    }

    private static double unwrapDouble(IRubyObject value2) {
        return value2.convertToFloat().getDoubleValue();
    }

    private static long unwrapUnsignedLong(IRubyObject value2) {
        return RubyNumeric.num2ulong(value2);
    }

    @JRubyMethod(name={"get_value"})
    public IRubyObject get_value(ThreadContext context, IRubyObject type2, IRubyObject _offset) {
        ByteBuffer buffer = this.getBufferForReading(context);
        DataType dataType = RubyIOBuffer.getDataType(type2);
        int offset2 = RubyNumeric.num2int(_offset);
        int size2 = this.size;
        return RubyIOBuffer.getValue(context, buffer, size2, dataType, offset2);
    }

    private static IRubyObject getValue(ThreadContext context, ByteBuffer buffer, int size2, DataType dataType, int offset2) {
        Ruby runtime2 = context.runtime;
        switch (dataType) {
            case S8: {
                return RubyIOBuffer.wrap(runtime2, RubyIOBuffer.readByte(context, buffer, offset2));
            }
            case U8: {
                return RubyIOBuffer.wrap(runtime2, RubyIOBuffer.readUnsignedByte(context, buffer, offset2));
            }
            case u16: {
                return RubyIOBuffer.wrap(runtime2, RubyIOBuffer.readUnsignedShort(context, buffer, offset2, ByteOrder.LITTLE_ENDIAN));
            }
            case U16: {
                return RubyIOBuffer.wrap(runtime2, RubyIOBuffer.readUnsignedShort(context, buffer, offset2, ByteOrder.BIG_ENDIAN));
            }
            case s16: {
                return RubyIOBuffer.wrap(runtime2, RubyIOBuffer.readShort(context, buffer, offset2, ByteOrder.LITTLE_ENDIAN));
            }
            case S16: {
                return RubyIOBuffer.wrap(runtime2, RubyIOBuffer.readShort(context, buffer, offset2, ByteOrder.BIG_ENDIAN));
            }
            case u32: {
                return RubyIOBuffer.wrap(runtime2, RubyIOBuffer.readUnsignedInt(context, buffer, offset2, ByteOrder.LITTLE_ENDIAN));
            }
            case U32: {
                return RubyIOBuffer.wrap(runtime2, RubyIOBuffer.readUnsignedInt(context, buffer, offset2, ByteOrder.BIG_ENDIAN));
            }
            case s32: {
                return RubyIOBuffer.wrap(runtime2, RubyIOBuffer.readInt(context, buffer, offset2, ByteOrder.LITTLE_ENDIAN));
            }
            case S32: {
                return RubyIOBuffer.wrap(runtime2, RubyIOBuffer.readInt(context, buffer, offset2, ByteOrder.BIG_ENDIAN));
            }
            case u64: {
                return RubyIOBuffer.wrap(runtime2, RubyIOBuffer.readUnsignedLong(context, buffer, offset2, ByteOrder.LITTLE_ENDIAN));
            }
            case U64: {
                return RubyIOBuffer.wrap(runtime2, RubyIOBuffer.readUnsignedLong(context, buffer, offset2, ByteOrder.BIG_ENDIAN));
            }
            case s64: {
                return RubyIOBuffer.wrap(runtime2, RubyIOBuffer.readLong(context, buffer, offset2, ByteOrder.LITTLE_ENDIAN));
            }
            case S64: {
                return RubyIOBuffer.wrap(runtime2, RubyIOBuffer.readLong(context, buffer, offset2, ByteOrder.BIG_ENDIAN));
            }
            case f32: {
                return RubyIOBuffer.wrap(runtime2, RubyIOBuffer.readFloat(context, buffer, offset2, ByteOrder.LITTLE_ENDIAN));
            }
            case F32: {
                return RubyIOBuffer.wrap(runtime2, RubyIOBuffer.readFloat(context, buffer, offset2, ByteOrder.BIG_ENDIAN));
            }
            case f64: {
                return RubyIOBuffer.wrap(runtime2, RubyIOBuffer.readDouble(context, buffer, offset2, ByteOrder.LITTLE_ENDIAN));
            }
            case F64: {
                return RubyIOBuffer.wrap(runtime2, RubyIOBuffer.readDouble(context, buffer, offset2, ByteOrder.BIG_ENDIAN));
            }
        }
        throw runtime2.newArgumentError("Unknown data_type: " + (Object)((Object)dataType));
    }

    @JRubyMethod(name={"get_values"})
    public IRubyObject get_values(ThreadContext context, IRubyObject dataTypes, IRubyObject _offset) {
        Ruby runtime2 = context.runtime;
        int offset2 = RubyNumeric.num2int(_offset);
        int size2 = this.size;
        ByteBuffer buffer = this.getBufferForReading(context);
        if (!(dataTypes instanceof RubyArray)) {
            throw runtime2.newArgumentError("Argument data_types should be an array!");
        }
        RubyArray dataTypesArray = (RubyArray)dataTypes;
        int dataTypesSize = dataTypesArray.size();
        RubyArray values2 = RubyArray.newArray(runtime2, dataTypesSize);
        for (long i2 = 0L; i2 < (long)dataTypesSize; ++i2) {
            Object type2 = dataTypesArray.eltOk(i2);
            DataType dataType = RubyIOBuffer.getDataType(type2);
            IRubyObject value2 = RubyIOBuffer.getValue(context, buffer, size2, dataType, offset2);
            offset2 += dataType.type.size();
            values2.push(value2);
        }
        return values2;
    }

    @JRubyMethod(name={"each"})
    public IRubyObject each(ThreadContext context, IRubyObject _dataType, Block block) {
        if (!block.isGiven()) {
            return RubyEnumerator.enumeratorize(context.runtime, (IRubyObject)this, "each", _dataType);
        }
        ByteBuffer buffer = this.getBufferForReading(context);
        DataType dataType = RubyIOBuffer.getDataType(_dataType);
        return this.each(context, buffer, dataType, 0, this.size, block);
    }

    @JRubyMethod(name={"each"})
    public IRubyObject each(ThreadContext context, IRubyObject _dataType, IRubyObject _offset, Block block) {
        if (!block.isGiven()) {
            return RubyEnumerator.enumeratorize(context.runtime, (IRubyObject)this, "each", Helpers.arrayOf(_dataType, _offset));
        }
        ByteBuffer buffer = this.getBufferForReading(context);
        DataType dataType = RubyIOBuffer.getDataType(_dataType);
        int offset2 = _offset.convertToInteger().getIntValue();
        return this.each(context, buffer, dataType, offset2, this.size - offset2, block);
    }

    @JRubyMethod(name={"each"})
    public IRubyObject each(ThreadContext context, IRubyObject _dataType, IRubyObject _offset, IRubyObject _count, Block block) {
        if (!block.isGiven()) {
            return RubyEnumerator.enumeratorize(context.runtime, (IRubyObject)this, "each", Helpers.arrayOf(_dataType, _offset, _count));
        }
        ByteBuffer buffer = this.getBufferForReading(context);
        DataType dataType = RubyIOBuffer.getDataType(_dataType);
        int offset2 = _offset.convertToInteger().getIntValue();
        int count2 = _count.convertToInteger().getIntValue();
        return this.each(context, buffer, dataType, offset2, count2, block);
    }

    private IRubyObject each(ThreadContext context, ByteBuffer buffer, DataType dataType, int offset2, int count2, Block block) {
        Ruby runtime2 = context.runtime;
        for (int i2 = 0; i2 < count2; ++i2) {
            int currentOffset = offset2;
            IRubyObject value2 = RubyIOBuffer.getValue(context, buffer, this.size, dataType, offset2);
            offset2 += dataType.type.size();
            block.yieldSpecific(context, RubyFixnum.newFixnum(runtime2, currentOffset), value2);
        }
        return this;
    }

    @JRubyMethod(name={"values"})
    public IRubyObject values(ThreadContext context, IRubyObject _dataType) {
        ByteBuffer buffer = this.getBufferForReading(context);
        DataType dataType = RubyIOBuffer.getDataType(_dataType);
        return this.values(context, buffer, dataType, 0, this.size);
    }

    @JRubyMethod(name={"values"})
    public IRubyObject values(ThreadContext context, IRubyObject _dataType, IRubyObject _offset) {
        ByteBuffer buffer = this.getBufferForReading(context);
        DataType dataType = RubyIOBuffer.getDataType(_dataType);
        int offset2 = _offset.convertToInteger().getIntValue();
        return this.values(context, buffer, dataType, offset2, this.size - offset2);
    }

    @JRubyMethod(name={"values"})
    public IRubyObject values(ThreadContext context, IRubyObject _dataType, IRubyObject _offset, IRubyObject _count) {
        ByteBuffer buffer = this.getBufferForReading(context);
        DataType dataType = RubyIOBuffer.getDataType(_dataType);
        int offset2 = _offset.convertToInteger().getIntValue();
        int count2 = _count.convertToInteger().getIntValue();
        return this.values(context, buffer, dataType, offset2, count2);
    }

    private RubyArray values(ThreadContext context, ByteBuffer buffer, DataType dataType, int offset2, int count2) {
        Ruby runtime2 = context.runtime;
        RubyArray values2 = RubyArray.newArray(runtime2, count2);
        for (int i2 = 0; i2 < count2; ++i2) {
            int currentOffset = offset2;
            IRubyObject value2 = RubyIOBuffer.getValue(context, buffer, this.size, dataType, offset2);
            offset2 += dataType.type.size();
            values2.push(value2);
        }
        return values2;
    }

    @JRubyMethod(name={"each_byte"})
    public IRubyObject each_byte(ThreadContext context, Block block) {
        if (!block.isGiven()) {
            return RubyEnumerator.enumeratorize(context.runtime, this, "each_byte");
        }
        ByteBuffer buffer = this.getBufferForReading(context);
        return this.eachByte(context, buffer, 0, this.size, block);
    }

    @JRubyMethod(name={"each_byte"})
    public IRubyObject each_byte(ThreadContext context, IRubyObject _offset, Block block) {
        if (!block.isGiven()) {
            return RubyEnumerator.enumeratorize(context.runtime, (IRubyObject)this, "each_byte", Helpers.arrayOf(_offset));
        }
        ByteBuffer buffer = this.getBufferForReading(context);
        int offset2 = _offset.convertToInteger().getIntValue();
        return this.eachByte(context, buffer, offset2, this.size - offset2, block);
    }

    @JRubyMethod(name={"each_byte"})
    public IRubyObject each_byte(ThreadContext context, IRubyObject _offset, IRubyObject _count, Block block) {
        if (!block.isGiven()) {
            return RubyEnumerator.enumeratorize(context.runtime, (IRubyObject)this, "each_byte", Helpers.arrayOf(_offset, _count));
        }
        ByteBuffer buffer = this.getBufferForReading(context);
        int offset2 = _offset.convertToInteger().getIntValue();
        int count2 = _count.convertToInteger().getIntValue();
        return this.eachByte(context, buffer, offset2, count2, block);
    }

    private IRubyObject eachByte(ThreadContext context, ByteBuffer buffer, int offset2, int count2, Block block) {
        Ruby runtime2 = context.runtime;
        for (int i2 = 0; i2 < count2; ++i2) {
            IRubyObject value2 = RubyIOBuffer.wrap(runtime2, RubyIOBuffer.readByte(context, buffer, offset2 + i2));
            block.yieldSpecific(context, value2);
        }
        return this;
    }

    private static void setValue(ThreadContext context, ByteBuffer buffer, int size2, DataType dataType, int offset2, IRubyObject value2) {
        switch (dataType) {
            case S8: {
                RubyIOBuffer.writeByte(context, buffer, offset2, (byte)RubyIOBuffer.unwrapLong(value2));
                return;
            }
            case U8: {
                RubyIOBuffer.writeUnsignedByte(context, buffer, offset2, (int)RubyIOBuffer.unwrapLong(value2));
                return;
            }
            case u16: {
                RubyIOBuffer.writeUnsignedShort(context, buffer, offset2, ByteOrder.LITTLE_ENDIAN, (int)RubyIOBuffer.unwrapLong(value2));
                return;
            }
            case U16: {
                RubyIOBuffer.writeUnsignedShort(context, buffer, offset2, ByteOrder.BIG_ENDIAN, (int)RubyIOBuffer.unwrapLong(value2));
                return;
            }
            case s16: {
                RubyIOBuffer.writeShort(context, buffer, offset2, ByteOrder.LITTLE_ENDIAN, (short)RubyIOBuffer.unwrapLong(value2));
                return;
            }
            case S16: {
                RubyIOBuffer.writeShort(context, buffer, offset2, ByteOrder.BIG_ENDIAN, (short)RubyIOBuffer.unwrapLong(value2));
                return;
            }
            case u32: {
                RubyIOBuffer.writeUnsignedInt(context, buffer, offset2, ByteOrder.LITTLE_ENDIAN, RubyIOBuffer.unwrapLong(value2));
                return;
            }
            case U32: {
                RubyIOBuffer.writeUnsignedInt(context, buffer, offset2, ByteOrder.BIG_ENDIAN, RubyIOBuffer.unwrapLong(value2));
                return;
            }
            case s32: {
                RubyIOBuffer.writeInt(context, buffer, offset2, ByteOrder.LITTLE_ENDIAN, (int)RubyIOBuffer.unwrapLong(value2));
                return;
            }
            case S32: {
                RubyIOBuffer.writeInt(context, buffer, offset2, ByteOrder.BIG_ENDIAN, (int)RubyIOBuffer.unwrapLong(value2));
                return;
            }
            case u64: {
                RubyIOBuffer.writeUnsignedLong(context, buffer, offset2, ByteOrder.LITTLE_ENDIAN, RubyIOBuffer.unwrapUnsignedLong(value2));
                return;
            }
            case U64: {
                RubyIOBuffer.writeUnsignedLong(context, buffer, offset2, ByteOrder.BIG_ENDIAN, RubyIOBuffer.unwrapUnsignedLong(value2));
                return;
            }
            case s64: {
                RubyIOBuffer.writeLong(context, buffer, offset2, ByteOrder.LITTLE_ENDIAN, RubyIOBuffer.unwrapLong(value2));
                return;
            }
            case S64: {
                RubyIOBuffer.writeLong(context, buffer, offset2, ByteOrder.BIG_ENDIAN, RubyIOBuffer.unwrapLong(value2));
                return;
            }
            case f32: {
                RubyIOBuffer.writeFloat(context, buffer, offset2, ByteOrder.LITTLE_ENDIAN, (float)RubyIOBuffer.unwrapDouble(value2));
                return;
            }
            case F32: {
                RubyIOBuffer.writeFloat(context, buffer, offset2, ByteOrder.BIG_ENDIAN, (float)RubyIOBuffer.unwrapDouble(value2));
                return;
            }
            case f64: {
                RubyIOBuffer.writeDouble(context, buffer, offset2, ByteOrder.LITTLE_ENDIAN, RubyIOBuffer.unwrapDouble(value2));
                return;
            }
            case F64: {
                RubyIOBuffer.writeDouble(context, buffer, offset2, ByteOrder.BIG_ENDIAN, RubyIOBuffer.unwrapDouble(value2));
                return;
            }
        }
        throw context.runtime.newArgumentError("Unknown data_type: " + (Object)((Object)dataType));
    }

    @JRubyMethod(name={"set_value"})
    public IRubyObject set_value(ThreadContext context, IRubyObject _dataType, IRubyObject _offset, IRubyObject _value) {
        ByteBuffer buffer = this.getBufferForWriting(context);
        DataType dataType = RubyIOBuffer.getDataType(_dataType);
        int offset2 = RubyNumeric.num2int(_offset);
        int size2 = this.size;
        RubyIOBuffer.setValue(context, buffer, size2, dataType, offset2, _value);
        return RubyFixnum.newFixnum(context.runtime, offset2 + dataType.type.size());
    }

    @JRubyMethod(name={"set_values"})
    public IRubyObject set_values(ThreadContext context, IRubyObject _dataTypes, IRubyObject _offset, IRubyObject _values) {
        Ruby runtime2 = context.runtime;
        int offset2 = RubyNumeric.num2int(_offset);
        int size2 = this.size;
        ByteBuffer buffer = this.getBufferForWriting(context);
        if (!(_dataTypes instanceof RubyArray)) {
            throw runtime2.newArgumentError("Argument data_types should be an array!");
        }
        RubyArray dataTypes = (RubyArray)_dataTypes;
        if (!(_values instanceof RubyArray)) {
            throw runtime2.newArgumentError("Argument values should be an array!");
        }
        RubyArray values2 = (RubyArray)_values;
        if (dataTypes.size() != values2.size()) {
            throw runtime2.newArgumentError("Argument data_types and values should have the same length!");
        }
        int dataTypesSize = dataTypes.size();
        for (long i2 = 0L; i2 < (long)dataTypesSize; ++i2) {
            Object type2 = dataTypes.eltOk(i2);
            DataType dataType = RubyIOBuffer.getDataType(type2);
            Object value2 = values2.eltOk(i2);
            RubyIOBuffer.setValue(context, buffer, size2, dataType, offset2, value2);
            offset2 += dataType.type.size();
        }
        return RubyFixnum.newFixnum(runtime2, offset2);
    }

    @JRubyMethod(name={"copy"})
    public IRubyObject copy(ThreadContext context, IRubyObject source2) {
        RubyIOBuffer sourceBuffer = (RubyIOBuffer)source2;
        return this.copy(context, sourceBuffer, 0, sourceBuffer.size, 0);
    }

    @JRubyMethod(name={"copy"})
    public IRubyObject copy(ThreadContext context, IRubyObject source2, IRubyObject _offset) {
        RubyIOBuffer sourceBuffer = (RubyIOBuffer)source2;
        int offset2 = RubyNumeric.num2int(_offset);
        return this.copy(context, sourceBuffer, offset2, sourceBuffer.size, 0);
    }

    @JRubyMethod(name={"copy"})
    public IRubyObject copy(ThreadContext context, IRubyObject source2, IRubyObject _offset, IRubyObject _length) {
        RubyIOBuffer sourceBuffer = (RubyIOBuffer)source2;
        int offset2 = RubyNumeric.num2int(_offset);
        int length2 = RubyNumeric.num2int(_length);
        return this.copy(context, sourceBuffer, offset2, length2, 0);
    }

    @JRubyMethod(name={"copy"}, required=1, optional=3, checkArity=false)
    public IRubyObject copy(ThreadContext context, IRubyObject[] args2) {
        Arity.checkArgumentCount(context, args2, 1, 3);
        switch (args2.length) {
            case 1: {
                return this.copy(context, args2[0]);
            }
            case 2: {
                return this.copy(context, args2[0], args2[1]);
            }
            case 3: {
                return this.copy(context, args2[0], args2[1], args2[2]);
            }
            case 4: {
                return this.copy(context, args2[0], args2[1], args2[2], args2[3]);
            }
        }
        return context.nil;
    }

    public IRubyObject copy(ThreadContext context, IRubyObject source2, IRubyObject _offset, IRubyObject _length, IRubyObject _sourceOffset) {
        RubyIOBuffer sourceBuffer = (RubyIOBuffer)source2;
        int offset2 = RubyNumeric.num2int(_offset);
        int length2 = RubyNumeric.num2int(_length);
        int sourceOffset = RubyNumeric.num2int(_sourceOffset);
        return this.copy(context, sourceBuffer, offset2, length2, sourceOffset);
    }

    public IRubyObject copy(ThreadContext context, RubyIOBuffer source2, int offset2, int length2, int sourceOffset) {
        if (sourceOffset > length2) {
            throw context.runtime.newArgumentError("The given source offset is bigger than the source itself!");
        }
        ByteBuffer sourceBuffer = source2.getBufferForReading(context);
        this.bufferCopy(context, offset2, sourceBuffer, sourceOffset, source2.size, length2);
        return RubyFixnum.newFixnum(context.runtime, length2);
    }

    public IRubyObject copy(ThreadContext context, RubyString source2, int offset2, int length2, int sourceOffset) {
        if (sourceOffset > length2) {
            throw context.runtime.newArgumentError("The given source offset is bigger than the source itself!");
        }
        this.bufferCopy(context, offset2, source2.getByteList(), sourceOffset, source2.size(), length2);
        return RubyFixnum.newFixnum(context.runtime, length2);
    }

    private void bufferCopy(ThreadContext context, int offset2, ByteBuffer sourceBuffer, int sourceOffset, int sourceSize, int length2) {
        ByteBuffer destBuffer = this.getBufferForWriting(context);
        sourceBuffer.position(sourceOffset);
        sourceBuffer.limit(sourceOffset + length2);
        if (offset2 == 0) {
            destBuffer.put(sourceBuffer);
        } else {
            destBuffer.position(offset2);
            destBuffer.put(sourceBuffer);
        }
        destBuffer.clear();
        sourceBuffer.clear();
    }

    private void bufferCopy(ThreadContext context, int offset2, ByteList sourceBuffer, int sourceOffset, int sourceSize, int length2) {
        ByteBuffer destBuffer = this.getBufferForWriting(context);
        if (offset2 == 0) {
            destBuffer.put(sourceBuffer.getUnsafeBytes(), sourceBuffer.begin() + sourceOffset, length2);
        } else {
            destBuffer.position(offset2);
            destBuffer.put(sourceBuffer.getUnsafeBytes(), sourceBuffer.begin() + sourceOffset, length2);
        }
        destBuffer.clear();
    }

    @JRubyMethod(name={"get_string"})
    public IRubyObject get_string(ThreadContext context) {
        return this.getString(context, 0, this.size, (Encoding)ASCIIEncoding.INSTANCE);
    }

    @JRubyMethod(name={"get_string"})
    public IRubyObject get_string(ThreadContext context, IRubyObject _offset) {
        int offset2 = RubyIOBuffer.extractOffset(context, _offset);
        return this.getString(context, offset2, this.size, (Encoding)ASCIIEncoding.INSTANCE);
    }

    @JRubyMethod(name={"get_string"})
    public IRubyObject get_string(ThreadContext context, IRubyObject _offset, IRubyObject _length) {
        int offset2 = RubyIOBuffer.extractOffset(context, _offset);
        int length2 = this.extractLength(context, _length, offset2);
        return this.getString(context, offset2, length2, (Encoding)ASCIIEncoding.INSTANCE);
    }

    @JRubyMethod(name={"get_string"})
    public IRubyObject get_string(ThreadContext context, IRubyObject _offset, IRubyObject _length, IRubyObject _encoding) {
        int offset2 = RubyIOBuffer.extractOffset(context, _offset);
        int length2 = this.extractLength(context, _length, offset2);
        Encoding encoding2 = context.runtime.getEncodingService().getEncodingFromObject(_encoding);
        return this.getString(context, offset2, length2, encoding2);
    }

    private IRubyObject getString(ThreadContext context, int offset2, int length2, Encoding encoding2) {
        ByteBuffer buffer = this.getBufferForReading(context);
        this.validateRange(context, offset2, length2);
        byte[] bytes2 = new byte[length2];
        if (offset2 == 0) {
            buffer.get(bytes2, 0, length2);
        } else {
            buffer.position(offset2);
            buffer.get(bytes2, 0, length2);
            buffer.clear();
        }
        return RubyString.newString(context.runtime, bytes2, 0, length2, encoding2);
    }

    @JRubyMethod(name={"set_string"})
    public IRubyObject set_string(ThreadContext context, IRubyObject _string) {
        RubyString string2 = _string.convertToString();
        return this.copy(context, string2, 0, string2.size(), 0);
    }

    @JRubyMethod(name={"set_string"})
    public IRubyObject set_string(ThreadContext context, IRubyObject _string, IRubyObject _offset) {
        RubyString string2 = _string.convertToString();
        int offset2 = RubyIOBuffer.extractOffset(context, _offset);
        return this.copy(context, string2, offset2, string2.size(), 0);
    }

    @JRubyMethod(name={"set_string"})
    public IRubyObject set_string(ThreadContext context, IRubyObject _string, IRubyObject _offset, IRubyObject _length) {
        RubyString string2 = _string.convertToString();
        int offset2 = RubyIOBuffer.extractOffset(context, _offset);
        int length2 = this.extractLength(context, _length, offset2);
        return this.copy(context, string2, offset2, length2, 0);
    }

    @JRubyMethod(name={"set_string"}, required=1, optional=3, checkArity=false)
    public IRubyObject set_string(ThreadContext context, IRubyObject[] args2) {
        Arity.checkArgumentCount(context, args2, 1, 3);
        switch (args2.length) {
            case 1: {
                return this.set_string(context, args2[0]);
            }
            case 2: {
                return this.set_string(context, args2[0], args2[1]);
            }
            case 3: {
                return this.set_string(context, args2[0], args2[1], args2[2]);
            }
            case 4: {
                return this.set_string(context, args2[0], args2[1], args2[2], args2[3]);
            }
        }
        return context.nil;
    }

    public IRubyObject set_string(ThreadContext context, IRubyObject _string, IRubyObject _offset, IRubyObject _length, IRubyObject _stringOffset) {
        RubyString string2 = _string.convertToString();
        int offset2 = RubyNumeric.num2int(_offset);
        int length2 = RubyNumeric.num2int(_length);
        int stringOffset = RubyNumeric.num2int(_stringOffset);
        return this.copy(context, string2, offset2, length2, stringOffset);
    }

    @JRubyMethod(name={"&"})
    public IRubyObject op_and(ThreadContext context, IRubyObject _mask) {
        RubyIOBuffer maskBuffer = (RubyIOBuffer)_mask;
        RubyIOBuffer.checkMask(context, maskBuffer);
        RubyIOBuffer outputBuffer = RubyIOBuffer.newBuffer(context.runtime, this.size, RubyIOBuffer.flagsForSize(this.size));
        RubyIOBuffer.bufferAnd(outputBuffer.base, this.base, this.size, maskBuffer.base, maskBuffer.size);
        return outputBuffer;
    }

    @JRubyMethod(name={"|"})
    public IRubyObject op_or(ThreadContext context, IRubyObject _mask) {
        RubyIOBuffer maskBuffer = (RubyIOBuffer)_mask;
        RubyIOBuffer.checkMask(context, maskBuffer);
        RubyIOBuffer outputBuffer = RubyIOBuffer.newBuffer(context.runtime, this.size, RubyIOBuffer.flagsForSize(this.size));
        RubyIOBuffer.bufferOr(outputBuffer.base, this.base, this.size, maskBuffer.base, maskBuffer.size);
        return outputBuffer;
    }

    @JRubyMethod(name={"^"})
    public IRubyObject op_xor(ThreadContext context, IRubyObject _mask) {
        RubyIOBuffer maskBuffer = (RubyIOBuffer)_mask;
        RubyIOBuffer.checkMask(context, maskBuffer);
        RubyIOBuffer outputBuffer = RubyIOBuffer.newBuffer(context.runtime, this.size, RubyIOBuffer.flagsForSize(this.size));
        RubyIOBuffer.bufferXor(outputBuffer.base, this.base, this.size, maskBuffer.base, maskBuffer.size);
        return outputBuffer;
    }

    @Override
    @JRubyMethod(name={"~"})
    public IRubyObject op_not(ThreadContext context) {
        RubyIOBuffer outputBuffer = RubyIOBuffer.newBuffer(context.runtime, this.size, RubyIOBuffer.flagsForSize(this.size));
        RubyIOBuffer.bufferNot(outputBuffer.base, this.base, this.size);
        return outputBuffer;
    }

    @JRubyMethod(name={"and!"})
    public IRubyObject and_bang(ThreadContext context, IRubyObject _mask) {
        if (!(_mask instanceof RubyIOBuffer)) {
            throw context.runtime.newTypeError(_mask, context.runtime.getIOBuffer());
        }
        RubyIOBuffer maskData = (RubyIOBuffer)_mask;
        RubyIOBuffer.checkMask(context, maskData);
        this.checkOverlaps(context, maskData);
        ByteBuffer base = this.getBufferForWriting(context);
        ByteBuffer maskBase = maskData.getBufferForReading(context);
        RubyIOBuffer.bufferAndInPlace(base, this.size, maskBase, maskData.size);
        return this;
    }

    @JRubyMethod(name={"or!"})
    public IRubyObject or_bang(ThreadContext context, IRubyObject _mask) {
        if (!(_mask instanceof RubyIOBuffer)) {
            throw context.runtime.newTypeError(_mask, context.runtime.getIOBuffer());
        }
        RubyIOBuffer maskData = (RubyIOBuffer)_mask;
        RubyIOBuffer.checkMask(context, maskData);
        this.checkOverlaps(context, maskData);
        ByteBuffer base = this.getBufferForWriting(context);
        ByteBuffer maskBase = maskData.getBufferForReading(context);
        RubyIOBuffer.bufferOrInPlace(base, this.size, maskBase, maskData.size);
        return this;
    }

    @JRubyMethod(name={"xor!"})
    public IRubyObject xor_bang(ThreadContext context, IRubyObject _mask) {
        if (!(_mask instanceof RubyIOBuffer)) {
            throw context.runtime.newTypeError(_mask, context.runtime.getIOBuffer());
        }
        RubyIOBuffer maskData = (RubyIOBuffer)_mask;
        RubyIOBuffer.checkMask(context, maskData);
        this.checkOverlaps(context, maskData);
        ByteBuffer base = this.getBufferForWriting(context);
        ByteBuffer maskBase = maskData.getBufferForReading(context);
        RubyIOBuffer.bufferXorInPlace(base, this.size, maskBase, maskData.size);
        return this;
    }

    @JRubyMethod(name={"not!"})
    public IRubyObject not_bang(ThreadContext context) {
        ByteBuffer base = this.getBufferForWriting(context);
        RubyIOBuffer.bufferNotInPlace(base, this.size);
        return this;
    }

    private static void checkMask(ThreadContext context, RubyIOBuffer buffer) {
        if (buffer.size == 0) {
            throw context.runtime.newBufferMaskError("Zero-length mask given!");
        }
    }

    private void checkOverlaps(ThreadContext context, RubyIOBuffer other) {
        if (this.bufferOverlaps(other)) {
            throw context.runtime.newBufferMaskError("Mask overlaps source data!");
        }
    }

    private boolean bufferOverlaps(RubyIOBuffer other) {
        return this.base != null && this.base.hasArray() && other.base != null && other.base.hasArray() && this.base.array() == other.base.array();
    }

    private static void bufferAnd(ByteBuffer output, ByteBuffer base, int size2, ByteBuffer mask, int maskSize) {
        for (int offset2 = 0; offset2 < size2; ++offset2) {
            output.put(offset2, (byte)(base.get(offset2) & mask.get(offset2 % maskSize)));
        }
    }

    private static void bufferAndInPlace(ByteBuffer a, int aSize, ByteBuffer b2, int bSize) {
        RubyIOBuffer.bufferAnd(a, a, aSize, b2, bSize);
    }

    private static void bufferOr(ByteBuffer output, ByteBuffer base, int size2, ByteBuffer mask, int maskSize) {
        for (int offset2 = 0; offset2 < size2; ++offset2) {
            output.put(offset2, (byte)(base.get(offset2) | mask.get(offset2 % maskSize)));
        }
    }

    private static void bufferOrInPlace(ByteBuffer a, int aSize, ByteBuffer b2, int bSize) {
        RubyIOBuffer.bufferOr(a, a, aSize, b2, bSize);
    }

    private static void bufferXor(ByteBuffer output, ByteBuffer base, int size2, ByteBuffer mask, int maskSize) {
        for (int offset2 = 0; offset2 < size2; ++offset2) {
            output.put(offset2, (byte)(base.get(offset2) ^ mask.get(offset2 % maskSize)));
        }
    }

    private static void bufferXorInPlace(ByteBuffer a, int aSize, ByteBuffer b2, int bSize) {
        RubyIOBuffer.bufferXor(a, a, aSize, b2, bSize);
    }

    private static void bufferNot(ByteBuffer output, ByteBuffer base, int size2) {
        for (int offset2 = 0; offset2 < size2; ++offset2) {
            output.put(offset2, ~base.get(offset2));
        }
    }

    private static void bufferNotInPlace(ByteBuffer a, int aSize) {
        RubyIOBuffer.bufferNot(a, a, aSize);
    }

    @JRubyMethod(name={"read"})
    public IRubyObject read(ThreadContext context, IRubyObject io2) {
        Ruby runtime2;
        IRubyObject result2;
        IRubyObject scheduler = context.getFiberCurrentThread().getSchedulerCurrent();
        if (!scheduler.isNil() && (result2 = FiberScheduler.ioRead(context, scheduler, io2, (IRubyObject)this, RubyFixnum.newFixnum(runtime2 = context.runtime, this.size), RubyFixnum.zero(runtime2))) != UNDEF) {
            return result2;
        }
        return this.read(context, io2, this.size, 0);
    }

    @JRubyMethod(name={"read"})
    public IRubyObject read(ThreadContext context, IRubyObject io2, IRubyObject _length) {
        IRubyObject result2;
        if (_length.isNil()) {
            return this.read(context, io2);
        }
        IRubyObject scheduler = context.getFiberCurrentThread().getSchedulerCurrent();
        RubyInteger lengthInteger = _length.convertToInteger();
        if (!scheduler.isNil() && (result2 = FiberScheduler.ioRead(context, scheduler, io2, (IRubyObject)this, lengthInteger, RubyFixnum.zero(context.runtime))) != null) {
            return result2;
        }
        return this.read(context, io2, lengthInteger.getIntValue(), 0);
    }

    @JRubyMethod(name={"read"})
    public IRubyObject read(ThreadContext context, IRubyObject io2, IRubyObject _length, IRubyObject _offset) {
        RubyInteger lengthInteger;
        int length2;
        IRubyObject scheduler = context.getFiberCurrentThread().getSchedulerCurrent();
        RubyInteger offsetInteger = _offset.convertToInteger();
        int offset2 = offsetInteger.getIntValue();
        if (_length.isNil()) {
            length2 = this.size - offset2;
            lengthInteger = null;
        } else {
            lengthInteger = _length.convertToInteger();
            length2 = lengthInteger.getIntValue();
        }
        if (!scheduler.isNil()) {
            IRubyObject result2;
            if (lengthInteger == null) {
                lengthInteger = RubyFixnum.newFixnum(context.runtime, length2);
            }
            if ((result2 = FiberScheduler.ioRead(context, scheduler, io2, (IRubyObject)this, lengthInteger, offsetInteger)) != UNDEF) {
                return result2;
            }
        }
        return this.read(context, io2, length2, offset2);
    }

    public IRubyObject read(ThreadContext context, IRubyObject io2, int length2, int offset2) {
        this.validateRange(context, offset2, length2);
        ByteBuffer buffer = this.getBufferForWriting(context);
        return RubyIOBuffer.readInternal(context, RubyIO.convertToIO(context, io2), buffer, offset2, length2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static IRubyObject readInternal(ThreadContext context, RubyIO io2, ByteBuffer base, int offset2, int size2) {
        OpenFile fptr = io2.getOpenFileChecked();
        boolean locked2 = fptr.lock();
        try {
            base.position(offset2);
            base.limit(offset2 + size2);
            int result2 = OpenFile.readInternal(context, fptr, fptr.fd(), base, offset2, size2);
            IRubyObject iRubyObject = FiberScheduler.result(context.runtime, result2, fptr.errno());
            return iRubyObject;
        }
        finally {
            base.clear();
            if (locked2) {
                fptr.unlock();
            }
        }
    }

    @JRubyMethod(name={"pread"})
    public IRubyObject pread(ThreadContext context, IRubyObject io2, IRubyObject _from) {
        Ruby runtime2;
        IRubyObject result2;
        IRubyObject scheduler = context.getFiberCurrentThread().getSchedulerCurrent();
        RubyInteger fromInteger = _from.convertToInteger();
        int offset2 = 0;
        int length2 = this.defaultLength(context, offset2);
        if (!scheduler.isNil() && (result2 = FiberScheduler.ioPRead(context, scheduler, io2, (IRubyObject)this, fromInteger, RubyFixnum.newFixnum(runtime2 = context.runtime, length2), RubyFixnum.zero(runtime2))) != UNDEF) {
            return result2;
        }
        int from = RubyNumeric.num2int(_from);
        return this.pread(context, RubyIO.convertToIO(context, io2), from, length2, offset2);
    }

    @JRubyMethod(name={"pread"})
    public IRubyObject pread(ThreadContext context, IRubyObject io2, IRubyObject _from, IRubyObject _length) {
        IRubyObject result2;
        IRubyObject scheduler = context.getFiberCurrentThread().getSchedulerCurrent();
        RubyInteger fromInteger = _from.convertToInteger();
        RubyInteger lengthInteger = _length.convertToInteger();
        if (!scheduler.isNil() && (result2 = FiberScheduler.ioPRead(context, scheduler, io2, (IRubyObject)this, fromInteger, lengthInteger, RubyFixnum.zero(context.runtime))) != UNDEF) {
            return result2;
        }
        int from = RubyNumeric.num2int(fromInteger);
        int offset2 = 0;
        int length2 = this.extractLength(context, lengthInteger, offset2);
        return this.pread(context, RubyIO.convertToIO(context, io2), from, length2, offset2);
    }

    @JRubyMethod(name={"pread"}, required=2, optional=2, checkArity=false)
    public IRubyObject pread(ThreadContext context, IRubyObject[] args2) {
        Arity.checkArgumentCount(context, args2, 2, 4);
        switch (args2.length) {
            case 2: {
                return this.pread(context, args2[0], args2[1]);
            }
            case 3: {
                return this.pread(context, args2[0], args2[1], args2[2]);
            }
            case 4: {
                return this.pread(context, args2[0], args2[1], args2[2], args2[3]);
            }
        }
        return context.nil;
    }

    public IRubyObject pread(ThreadContext context, IRubyObject io2, IRubyObject _from, IRubyObject _length, IRubyObject _offset) {
        IRubyObject result2;
        IRubyObject scheduler = context.getFiberCurrentThread().getSchedulerCurrent();
        RubyInteger fromInteger = _from.convertToInteger();
        RubyInteger lengthInteger = _length.convertToInteger();
        RubyInteger offsetInteger = _offset.convertToInteger();
        if (!scheduler.isNil() && (result2 = FiberScheduler.ioPRead(context, scheduler, io2, (IRubyObject)this, fromInteger, lengthInteger, offsetInteger)) != UNDEF) {
            return result2;
        }
        int from = RubyNumeric.num2int(fromInteger);
        int offset2 = RubyIOBuffer.extractOffset(context, offsetInteger);
        int length2 = this.extractLength(context, lengthInteger, offset2);
        return this.pread(context, RubyIO.convertToIO(context, io2), from, length2, offset2);
    }

    public IRubyObject pread(ThreadContext context, RubyIO io2, int from, int length2, int offset2) {
        this.validateRange(context, offset2, length2);
        ByteBuffer buffer = this.getBufferForWriting(context);
        return RubyIOBuffer.preadInternal(context, io2, buffer, from, offset2, length2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static IRubyObject preadInternal(ThreadContext context, RubyIO io2, ByteBuffer base, int from, int offset2, int size2) {
        OpenFile fptr = io2.getOpenFileChecked();
        boolean locked2 = fptr.lock();
        try {
            base.position(offset2);
            base.limit(offset2 + size2);
            int result2 = OpenFile.preadInternal(context, fptr, fptr.fd(), base, from, size2);
            IRubyObject iRubyObject = FiberScheduler.result(context.runtime, result2, fptr.errno());
            return iRubyObject;
        }
        finally {
            base.clear();
            if (locked2) {
                fptr.unlock();
            }
        }
    }

    private int extractLength(ThreadContext context, IRubyObject _length, int offset2) {
        if (!_length.isNil()) {
            if (RubyNumeric.negativeInt(context, _length)) {
                throw context.runtime.newArgumentError("Length can't be negative!");
            }
            return RubyNumeric.num2int(_length);
        }
        return this.defaultLength(context, offset2);
    }

    private int defaultLength(ThreadContext context, int offset2) {
        if (offset2 > this.size) {
            throw context.runtime.newArgumentError("The given offset is bigger than the buffer size!");
        }
        return this.size - offset2;
    }

    private static int extractOffset(ThreadContext context, IRubyObject _offset) {
        if (RubyNumeric.negativeInt(context, _offset)) {
            throw context.runtime.newArgumentError("Offset can't be negative!");
        }
        return RubyNumeric.num2int(_offset);
    }

    private static int extractSize(ThreadContext context, IRubyObject _size) {
        if (RubyNumeric.negativeInt(context, _size)) {
            throw context.runtime.newArgumentError("Size can't be negative!");
        }
        return RubyNumeric.num2int(_size);
    }

    @JRubyMethod(name={"write"})
    public IRubyObject write(ThreadContext context, IRubyObject io2) {
        Ruby runtime2;
        IRubyObject result2;
        IRubyObject scheduler = context.getFiberCurrentThread().getSchedulerCurrent();
        if (!scheduler.isNil() && (result2 = FiberScheduler.ioWrite(context, scheduler, io2, (IRubyObject)this, RubyFixnum.newFixnum(runtime2 = context.runtime, this.size), RubyFixnum.zero(runtime2))) != null) {
            return result2;
        }
        return this.write(context, io2, this.size, 0);
    }

    @JRubyMethod(name={"write"})
    public IRubyObject write(ThreadContext context, IRubyObject io2, IRubyObject length2) {
        IRubyObject result2;
        IRubyObject scheduler = context.getFiberCurrentThread().getSchedulerCurrent();
        RubyInteger lengthInteger = length2.convertToInteger();
        if (!scheduler.isNil() && (result2 = FiberScheduler.ioWrite(context, scheduler, io2, (IRubyObject)this, lengthInteger, RubyFixnum.zero(context.runtime))) != null) {
            return result2;
        }
        return this.write(context, io2, lengthInteger.getIntValue(), 0);
    }

    @JRubyMethod(name={"write"})
    public IRubyObject write(ThreadContext context, IRubyObject io2, IRubyObject length2, IRubyObject offset2) {
        IRubyObject result2;
        IRubyObject scheduler = context.getFiberCurrentThread().getSchedulerCurrent();
        RubyInteger lengthInteger = length2.convertToInteger();
        RubyInteger offsetInteger = offset2.convertToInteger();
        if (!scheduler.isNil() && (result2 = FiberScheduler.ioWrite(context, scheduler, io2, (IRubyObject)this, lengthInteger, offsetInteger)) != null) {
            return result2;
        }
        return this.write(context, io2, lengthInteger.getIntValue(), offsetInteger.getIntValue());
    }

    public IRubyObject write(ThreadContext context, IRubyObject io2, int length2, int offset2) {
        this.validateRange(context, offset2, length2);
        ByteBuffer buffer = this.getBufferForReading(context);
        return RubyIOBuffer.writeInternal(context, RubyIO.convertToIO(context, io2), buffer, offset2, length2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static IRubyObject writeInternal(ThreadContext context, RubyIO io2, ByteBuffer base, int offset2, int size2) {
        OpenFile fptr = io2.getOpenFileChecked();
        boolean locked2 = fptr.lock();
        try {
            base.position(offset2);
            base.limit(offset2 + size2);
            int result2 = OpenFile.writeInternal(context, fptr, base, offset2, size2);
            IRubyObject iRubyObject = FiberScheduler.result(context.runtime, result2, fptr.errno());
            return iRubyObject;
        }
        finally {
            base.clear();
            if (locked2) {
                fptr.unlock();
            }
        }
    }

    @JRubyMethod(name={"pwrite"})
    public IRubyObject pwrite(ThreadContext context, IRubyObject io2, IRubyObject _from) {
        Ruby runtime2;
        IRubyObject result2;
        IRubyObject scheduler = context.getFiberCurrentThread().getSchedulerCurrent();
        RubyInteger fromInteger = _from.convertToInteger();
        int offset2 = 0;
        int length2 = this.defaultLength(context, offset2);
        if (!scheduler.isNil() && (result2 = FiberScheduler.ioPWrite(context, scheduler, io2, (IRubyObject)this, fromInteger, RubyFixnum.newFixnum(runtime2 = context.runtime, length2), RubyFixnum.zero(runtime2))) != null) {
            return result2;
        }
        int from = RubyNumeric.num2int(fromInteger);
        return this.pwrite(context, RubyIO.convertToIO(context, io2), from, length2, offset2);
    }

    @JRubyMethod(name={"pwrite"})
    public IRubyObject pwrite(ThreadContext context, IRubyObject io2, IRubyObject _from, IRubyObject _length) {
        IRubyObject result2;
        IRubyObject scheduler = context.getFiberCurrentThread().getSchedulerCurrent();
        RubyInteger fromInteger = _from.convertToInteger();
        RubyInteger lengthInteger = _length.convertToInteger();
        if (!scheduler.isNil() && (result2 = FiberScheduler.ioPWrite(context, scheduler, io2, (IRubyObject)this, fromInteger, lengthInteger, RubyFixnum.zero(context.runtime))) != null) {
            return result2;
        }
        int from = RubyNumeric.num2int(fromInteger);
        int offset2 = 0;
        int length2 = this.extractLength(context, lengthInteger, offset2);
        return this.pwrite(context, RubyIO.convertToIO(context, io2), from, length2, offset2);
    }

    @JRubyMethod(name={"pwrite"}, required=2, optional=2, checkArity=false)
    public IRubyObject pwrite(ThreadContext context, IRubyObject[] args2) {
        Arity.checkArgumentCount(context, args2, 2, 4);
        switch (args2.length) {
            case 2: {
                return this.pwrite(context, args2[0], args2[1]);
            }
            case 3: {
                return this.pwrite(context, args2[0], args2[1], args2[2]);
            }
            case 4: {
                return this.pwrite(context, args2[0], args2[1], args2[2], args2[3]);
            }
        }
        return context.nil;
    }

    public IRubyObject pwrite(ThreadContext context, IRubyObject io2, IRubyObject _from, IRubyObject _length, IRubyObject _offset) {
        IRubyObject result2;
        IRubyObject scheduler = context.getFiberCurrentThread().getSchedulerCurrent();
        RubyInteger fromInteger = _from.convertToInteger();
        RubyInteger lengthInteger = _length.convertToInteger();
        RubyInteger offsetInteger = _offset.convertToInteger();
        if (!scheduler.isNil() && (result2 = FiberScheduler.ioPWrite(context, scheduler, io2, (IRubyObject)this, fromInteger, lengthInteger, offsetInteger)) != null) {
            return result2;
        }
        int from = RubyNumeric.num2int(fromInteger);
        int offset2 = RubyIOBuffer.extractOffset(context, offsetInteger);
        int length2 = this.extractLength(context, lengthInteger, offset2);
        return this.pwrite(context, RubyIO.convertToIO(context, io2), from, length2, offset2);
    }

    public IRubyObject pwrite(ThreadContext context, RubyIO io2, int from, int length2, int offset2) {
        this.validateRange(context, offset2, length2);
        ByteBuffer buffer = this.getBufferForReading(context);
        int size2 = this.size - offset2;
        return RubyIOBuffer.pwriteInternal(context, RubyIO.convertToIO(context, io2), buffer, from, offset2, length2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static IRubyObject pwriteInternal(ThreadContext context, RubyIO io2, ByteBuffer base, int from, int offset2, int size2) {
        OpenFile fptr = io2.getOpenFileChecked();
        boolean locked2 = fptr.lock();
        try {
            base.position(offset2);
            base.limit(offset2 + size2);
            int result2 = OpenFile.pwriteInternal(context, fptr, fptr.fd(), base, from, size2);
            IRubyObject iRubyObject = FiberScheduler.result(context.runtime, result2, fptr.errno());
            return iRubyObject;
        }
        finally {
            base.clear();
            if (locked2) {
                fptr.unlock();
            }
        }
    }

    private static long swapAsShort(long l) {
        short s2 = (short)l;
        return s2 >>> 8 | s2 << 8;
    }

    private static short swap(short s2) {
        return (short)(s2 >>> 8 | s2 << 8);
    }

    private static long swapAsInt(long l) {
        int s2 = (int)l;
        return s2 >>> 16 | s2 << 16;
    }

    private static long swapAsLong(long l) {
        return l >>> 32 | l << 32;
    }

    private static long swapAsFloat(long l) {
        return RubyIOBuffer.swapAsInt(l);
    }

    private static long swapAsDouble(long l) {
        return RubyIOBuffer.swapAsLong(l);
    }

    static enum DataType {
        U8(NativeType.UCHAR, 8),
        S8(NativeType.SCHAR, 8),
        u16(NativeType.USHORT, 4),
        U16(NativeType.USHORT, 8),
        s16(NativeType.SSHORT, 4),
        S16(NativeType.SSHORT, 8),
        u32(NativeType.UINT, 4),
        U32(NativeType.UINT, 8),
        s32(NativeType.SINT, 4),
        S32(NativeType.SINT, 8),
        u64(NativeType.ULONG, 4),
        U64(NativeType.ULONG, 8),
        s64(NativeType.SLONG, 4),
        S64(NativeType.SLONG, 8),
        f32(NativeType.FLOAT, 4),
        F32(NativeType.FLOAT, 8),
        f64(NativeType.DOUBLE, 4),
        F64(NativeType.DOUBLE, 8);

        private final Type type;
        private final int endian;

        private DataType(NativeType type2, int endian) {
            this.type = FFI_RUNTIME.findType(type2);
            this.endian = endian;
        }
    }
}

