/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import org.jruby.Ruby;
import org.jruby.RubyBasicObject;
import org.jruby.RubyClass;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.cli.Options;
import org.jruby.util.log.Logger;
import org.jruby.util.log.LoggerFactory;

public final class MetaClass
extends RubyClass {
    private RubyBasicObject attached;
    private static final Logger LOG = LoggerFactory.getLogger(MetaClass.class);
    private static final boolean LOG_SINGLETONS = (Boolean)Options.LOG_SINGLETONS.load();
    private static final boolean LOG_SINGLETONS_VERBOSE = (Boolean)Options.LOG_SINGLETONS_VERBOSE.load();

    @Deprecated
    public MetaClass(Ruby runtime2, RubyClass superClass, IRubyObject attached) {
        this(runtime2, superClass, (RubyBasicObject)attached);
    }

    MetaClass(Ruby runtime2, RubyClass superClass, RubyBasicObject attached) {
        super(runtime2, superClass, false);
        this.attached = attached;
        this.setClassIndex(superClass.getClassIndex());
        superClass.addSubclass(this);
        if (LOG_SINGLETONS || LOG_SINGLETONS_VERBOSE) {
            MetaClass.logSingleton(runtime2, superClass, attached);
        }
    }

    private static void logSingleton(Ruby runtime2, RubyClass superClass, RubyBasicObject attached) {
        if (runtime2.isBooting()) {
            return;
        }
        String attachedString = attached == null ? "null object" : "object of type " + attached.getMetaClass();
        LOG.info("singleton class created for type " + superClass + " attached to " + attachedString, new Object[0]);
        if (LOG_SINGLETONS_VERBOSE) {
            LOG.info(new Exception("singleton creation stack trace"));
        }
    }

    @Override
    public final IRubyObject allocate() {
        throw this.runtime.newTypeError("can't create instance of virtual class");
    }

    @Override
    public boolean isSingleton() {
        return true;
    }

    @Override
    public RubyClass makeMetaClass(RubyClass superClass) {
        MetaClass klass = new MetaClass(this.runtime, this.getSuperSingletonMetaClass(), this);
        this.setMetaClass(klass);
        klass.setMetaClass(klass);
        return klass;
    }

    private RubyClass getSuperSingletonMetaClass() {
        if (this.attached instanceof RubyClass) {
            RubyClass superClass = ((RubyClass)this.attached).getSuperClass();
            if (superClass != null) {
                superClass = superClass.getRealClass();
            }
            if (superClass == null) {
                return this.runtime.getClassClass().getSingletonClass();
            }
            return superClass.getMetaClass().getSingletonClass();
        }
        return this.getSuperClass().getRealClass().getMetaClass();
    }

    @Override
    RubyClass toSingletonClass(RubyBasicObject target2) {
        return this.attached == target2 ? this : super.toSingletonClass(target2);
    }

    public RubyBasicObject getAttached() {
        return this.attached;
    }

    public void setAttached(RubyBasicObject attached) {
        this.attached = attached;
    }
}

