/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.specialized;

import org.jcodings.Encoding;
import org.jcodings.specific.USASCIIEncoding;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyString;
import org.jruby.javasupport.JavaUtil;
import org.jruby.runtime.Block;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.specialized.RubyArraySpecialized;
import org.jruby.util.io.EncodingUtils;

public class RubyArrayOneObject
extends RubyArraySpecialized {
    private IRubyObject value;

    public RubyArrayOneObject(Ruby runtime2, IRubyObject value2) {
        super(runtime2, false);
        this.value = value2;
        this.realLength = 1;
    }

    public RubyArrayOneObject(RubyClass otherClass, IRubyObject value2) {
        super(otherClass, false);
        this.value = value2;
        this.realLength = 1;
    }

    RubyArrayOneObject(RubyArrayOneObject other) {
        this(other.getMetaClass(), other.value);
    }

    RubyArrayOneObject(RubyClass metaClass, RubyArrayOneObject other) {
        this(metaClass, other.value);
    }

    public final IRubyObject eltInternal(int index2) {
        if (!this.packed()) {
            return super.eltInternal(index2);
        }
        if (index2 == 0) {
            return this.value;
        }
        throw new ArrayIndexOutOfBoundsException(index2);
    }

    public final IRubyObject eltInternalSet(int index2, IRubyObject value2) {
        if (!this.packed()) {
            return super.eltInternalSet(index2, value2);
        }
        if (index2 == 0) {
            this.value = value2;
            return this.value;
        }
        throw new ArrayIndexOutOfBoundsException(index2);
    }

    @Override
    protected void finishUnpack(IRubyObject nil) {
        this.value = nil;
    }

    @Override
    public RubyArray aryDup() {
        if (!this.packed()) {
            return super.aryDup();
        }
        return new RubyArrayOneObject(this.getRuntime().getArray(), this);
    }

    @Override
    public IRubyObject rb_clear() {
        if (!this.packed()) {
            return super.rb_clear();
        }
        this.modifyCheck();
        this.value = null;
        this.values = IRubyObject.NULL_ARRAY;
        this.realLength = 0;
        return this;
    }

    @Override
    public void copyInto(IRubyObject[] target, int start2) {
        if (!this.packed()) {
            super.copyInto(target, start2);
            return;
        }
        target[start2] = this.value;
    }

    @Override
    public void copyInto(IRubyObject[] target, int start2, int len) {
        if (!this.packed()) {
            super.copyInto(target, start2, len);
            return;
        }
        if (len != 1) {
            this.unpack();
            super.copyInto(target, start2, len);
            return;
        }
        target[start2] = this.value;
    }

    @Override
    protected RubyArray dupImpl(Ruby runtime2, RubyClass metaClass) {
        if (!this.packed()) {
            return super.dupImpl(runtime2, metaClass);
        }
        return new RubyArrayOneObject(metaClass, this);
    }

    @Override
    public boolean includes(ThreadContext context, IRubyObject item) {
        if (!this.packed()) {
            return super.includes(context, item);
        }
        return RubyArrayOneObject.equalInternal(context, this.value, item);
    }

    @Override
    public int indexOf(Object element) {
        IRubyObject convertedElement;
        if (!this.packed()) {
            return super.indexOf(element);
        }
        if (element != null && (convertedElement = JavaUtil.convertJavaToUsableRubyObject(this.getRuntime(), element)).equals(this.value)) {
            return 0;
        }
        return -1;
    }

    @Override
    protected IRubyObject inspectAry(ThreadContext context) {
        if (!this.packed()) {
            return super.inspectAry(context);
        }
        Ruby runtime2 = context.runtime;
        RubyString str = RubyString.newStringLight(runtime2, 10, (Encoding)USASCIIEncoding.INSTANCE);
        str.cat((byte)91);
        boolean tainted = this.isTaint();
        RubyString s2 = RubyArrayOneObject.inspect(context, this.value);
        if (s2.isTaint()) {
            tainted = true;
        }
        EncodingUtils.encAssociateIndex(str, s2.getEncoding());
        str.cat19(s2);
        str.cat((byte)93);
        if (tainted) {
            str.setTaint(true);
        }
        return str;
    }

    @Override
    protected IRubyObject internalRotate(ThreadContext context, int cnt) {
        if (!this.packed()) {
            return super.internalRotate(context, cnt);
        }
        return this.aryDup();
    }

    @Override
    protected IRubyObject internalRotateBang(ThreadContext context, int cnt) {
        if (!this.packed()) {
            return super.internalRotateBang(context, cnt);
        }
        this.modifyCheck();
        return context.nil;
    }

    @Override
    public IRubyObject op_plus(IRubyObject obj) {
        if (!this.packed()) {
            return super.op_plus(obj);
        }
        RubyArray y = obj.convertToArray();
        if (y.size() == 0) {
            return new RubyArrayOneObject(this);
        }
        return super.op_plus(y);
    }

    @Override
    public IRubyObject replace(IRubyObject orig) {
        if (!this.packed()) {
            return super.replace(orig);
        }
        this.modifyCheck();
        RubyArray origArr = orig.convertToArray();
        if (this == orig) {
            return this;
        }
        if (origArr.size() == 1) {
            this.value = origArr.eltInternal(0);
            return this;
        }
        this.unpack();
        return super.replace(origArr);
    }

    @Override
    public IRubyObject reverse_bang() {
        if (!this.packed()) {
            return super.reverse_bang();
        }
        return this;
    }

    @Override
    protected RubyArray safeReverse() {
        if (!this.packed()) {
            return super.safeReverse();
        }
        return new RubyArrayOneObject(this);
    }

    @Override
    protected IRubyObject sortInternal(ThreadContext context, Block block) {
        if (!this.packed()) {
            return super.sortInternal(context, block);
        }
        return this;
    }

    @Override
    protected IRubyObject sortInternal(ThreadContext context, boolean honorOverride) {
        if (!this.packed()) {
            return super.sortInternal(context, honorOverride);
        }
        return this;
    }

    @Override
    protected void storeInternal(int index2, IRubyObject value2) {
        if (index2 == 0 && this.packed()) {
            this.value = value2;
            return;
        }
        if (this.packed()) {
            this.unpack();
        }
        super.storeInternal(index2, value2);
    }

    @Override
    public IRubyObject subseq(RubyClass metaClass, long beg, long len, boolean light) {
        if (!this.packed()) {
            return super.subseq(metaClass, beg, len, light);
        }
        if (len == 0L) {
            return RubyArrayOneObject.newEmptyArray(metaClass.getClassRuntime());
        }
        if (beg != 0L || len != 1L) {
            this.unpack();
            return super.subseq(metaClass, beg, len, light);
        }
        return new RubyArrayOneObject(metaClass, this);
    }

    @Override
    public IRubyObject[] toJavaArray() {
        if (!this.packed()) {
            return super.toJavaArray();
        }
        return Helpers.arrayOf(this.value, new IRubyObject[0]);
    }

    @Override
    public IRubyObject uniq(ThreadContext context) {
        if (!this.packed()) {
            return super.uniq(context);
        }
        return new RubyArrayOneObject(this);
    }

    @Override
    public RubyArray collectCommon(ThreadContext context, Block block) {
        if (!this.packed()) {
            return super.collectCommon(context, block);
        }
        if (!block.isGiven()) {
            return this.makeShared();
        }
        return new RubyArrayOneObject(context.runtime, block.yieldNonArray(context, this.value, null));
    }

    @Override
    protected RubyArray makeShared() {
        if (!this.packed()) {
            return super.makeShared();
        }
        return new RubyArrayOneObject(this);
    }
}

