/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.model.visitors;

import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.Field;
import org.dmg.pmml.LocalTransformations;
import org.dmg.pmml.Model;
import org.dmg.pmml.PMML;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.TransformationDictionary;
import org.jpmml.model.visitors.FieldDependencyResolver;
import org.jpmml.model.visitors.ModelCleaner;

public class TransformationDictionaryCleaner
extends ModelCleaner {
    @Override
    public PMMLObject popParent() {
        PMML pmml;
        TransformationDictionary transformationDictionary;
        PMMLObject parent = super.popParent();
        if (parent instanceof Model) {
            Model model = (Model)parent;
            LocalTransformations localTransformations = model.getLocalTransformations();
            if (localTransformations != null) {
                this.processLocalTransformations(localTransformations);
                if (!localTransformations.hasDerivedFields()) {
                    model.setLocalTransformations(null);
                }
            }
        } else if (parent instanceof PMML && (transformationDictionary = (pmml = (PMML)parent).getTransformationDictionary()) != null) {
            this.processTransformationDictionary(transformationDictionary);
            if (!transformationDictionary.hasDefineFunctions() && !transformationDictionary.hasDerivedFields()) {
                pmml.setTransformationDictionary(null);
            }
        }
        return parent;
    }

    private void processLocalTransformations(LocalTransformations localTransformations) {
        if (localTransformations.hasDerivedFields()) {
            List<DerivedField> derivedFields = localTransformations.getDerivedFields();
            Set<DerivedField> activeDerivedFields = this.getActiveDerivedFields(new HashSet<DerivedField>(derivedFields));
            derivedFields.retainAll(activeDerivedFields);
        }
    }

    private void processTransformationDictionary(TransformationDictionary transformationDictionary) {
        if (transformationDictionary.hasDerivedFields()) {
            List<DerivedField> derivedFields = transformationDictionary.getDerivedFields();
            Set<DerivedField> activeDerivedFields = this.getActiveDerivedFields(new HashSet<DerivedField>(derivedFields));
            derivedFields.retainAll(activeDerivedFields);
        }
    }

    private Set<DerivedField> getActiveDerivedFields(Set<DerivedField> derivedFields) {
        FieldDependencyResolver fieldDependencyResolver = this.getFieldDependencyResolver();
        Set activeFields = this.getActiveFields();
        HashSet<DerivedField> activeDerivedFields = new HashSet<DerivedField>(derivedFields);
        activeDerivedFields.retainAll(activeFields);
        while (true) {
            LinkedHashSet<Field<DerivedField>> fields = new LinkedHashSet<Field<DerivedField>>(activeDerivedFields);
            fieldDependencyResolver.expand(fields, activeDerivedFields);
            activeFields.addAll(fields);
            fields.retainAll(derivedFields);
            if (fields.isEmpty()) break;
            activeDerivedFields.addAll(fields);
        }
        return activeDerivedFields;
    }
}

