/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.model.visitors;

import java.util.HashSet;
import java.util.Set;
import org.dmg.pmml.Aggregate;
import org.dmg.pmml.BayesInput;
import org.dmg.pmml.CategoricalPredictor;
import org.dmg.pmml.ClusteringField;
import org.dmg.pmml.Discretize;
import org.dmg.pmml.FieldColumnPair;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.FieldRef;
import org.dmg.pmml.FieldValue;
import org.dmg.pmml.FieldValueCount;
import org.dmg.pmml.GeneralRegressionModel;
import org.dmg.pmml.KNNInput;
import org.dmg.pmml.NormContinuous;
import org.dmg.pmml.NormDiscrete;
import org.dmg.pmml.NumericPredictor;
import org.dmg.pmml.PPCell;
import org.dmg.pmml.Predictor;
import org.dmg.pmml.PredictorTerm;
import org.dmg.pmml.SetPredicate;
import org.dmg.pmml.SimplePredicate;
import org.dmg.pmml.SimpleSetPredicate;
import org.dmg.pmml.TestDistributions;
import org.dmg.pmml.TextIndex;
import org.dmg.pmml.Visitable;
import org.dmg.pmml.VisitorAction;
import org.jpmml.model.visitors.AbstractVisitor;

public class FieldReferenceFinder
extends AbstractVisitor {
    private Set<FieldName> names = new HashSet<FieldName>();

    @Override
    public void applyTo(Visitable visitable) {
        this.names.clear();
        super.applyTo(visitable);
    }

    @Override
    public VisitorAction visit(Aggregate aggregate) {
        this.process(aggregate.getField());
        this.process(aggregate.getGroupField());
        return super.visit(aggregate);
    }

    @Override
    public VisitorAction visit(BayesInput bayesInput) {
        this.process(bayesInput.getFieldName());
        return super.visit(bayesInput);
    }

    @Override
    public VisitorAction visit(CategoricalPredictor categoricalPredictor) {
        this.process(categoricalPredictor.getName());
        return super.visit(categoricalPredictor);
    }

    @Override
    public VisitorAction visit(ClusteringField clusteringField) {
        this.process(clusteringField.getField());
        return super.visit(clusteringField);
    }

    @Override
    public VisitorAction visit(Discretize discretize) {
        this.process(discretize.getField());
        return super.visit(discretize);
    }

    @Override
    public VisitorAction visit(FieldColumnPair fieldColumnPair) {
        this.process(fieldColumnPair.getField());
        return super.visit(fieldColumnPair);
    }

    @Override
    public VisitorAction visit(FieldRef fieldRef) {
        this.process(fieldRef.getField());
        return super.visit(fieldRef);
    }

    @Override
    public VisitorAction visit(FieldValue fieldValue) {
        this.process(fieldValue.getField());
        return super.visit(fieldValue);
    }

    @Override
    public VisitorAction visit(FieldValueCount fieldValueCount) {
        this.process(fieldValueCount.getField());
        return super.visit(fieldValueCount);
    }

    @Override
    public VisitorAction visit(GeneralRegressionModel generalRegressionModel) {
        GeneralRegressionModel.ModelType modelType = generalRegressionModel.getModelType();
        switch (modelType) {
            case COX_REGRESSION: {
                this.process(generalRegressionModel.getBaselineStrataVariable());
                this.process(generalRegressionModel.getEndTimeVariable());
                this.process(generalRegressionModel.getStartTimeVariable());
                this.process(generalRegressionModel.getStatusVariable());
                this.process(generalRegressionModel.getSubjectIDVariable());
            }
        }
        this.process(generalRegressionModel.getOffsetVariable());
        this.process(generalRegressionModel.getTrialsVariable());
        return super.visit(generalRegressionModel);
    }

    @Override
    public VisitorAction visit(KNNInput knnInput) {
        this.process(knnInput.getField());
        return super.visit(knnInput);
    }

    @Override
    public VisitorAction visit(NormContinuous normContinuous) {
        this.process(normContinuous.getField());
        return super.visit(normContinuous);
    }

    @Override
    public VisitorAction visit(NormDiscrete normDiscrete) {
        this.process(normDiscrete.getField());
        return super.visit(normDiscrete);
    }

    @Override
    public VisitorAction visit(NumericPredictor numericPredictor) {
        this.process(numericPredictor.getName());
        return super.visit(numericPredictor);
    }

    @Override
    public VisitorAction visit(PPCell ppCell) {
        this.process(ppCell.getPredictorName());
        return super.visit(ppCell);
    }

    @Override
    public VisitorAction visit(Predictor predictor) {
        this.process(predictor.getName());
        return super.visit(predictor);
    }

    @Override
    public VisitorAction visit(PredictorTerm predictorTerm) {
        this.process(predictorTerm.getName());
        return super.visit(predictorTerm);
    }

    @Override
    public VisitorAction visit(SetPredicate setPredicate) {
        this.process(setPredicate.getField());
        return super.visit(setPredicate);
    }

    @Override
    public VisitorAction visit(SimplePredicate simplePredicate) {
        this.process(simplePredicate.getField());
        return super.visit(simplePredicate);
    }

    @Override
    public VisitorAction visit(SimpleSetPredicate simpleSetPredicate) {
        this.process(simpleSetPredicate.getField());
        return super.visit(simpleSetPredicate);
    }

    @Override
    public VisitorAction visit(TestDistributions testDistributions) {
        this.process(testDistributions.getField());
        this.process(testDistributions.getWeightField());
        return super.visit(testDistributions);
    }

    @Override
    public VisitorAction visit(TextIndex textIndex) {
        this.process(textIndex.getTextField());
        return super.visit(textIndex);
    }

    public Set<FieldName> getFieldNames() {
        return this.names;
    }

    private void process(FieldName name) {
        if (name == null) {
            return;
        }
        this.names.add(name);
    }
}

