/*
 * Decompiled with CFR 0.152.
 */
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.dmg.pmml.EmbeddedModel;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.LocalTransformations;
import org.dmg.pmml.MiningFunctionType;
import org.dmg.pmml.MissingValueStrategyType;
import org.dmg.pmml.ModelStats;
import org.dmg.pmml.NoTrueChildStrategyType;
import org.dmg.pmml.Node;
import org.dmg.pmml.Output;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.ResultField;
import org.dmg.pmml.Targets;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.jpmml.schema.Added;
import org.jpmml.schema.Deprecated;
import org.jpmml.schema.Version;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="", propOrder={"extensions", "output", "modelStats", "targets", "localTransformations", "resultFields", "node"})
@XmlRootElement(name="DecisionTree", namespace="http://www.dmg.org/PMML-4_2")
@Deprecated(value=Version.PMML_4_1)
public class DecisionTree
extends EmbeddedModel
implements HasExtensions {
    @XmlAttribute(name="modelName")
    private String modelName;
    @XmlAttribute(name="functionName", required=true)
    private MiningFunctionType functionName;
    @XmlAttribute(name="algorithmName")
    private String algorithmName;
    @XmlAttribute(name="missingValueStrategy")
    @Added(value=Version.PMML_3_1)
    private MissingValueStrategyType missingValueStrategy;
    @XmlAttribute(name="missingValuePenalty")
    @Added(value=Version.PMML_3_1)
    private Double missingValuePenalty;
    @XmlAttribute(name="noTrueChildStrategy")
    @Added(value=Version.PMML_3_1)
    private NoTrueChildStrategyType noTrueChildStrategy;
    @XmlAttribute(name="splitCharacteristic")
    private SplitCharacteristic splitCharacteristic;
    @XmlElement(name="Extension", namespace="http://www.dmg.org/PMML-4_2")
    private List<Extension> extensions;
    @XmlElement(name="Output", namespace="http://www.dmg.org/PMML-4_2")
    @Added(value=Version.PMML_4_0)
    private Output output;
    @XmlElement(name="ModelStats", namespace="http://www.dmg.org/PMML-4_2")
    @Added(value=Version.PMML_4_0)
    private ModelStats modelStats;
    @XmlElement(name="Targets", namespace="http://www.dmg.org/PMML-4_2")
    @Added(value=Version.PMML_4_0)
    private Targets targets;
    @XmlElement(name="LocalTransformations", namespace="http://www.dmg.org/PMML-4_2")
    private LocalTransformations localTransformations;
    @XmlElement(name="ResultField", namespace="http://www.dmg.org/PMML-4_2")
    private List<ResultField> resultFields;
    @XmlElement(name="Node", namespace="http://www.dmg.org/PMML-4_2", required=true)
    private Node node;
    private static final Double DEFAULT_MISSING_VALUE_PENALTY = 1.0;

    public DecisionTree() {
    }

    public DecisionTree(MiningFunctionType functionName, Node node) {
        this.functionName = functionName;
        this.node = node;
    }

    @Override
    public String getModelName() {
        return this.modelName;
    }

    @Override
    public DecisionTree setModelName(String modelName) {
        this.modelName = modelName;
        return this;
    }

    @Override
    public MiningFunctionType getFunctionName() {
        return this.functionName;
    }

    @Override
    public DecisionTree setFunctionName(MiningFunctionType functionName) {
        this.functionName = functionName;
        return this;
    }

    public String getAlgorithmName() {
        return this.algorithmName;
    }

    public DecisionTree setAlgorithmName(String algorithmName) {
        this.algorithmName = algorithmName;
        return this;
    }

    public MissingValueStrategyType getMissingValueStrategy() {
        if (this.missingValueStrategy == null) {
            return MissingValueStrategyType.NONE;
        }
        return this.missingValueStrategy;
    }

    public DecisionTree setMissingValueStrategy(MissingValueStrategyType missingValueStrategy) {
        this.missingValueStrategy = missingValueStrategy;
        return this;
    }

    public Double getMissingValuePenalty() {
        if (this.missingValuePenalty == null) {
            return DEFAULT_MISSING_VALUE_PENALTY;
        }
        return this.missingValuePenalty;
    }

    public DecisionTree setMissingValuePenalty(Double missingValuePenalty) {
        this.missingValuePenalty = missingValuePenalty;
        return this;
    }

    public NoTrueChildStrategyType getNoTrueChildStrategy() {
        if (this.noTrueChildStrategy == null) {
            return NoTrueChildStrategyType.RETURN_NULL_PREDICTION;
        }
        return this.noTrueChildStrategy;
    }

    public DecisionTree setNoTrueChildStrategy(NoTrueChildStrategyType noTrueChildStrategy) {
        this.noTrueChildStrategy = noTrueChildStrategy;
        return this;
    }

    public SplitCharacteristic getSplitCharacteristic() {
        if (this.splitCharacteristic == null) {
            return SplitCharacteristic.MULTI_SPLIT;
        }
        return this.splitCharacteristic;
    }

    public DecisionTree setSplitCharacteristic(SplitCharacteristic splitCharacteristic) {
        this.splitCharacteristic = splitCharacteristic;
        return this;
    }

    @Override
    public List<Extension> getExtensions() {
        if (this.extensions == null) {
            this.extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public Output getOutput() {
        return this.output;
    }

    @Override
    public DecisionTree setOutput(Output output) {
        this.output = output;
        return this;
    }

    @Override
    public ModelStats getModelStats() {
        return this.modelStats;
    }

    @Override
    public DecisionTree setModelStats(ModelStats modelStats) {
        this.modelStats = modelStats;
        return this;
    }

    @Override
    public Targets getTargets() {
        return this.targets;
    }

    @Override
    public DecisionTree setTargets(Targets targets) {
        this.targets = targets;
        return this;
    }

    @Override
    public LocalTransformations getLocalTransformations() {
        return this.localTransformations;
    }

    @Override
    public DecisionTree setLocalTransformations(LocalTransformations localTransformations) {
        this.localTransformations = localTransformations;
        return this;
    }

    public List<ResultField> getResultFields() {
        if (this.resultFields == null) {
            this.resultFields = new ArrayList<ResultField>();
        }
        return this.resultFields;
    }

    public Node getNode() {
        return this.node;
    }

    public DecisionTree setNode(Node node) {
        this.node = node;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return this.extensions != null && this.extensions.size() > 0;
    }

    public DecisionTree addExtensions(Extension ... extensions) {
        this.getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public boolean hasResultFields() {
        return this.resultFields != null && this.resultFields.size() > 0;
    }

    public DecisionTree addResultFields(ResultField ... resultFields) {
        this.getResultFields().addAll(Arrays.asList(resultFields));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if (status == VisitorAction.CONTINUE && this.hasExtensions()) {
                status = PMMLObject.traverse(visitor, this.getExtensions());
            }
            if (status == VisitorAction.CONTINUE) {
                status = PMMLObject.traverse(visitor, this.getOutput(), this.getModelStats(), this.getTargets(), this.getLocalTransformations());
            }
            if (status == VisitorAction.CONTINUE && this.hasResultFields()) {
                status = PMMLObject.traverse(visitor, this.getResultFields());
            }
            if (status == VisitorAction.CONTINUE) {
                status = PMMLObject.traverse(visitor, this.getNode());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

    @XmlType(name="")
    @XmlEnum
    public static enum SplitCharacteristic {
        BINARY_SPLIT("binarySplit"),
        MULTI_SPLIT("multiSplit");

        private final String value;

        private SplitCharacteristic(String v) {
            this.value = v;
        }

        public String value() {
            return this.value;
        }

        public static SplitCharacteristic fromValue(String v) {
            for (SplitCharacteristic c : SplitCharacteristic.values()) {
                if (!c.value.equals(v)) continue;
                return c;
            }
            throw new IllegalArgumentException(v);
        }
    }
}

